/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgPolyline;
import org.gvsig.dwg.lib.IDwgVertex;
import org.gvsig.dwg.lib.objects.DwgSeqend;
import org.gvsig.dwg.lib.objects.DwgVertexPFaceFace;
import org.gvsig.dwg.lib.util.FMapUtil;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwgPFacePolyline
extends DwgObject
implements IDwgPolyline,
IDwg2FMap,
IDwgBlockMember {
    private static Logger logger = LoggerFactory.getLogger((String)DwgPFacePolyline.class.getName());
    public static final int NUM_VERTEX_OF_FACE = 4;
    private int vertexCount;
    private int faceCount;
    private DwgHandleReference firstVertexHandle;
    private DwgHandleReference lastVertexHandle;
    private DwgHandleReference seqendHandle;
    private List vertices = new ArrayList();
    private List faces = new ArrayList();
    private ArrayList ownedObjectsHandles = new ArrayList();

    public DwgPFacePolyline(int index) {
        super(index);
    }

    public void setVertexCount(int vertexCount) {
        this.vertexCount = vertexCount;
    }

    public void setFaceCount(int faceCount) {
        this.faceCount = faceCount;
    }

    public void setFirstVertexHandle(DwgHandleReference handle) {
        this.firstVertexHandle = handle;
    }

    public void setLastVertexHandle(DwgHandleReference handle) {
        this.lastVertexHandle = handle;
    }

    public void setSeqendHandle(DwgHandleReference handle) {
        this.seqendHandle = handle;
    }

    public int getFaceCount() {
        return this.faceCount;
    }

    public DwgHandleReference getFirstVertexHandle() {
        return this.firstVertexHandle;
    }

    public DwgHandleReference getLastVertexHandle() {
        return this.lastVertexHandle;
    }

    public DwgHandleReference getSeqendHandle() {
        return this.seqendHandle;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    public Object clone() {
        DwgPFacePolyline obj = new DwgPFacePolyline(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgPFacePolyline myObj = (DwgPFacePolyline)obj;
        myObj.setFaceCount(this.faceCount);
        myObj.setFirstVertexHandle(this.firstVertexHandle);
        myObj.setLastVertexHandle(this.lastVertexHandle);
        myObj.setSeqendHandle(this.seqendHandle);
        myObj.setVertexCount(this.vertexCount);
        myObj.setVertices(this.vertices);
        myObj.setFaces(this.faces);
    }

    public void setFaces(List faces) {
        this.faces = faces;
    }

    public List getFaces() {
        return this.faces;
    }

    public List getVertices() {
        return this.vertices;
    }

    public void setVertices(List vertices) {
        this.vertices = vertices;
    }

    public ArrayList getOwnedObjectsHandles() {
        return this.ownedObjectsHandles;
    }

    public void setOwnedObjectsHandles(ArrayList handles) {
        this.ownedObjectsHandles = handles;
    }

    public void addOwnedObjectHandle(DwgHandleReference handle) {
        this.ownedObjectsHandles.add(handle);
    }

    @Override
    public void calculateGisModel(DwgFile dwgFile) {
        if (this.firstVertexHandle != null && this.lastVertexHandle != null) {
            DwgObject first = dwgFile.getDwgObjectFromHandle(this.firstVertexHandle.getOffset());
            DwgObject last = dwgFile.getDwgObjectFromHandle(this.lastVertexHandle.getOffset());
            if (first == null || last == null) {
                logger.warn("DwgPFacePolyline con vertices inicial o final a null");
                return;
            }
            if (!(first instanceof IDwgVertex)) {
                logger.warn("El primer vertice de PFacePolyline es " + first.getClass().getName());
                return;
            }
            if (!(last instanceof IDwgVertex)) {
                logger.warn("El ultimo vertice de PFacePolyline es " + last.getClass().getName());
                return;
            }
            int firstObjIdx = dwgFile.getIndexOf(first);
            int lastObjIdx = dwgFile.getIndexOf(last);
            if (firstObjIdx == -1 || lastObjIdx == -1) {
                logger.warn("Calculate GIS Model: Problemas en la localizacion de vertices: primero =" + firstObjIdx + ",Ultimo =" + lastObjIdx);
                return;
            }
            for (int i = firstObjIdx; i <= lastObjIdx; ++i) {
                DwgObject obj = dwgFile.getDwgObject(i);
                if (obj instanceof IDwgVertex) {
                    this.addVertex((IDwgVertex)((Object)obj));
                    continue;
                }
                if (!(obj instanceof DwgSeqend)) {
                    logger.warn("Encontrado " + obj.getClass().getName() + " en la lista de vertices de Polyline3D");
                    continue;
                }
                break;
            }
        } else {
            logger.warn("Encontrada polil\u00c3\u00adnea sin puntos ...");
        }
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        GeometryManager gMan = GeometryLocator.getGeometryManager();
        int subType = this.getGeometrySubType(is3DFile);
        MultiSurface solution = (MultiSurface)gMan.create(this.getGeometryType(), subType);
        if (this.vertices != null && this.faces != null) {
            if (this.vertices.size() == 0 || this.faces.size() == 0) {
                return gMan.createNullGeometry(subType);
            }
            int numFaces = this.faces.size();
            for (int i = 0; i < numFaces; ++i) {
                DwgVertexPFaceFace face = (DwgVertexPFaceFace)this.faces.get(i);
                int[] verticesId = face.getVerticesidx();
                ArrayList<double[]> pts = new ArrayList<double[]>();
                boolean lastWasInvisible = true;
                for (int j = 0; j < 4; ++j) {
                    if (verticesId[j] > 0) {
                        if (lastWasInvisible) {
                            pts.clear();
                            lastWasInvisible = false;
                        }
                        try {
                            pts.add((double[])this.vertices.get(verticesId[j] - 1));
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        continue;
                    }
                    if (verticesId[j] >= 0 || lastWasInvisible) continue;
                    lastWasInvisible = true;
                    pts.add((double[])this.vertices.get(verticesId[j] * -1 - 1));
                }
                solution.addSurface(FMapUtil.ptsToPolygon(pts, subType));
            }
        }
        return solution;
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPolyline3D";
        }
        return "FPolyline2D";
    }

    @Override
    public String toString() {
        return "PFacePolyline";
    }

    @Override
    public void addVertex(IDwgVertex vertex) {
        if (vertex instanceof DwgVertexPFaceFace) {
            this.faces.add(vertex);
        } else {
            this.vertices.add(vertex);
        }
    }

    public void dump() {
        Object[] point;
        IDwgVertex vertex;
        int i;
        System.out.println("<PFacePolyline vertexCount=" + this.vertexCount + " faceCount" + this.faceCount + ">");
        int numRealVertex = 1;
        for (i = 0; i < this.vertices.size(); ++i) {
            vertex = (IDwgVertex)this.vertices.get(i);
            point = vertex.getPoint();
            System.out.println("<Vertex idx=" + numRealVertex + " class=" + vertex.getClass().getName() + " x=" + point[0] + " y=" + point[1] + " z=" + point[2] + " >");
            ++numRealVertex;
        }
        for (i = 0; i < this.faces.size(); ++i) {
            vertex = (IDwgVertex)this.faces.get(i);
            if (!(vertex instanceof DwgVertexPFaceFace)) continue;
            point = ((DwgVertexPFaceFace)vertex).getVerticesidx();
            System.out.println("<Vertex class=" + vertex.getClass().getName() + " 1=" + (int)point[0] + " 2=" + (int)point[1] + " 3=" + (int)point[2] + " 4=" + (int)point[3] + ">");
        }
        System.out.println("</PFacePolyline>");
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handle_objectsWithoutBlocks, DwgFile callBack) {
        DwgPFacePolyline transformedEntity = null;
        List vertices = this.getVertices();
        if (vertices != null) {
            if (vertices.size() == 0) {
                return;
            }
            ArrayList<IDwgVertex> transformedVertices = new ArrayList<IDwgVertex>();
            for (int i = 0; i < vertices.size(); ++i) {
                double[] pointAux = null;
                IDwgVertex vertex = (IDwgVertex)vertices.get(i);
                if (vertex instanceof DwgVertexPFaceFace) continue;
                double[] point = vertex.getPoint();
                pointAux = new double[]{point[0] - bPoint[0], point[1] - bPoint[1], point[2] - bPoint[2]};
                double laX = insPoint.getX() + (pointAux[0] * scale[0] * Math.cos(rot) + pointAux[1] * scale[1] * -1.0 * Math.sin(rot));
                double laY = insPoint.getY() + (pointAux[0] * scale[0] * Math.sin(rot) + pointAux[1] * scale[1] * Math.cos(rot));
                double laZ = pointAux[2];
                vertex.setPoint(new double[]{laX, laY, laZ});
                transformedVertices.add(vertex);
            }
            transformedEntity = (DwgPFacePolyline)this.clone();
            this.fill(transformedEntity);
            dwgObjectsWithoutBlocks.add(transformedEntity);
            handle_objectsWithoutBlocks.put(new Integer(transformedEntity.getHandle().getOffset()), transformedEntity);
        }
    }

    @Override
    public int getGeometryType() {
        return 9;
    }
}

