/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgObjectFactory;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgPolyline;
import org.gvsig.dwg.lib.IDwgVertex;
import org.gvsig.dwg.lib.objects.DwgArc;
import org.gvsig.dwg.lib.objects.DwgBlockHeader;
import org.gvsig.dwg.lib.objects.DwgCircle;
import org.gvsig.dwg.lib.objects.DwgEndblk;
import org.gvsig.dwg.lib.objects.DwgInsert;
import org.gvsig.dwg.lib.objects.DwgLayer;
import org.gvsig.dwg.lib.objects.DwgLine;
import org.gvsig.dwg.lib.objects.DwgMeshPolyline;
import org.gvsig.dwg.lib.objects.DwgPFacePolyline;
import org.gvsig.dwg.lib.objects.DwgPoint;
import org.gvsig.dwg.lib.objects.DwgPolyline2D;
import org.gvsig.dwg.lib.objects.DwgPolyline3D;
import org.gvsig.dwg.lib.objects.DwgSeqend;
import org.gvsig.dwg.lib.objects.DwgSolid;
import org.gvsig.dwg.lib.objects.DwgText;
import org.gvsig.dwg.lib.objects.DwgVertex2D;
import org.gvsig.dwg.lib.objects.DwgVertex3D;
import org.gvsig.dwg.lib.objects.DwgVertexPFace;
import org.gvsig.dwg.lib.objects.DwgVertexPFaceFace;
import org.gvsig.dwg.lib.readers.IDwgFileReader;

public class DwgFileV12Reader
implements IDwgFileReader {
    private DwgFile dwgFile;
    private ByteBuffer bb;
    ArrayList readers = new ArrayList();
    private boolean r13 = false;
    int index = 0;
    ArrayList blocks = new ArrayList();

    public DwgFileV12Reader(boolean isR13) {
        this.r13 = isR13;
        this.readers.add(null);
        this.readers.add(new LineReader());
        this.readers.add(new PointReader());
        this.readers.add(new CircleReader());
        this.readers.add(new ShapeReader());
        this.readers.add(null);
        this.readers.add(null);
        this.readers.add(new TextReader());
        this.readers.add(new ArcReader());
        this.readers.add(new TraceReader());
        this.readers.add(null);
        this.readers.add(new SolidReader());
        this.readers.add(new BlkReader());
        this.readers.add(new EndBlkReader());
        this.readers.add(new InsertReader());
        this.readers.add(new AttDefReader());
        this.readers.add(new AttribReader());
        this.readers.add(new SbEndReader());
        this.readers.add(null);
        this.readers.add(new PlineReader());
        this.readers.add(new VertexReader());
        this.readers.add(null);
        this.readers.add(new Face3DReader());
        this.readers.add(new DimReader());
        this.readers.add(new VPortReader());
    }

    @Override
    public void read(DwgFile dwgFile, ByteBuffer bb) throws IOException {
        this.dwgFile = dwgFile;
        this.bb = bb;
        try {
            bb.position(0);
            byte[] header = new byte[12];
            bb.get(header);
            String headerStr = new String(header);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            byte b1 = bb.get();
            short w1 = bb.getShort();
            short w2 = bb.getShort();
            short w3 = bb.getShort();
            byte b2 = bb.get();
            bb.order(ByteOrder.LITTLE_ENDIAN);
            int eStart = bb.getInt();
            int eEnd = bb.getInt();
            int bsStart = bb.getInt();
            int l1 = bb.getInt();
            int bsEnd = bb.getInt();
            int l2 = bb.getInt();
            Dwg12Table blockTable = this.getTable();
            Dwg12Table layerTable = this.getTable();
            Dwg12Table styleTable = this.getTable();
            Dwg12Table lineTypeTable = this.getTable();
            Dwg12Table viewTable = this.getTable();
            this.readHeader();
            Dwg12Table ucsTable = this.getTable();
            bb.position(1280);
            Dwg12Table vportTable = this.getTable();
            bb.position(bb.position() + 8);
            Dwg12Table appidTable = this.getTable();
            bb.position(bb.position() + 6);
            Dwg12Table dimStyleTable = this.getTable();
            bb.position(1695);
            Dwg12Table p13table = this.getTable();
            bb.position(bb.position() + 38);
            int currentPosition = bb.position();
            if (currentPosition != eStart) {
                throw new RuntimeException("Error: no se ha llegado al principio de las entidades de dibujo");
            }
            this.readEntities(eStart, eEnd);
            bb.position(bb.position() + 19);
            this.readBlockTable(blockTable);
            this.readLayerTable(layerTable);
            this.readEntities(bsStart, bsEnd);
            bb.position(bb.position() + 36);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            int peStart = bb.getInt();
            int peEnd = bb.getInt();
            int pbStart = bb.getInt();
            int pbEnd = bb.getInt();
            if (peStart != eStart) {
                System.out.println("peStart=" + peStart + " eStart=" + eStart);
            }
            if (peEnd != eEnd) {
                System.out.println("peStart=" + peEnd + " eStart=" + eEnd);
            }
            if (pbStart != bsStart) {
                System.out.println("peStart=" + pbStart + " eStart=" + bsStart);
            }
            if (bsEnd != pbEnd) {
                System.out.println("peStart=" + pbStart + " eStart=" + bsStart);
            }
            bb.position(bb.position() + 12);
            Dwg12TableTest bts = this.getTableTest();
            Dwg12TableTest lyrTs = this.getTableTest();
            Dwg12TableTest sts = this.getTableTest();
            Dwg12TableTest ltts = this.getTableTest();
            Dwg12TableTest vts = this.getTableTest();
            Dwg12TableTest uts = this.getTableTest();
            Dwg12TableTest vpts = this.getTableTest();
            Dwg12TableTest ats = this.getTableTest();
            Dwg12TableTest dts = this.getTableTest();
            Dwg12TableTest dwg12TableTest = this.getTableTest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readP13Table(Dwg12Table p13table) {
    }

    private void readDimStyleTable(Dwg12Table dimStyleTable) {
        short size = dimStyleTable.s1;
        int numRecs = dimStyleTable.i1;
        int start = dimStyleTable.i2;
        int end = -1;
        this.bb.position(start);
        for (int i = 0; i < numRecs; ++i) {
            end = this.bb.position() + size;
            byte flag = this.bb.get();
            byte[] nameBytes = new byte[32];
            this.bb.get(nameBytes);
            String name = new String(nameBytes);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short word = this.bb.getShort();
            double[] d4048 = new double[9];
            for (int j = 0; j < 9; ++j) {
                d4048[j] = this.bb.getDouble();
            }
            double[] d40145 = new double[6];
            for (int j = 0; j < 6; ++j) {
                d40145[j] = this.bb.getDouble();
            }
            byte[] b7078 = new byte[7];
            for (int j = 0; j < 7; ++j) {
                b7078[j] = this.bb.get();
            }
            byte[] b170175 = new byte[6];
            for (int j = 0; j < 6; ++j) {
                b170175[j] = this.bb.get();
            }
            this.bb.order(ByteOrder.nativeOrder());
            byte[] s3 = new byte[16];
            this.bb.get(s3);
            byte[] s4 = new byte[16];
            this.bb.get(s4);
            byte[] s5 = new byte[32];
            this.bb.get(s5);
            byte[] s6 = new byte[32];
            this.bb.get(s6);
            byte[] s7 = new byte[32];
            this.bb.get(s6);
            this.bb.position(this.bb.position() + 3);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short w176 = this.bb.getShort();
            short w177 = this.bb.getShort();
            short w178 = this.bb.getShort();
            double d146 = this.bb.getDouble();
            double d147 = this.bb.getDouble();
            int offset = end - this.bb.position();
            if (offset > 0) {
                this.bb.position(this.bb.position() + offset);
            }
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short s = this.bb.getShort();
        }
        byte[] crc32 = new byte[32];
        this.bb.get(crc32);
    }

    private void readAppidTable(Dwg12Table appidTable) {
        short size = appidTable.s1;
        int numRecs = appidTable.i1;
        int start = appidTable.i2;
        int end = -1;
        this.bb.position(start);
        for (int i = 0; i < numRecs; ++i) {
            end = this.bb.position() + size;
            byte flag = this.bb.get();
            byte[] nameBytes = new byte[32];
            this.bb.get(nameBytes);
            String name = new String(nameBytes);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short word = this.bb.getShort();
            int offset = end - this.bb.position();
            if (offset > 0) {
                this.bb.position(this.bb.position() + offset);
            }
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short s = this.bb.getShort();
        }
        byte[] crc32 = new byte[32];
        this.bb.get(crc32);
    }

    private void readVportTable(Dwg12Table vportTable) {
        short size = vportTable.s1;
        int numRecs = vportTable.i1;
        int start = vportTable.i2;
        int end = -1;
        this.bb.position(start);
        for (int i = 0; i < numRecs; ++i) {
            end = this.bb.position() + size;
            byte flag = this.bb.get();
            byte[] nameBytes = new byte[32];
            this.bb.get(nameBytes);
            String name = new String(nameBytes);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short used = this.bb.getShort();
            double[] pt10 = this.getPoint(false);
            double[] pt11 = this.getPoint(false);
            double[] pt17 = this.getPoint(false);
            double[] pt16 = this.getPoint(true);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            double d50 = this.bb.getDouble();
            double d40 = this.bb.getDouble();
            double[] pt12 = this.getPoint(false);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            double d41 = this.bb.getDouble();
            double d42 = this.bb.getDouble();
            double d43 = this.bb.getDouble();
            double d44 = this.bb.getDouble();
            short[] w7178 = new short[8];
            for (int j = 0; j < 8; ++j) {
                w7178[j] = this.bb.getShort();
            }
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            double d51 = this.bb.getDouble();
            double[] pt13 = this.getPoint(false);
            double[] pt14 = this.getPoint(false);
            double[] pt15 = this.getPoint(false);
            int offset = end - this.bb.position();
            if (offset > 0) {
                this.bb.position(this.bb.position() + offset);
            }
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short s = this.bb.getShort();
        }
        byte[] crc32 = new byte[32];
        this.bb.get(crc32);
    }

    private void readUcsTable(Dwg12Table ucsTable) {
        short size = ucsTable.s1;
        int numRecs = ucsTable.i1;
        int start = ucsTable.i2;
        int end = -1;
        this.bb.position(start);
        for (int i = 0; i < numRecs; ++i) {
            end = this.bb.position() + size;
            byte flag = this.bb.get();
            byte[] nameBytes = new byte[32];
            this.bb.get(nameBytes);
            String name = new String(nameBytes);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short used = this.bb.getShort();
            double[] pt10 = this.getPoint(true);
            double[] pt11 = this.getPoint(true);
            double[] pt12 = this.getPoint(true);
            int offset = end - this.bb.position();
            if (offset > 0) {
                this.bb.position(this.bb.position() + offset);
            }
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short s = this.bb.getShort();
        }
        byte[] crc32 = new byte[32];
        this.bb.get(crc32);
    }

    private void readViewTable(Dwg12Table viewTable) {
        short size = viewTable.s1;
        int numRecs = viewTable.i1;
        int start = viewTable.i2;
        int end = -1;
        this.bb.position(start);
        for (int i = 0; i < numRecs; ++i) {
            end = this.bb.position() + size;
            byte flag = this.bb.get();
            byte[] nameBytes = new byte[32];
            this.bb.get(nameBytes);
            String name = new String(nameBytes);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short used = this.bb.getShort();
            double db40 = this.bb.getDouble();
            double[] pt10 = this.getPoint(false);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            double db41 = this.bb.getDouble();
            double[] pt11 = this.getPoint(true);
            double[] pt12 = this.getPoint(true);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short w71 = this.bb.getShort();
            double db42 = this.bb.getDouble();
            double db43 = this.bb.getDouble();
            double db44 = this.bb.getDouble();
            double db50 = this.bb.getDouble();
            int offset = end - this.bb.position();
            if (offset > 0) {
                this.bb.position(this.bb.position() + offset);
            }
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short s = this.bb.getShort();
        }
        byte[] crc32 = new byte[32];
        this.bb.get(crc32);
    }

    private void readLTypeTable(Dwg12Table lineTypeTable) {
        short size = lineTypeTable.s1;
        int numRecs = lineTypeTable.i1;
        int start = lineTypeTable.i2;
        int end = -1;
        this.bb.position(start);
        for (int i = 0; i < numRecs; ++i) {
            end = this.bb.position() + size;
            byte flag = this.bb.get();
            byte[] nameBytes = new byte[32];
            this.bb.get(nameBytes);
            String name = new String(nameBytes);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short w1 = this.bb.getShort();
            byte[] s1 = new byte[48];
            this.bb.get(s1);
            String s1name = new String(s1);
            this.bb.order(ByteOrder.nativeOrder());
            byte b1 = this.bb.get();
            byte b2 = this.bb.get();
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            double[] doubles = new double[13];
            for (int j = 0; j < 13; ++j) {
                doubles[j] = this.bb.getDouble();
            }
            short crc = this.bb.getShort();
            int offset = end - this.bb.position();
            if (offset <= 0) continue;
            this.bb.position(this.bb.position() + offset);
        }
        byte[] crc32 = new byte[32];
        this.bb.get(crc32);
    }

    private void readStyleTable(Dwg12Table styleTable) {
        short size = styleTable.s1;
        int numRecs = styleTable.i1;
        int start = styleTable.i2;
        int end = -1;
        this.bb.position(start);
        for (int i = 0; i < numRecs; ++i) {
            end = this.bb.position() + size;
            byte flag = this.bb.get();
            byte[] nameBytes = new byte[32];
            this.bb.get(nameBytes);
            String name = new String(nameBytes);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short w1 = this.bb.getShort();
            double d1 = this.bb.getDouble();
            double d2 = this.bb.getDouble();
            double d3 = this.bb.getDouble();
            byte b1 = this.bb.get();
            double d4 = this.bb.getDouble();
            byte[] s1 = new byte[128];
            this.bb.get(s1);
            short crc = this.bb.getShort();
            int offset = end - this.bb.position();
            if (offset <= 0) continue;
            this.bb.position(this.bb.position() + offset);
        }
        byte[] crc32 = new byte[32];
        this.bb.get(crc32);
    }

    private void readLayerTable(Dwg12Table layerTable) {
        short size = layerTable.s1;
        int numR = layerTable.i1;
        int start = layerTable.i2;
        int begin = -1;
        int end = -1;
        DwgLayer layer = null;
        for (int i = 0; i < numR; ++i) {
            begin = start + i * size;
            this.bb.position(begin);
            end = begin + size - 2;
            layer = new DwgLayer(this.index);
            ++this.index;
            byte flag = this.bb.get();
            if ((flag & 1) > 0) {
                layer.setFrozen(true);
            }
            if ((flag & 2) > 0) {
                layer.setFrozenInNew(true);
            }
            if ((flag & 4) > 0) {
                layer.setLocked(true);
            }
            byte[] nameByte = new byte[32];
            this.bb.get(nameByte);
            String name = new String(nameByte).trim();
            layer.setName(name);
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short used = this.bb.getShort();
            short color = this.bb.getShort();
            layer.setColor(color);
            short style = this.bb.getShort();
            short crc = this.bb.getShort();
            DwgHandleReference handle = new DwgHandleReference(5, i);
            layer.setHandle(handle);
            this.dwgFile.addDwgObject(layer);
            int offset = end - this.bb.position();
            if (offset <= 0) continue;
            this.bb.position(this.bb.position() + offset);
        }
        byte[] crc32 = new byte[32];
        this.bb.get(crc32);
    }

    public String getString() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        short len = this.bb.getShort();
        byte[] bytes = new byte[len];
        this.bb.order(ByteOrder.nativeOrder());
        this.bb.get(bytes);
        return new String(bytes);
    }

    private Block getBlock(String blockName) {
        for (int i = 0; i < this.blocks.size(); ++i) {
            Block block = (Block)this.blocks.get(i);
            if (!block.name.equalsIgnoreCase(blockName)) continue;
            return block;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readEntities(int start, int end) {
        this.bb.position(start);
        int ant = this.bb.position();
        int emax = this.readers.size();
        EntityReader reader = null;
        IDwgPolyline currentPolyline = null;
        DwgBlockHeader currentBlock = null;
        while (true) {
            block31: {
                int crcpos;
                byte kind;
                block32: {
                    DwgHandleReference hdl;
                    DwgObject entity;
                    short type;
                    String xdata;
                    byte color;
                    short layer;
                    short lenght;
                    block30: {
                        if (ant >= end - 32) {
                            byte[] crc32 = new byte[32];
                            this.bb.get(crc32);
                            return;
                        }
                        this.bb.order(ByteOrder.LITTLE_ENDIAN);
                        kind = this.bb.get();
                        if (kind < emax) {
                            reader = (EntityReader)this.readers.get(kind);
                        }
                        byte flag = this.bb.get();
                        lenght = this.bb.getShort();
                        crcpos = ant + (lenght - 2);
                        layer = this.bb.getShort();
                        short opts = this.bb.getShort();
                        color = 0;
                        if ((flag & 1) > 0) {
                            color = this.bb.get();
                        }
                        byte extra = 0;
                        if ((flag & 0x40) > 0) {
                            extra = this.bb.get();
                        }
                        xdata = null;
                        if ((extra & 2) > 0) {
                            xdata = this.readXdata();
                        }
                        type = 0;
                        if ((flag & 2) > 0) {
                            type = this.bb.getShort();
                        }
                        double z = 0.0;
                        if ((flag & 4) > 0 && kind > 2 && kind != 22) {
                            z = this.bb.getDouble();
                        }
                        double th = 0.0;
                        if ((flag & 8) > 0) {
                            th = this.bb.getDouble();
                        }
                        byte[] handle = null;
                        if ((flag & 0x20) > 0) {
                            handle = this.getHandle();
                        }
                        short paper = 0;
                        if ((extra & 4) > 0) {
                            paper = this.bb.getShort();
                        }
                        if (reader == null) break block32;
                        entity = null;
                        entity = DwgObjectFactory.getInstance().create(kind, this.index);
                        boolean paperSpace = false;
                        if (paper != 0) {
                            paperSpace = true;
                        }
                        reader.read(this.bb, flag, opts, entity);
                        if (reader instanceof DefferedEntityReader) {
                            entity = ((DefferedEntityReader)reader).getDwgObject(this.index);
                        }
                        if (entity instanceof IDwgPolyline) {
                            currentPolyline = (IDwgPolyline)((Object)entity);
                        } else if (entity instanceof DwgSeqend) {
                            currentPolyline = null;
                        } else if (entity instanceof DwgBlockHeader) {
                            currentBlock = (DwgBlockHeader)entity;
                        } else if (entity instanceof DwgEndblk) {
                            currentBlock = null;
                        }
                        hdl = null;
                        if (entity instanceof DwgBlockHeader) {
                            int order = -1;
                            DwgBlockHeader blk = (DwgBlockHeader)entity;
                            String blockName = blk.getName();
                            Block block = this.getBlock(blockName);
                            if (block != null) {
                                order = this.blocks.indexOf(block);
                                hdl = new DwgHandleReference(0, order);
                                break block30;
                            } else {
                                System.out.println("BLOQUE " + blockName + " NO EST\u00c1 EN LA TABLA DE BLOQUES");
                                this.bb.position(crcpos);
                                short crc = this.bb.getShort();
                                continue;
                            }
                        }
                        if (handle != null) {
                            int offset = handle.hashCode();
                            hdl = new DwgHandleReference(0, offset);
                        } else {
                            System.out.println("HANDLE A NULL");
                            this.bb.position(crcpos);
                            short crc = this.bb.getShort();
                            continue;
                        }
                    }
                    entity.setColor(color);
                    entity.setType(type);
                    entity.setSizeInBits(lenght);
                    entity.setHandle(hdl);
                    entity.setLayerHandle(new DwgHandleReference(5, layer));
                    ArrayList<String> xdataAsList = new ArrayList<String>();
                    xdataAsList.add(xdata);
                    entity.setExtendedData(xdataAsList);
                    ant = this.bb.position();
                    if (ant != crcpos) {
                        this.bb.position(this.bb.position() + (crcpos - ant));
                    }
                    short crc = this.bb.getShort();
                    if (entity instanceof IDwgVertex && currentPolyline != null) {
                        currentPolyline.addVertex((IDwgVertex)((Object)entity));
                        break block31;
                    } else if (entity instanceof IDwgBlockMember && !(entity instanceof IDwgVertex) && currentBlock != null) {
                        currentBlock.addObject(entity);
                        break block31;
                    } else {
                        this.dwgFile.addDwgObject(entity);
                    }
                    break block31;
                }
                System.out.println("Reader a NULL. DWG 12 MAL LEIDO");
                System.out.println("kind = " + kind);
                this.bb.position(crcpos);
                short crc = this.bb.getShort();
                continue;
            }
            ant = this.bb.position();
            ++this.index;
        }
    }

    private byte[] getHandle() {
        byte[] bytes = null;
        this.bb.order(ByteOrder.nativeOrder());
        byte len = this.bb.get();
        bytes = new byte[len];
        this.bb.get(bytes);
        return bytes;
    }

    private String readXdata() {
        block4: {
            String extData;
            block7: {
                short xlen;
                block13: {
                    byte xval;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block5: {
                                            byte val;
                                            block6: {
                                                extData = "";
                                                xlen = this.bb.getShort();
                                                if (xlen <= 0) break block4;
                                                xval = this.bb.get();
                                                xlen = (short)(xlen - 1);
                                                if (xval != 0) break block5;
                                                if (xlen < 1) break block4;
                                                val = this.bb.get();
                                                xlen = (short)(xlen - 1);
                                                if (!this.r13) break block6;
                                                if (xlen < 1) break block4;
                                                byte codePage = this.bb.get();
                                                xlen = (short)(xlen - 1);
                                            }
                                            if (xlen < val) break block4;
                                            byte[] strByte = new byte[val];
                                            this.bb.get(strByte);
                                            xlen = (short)(xlen - val);
                                            extData = extData + new String(strByte);
                                            break block7;
                                        }
                                        if (xval != 1 && xval != 3 && xval != 70) break block8;
                                        if (xlen < 2) break block4;
                                        short val = this.bb.getShort();
                                        extData = extData + val;
                                        xlen = (short)(xlen + 2);
                                        break block7;
                                    }
                                    if (xval != 2) break block9;
                                    if (xlen < 1) break block4;
                                    byte val = this.bb.get();
                                    if (val == 0) {
                                        extData = extData + "{";
                                    } else if (val == 1) {
                                        extData = extData + "}";
                                    } else {
                                        System.out.println("Byte no esperado:" + val);
                                    }
                                    break block7;
                                }
                                if (xval != 5) break block10;
                                if (xlen < 8) break block4;
                                long val = this.bb.getLong();
                                xlen = (short)(xlen - 8);
                                break block7;
                            }
                            if (xval != 40 && xval != 41 && xval != 42) break block11;
                            if (xlen < 8) break block4;
                            double val = this.bb.getDouble();
                            xlen = (short)(xlen - 8);
                            extData = extData + val;
                            break block7;
                        }
                        if (xval != 10 && xval != 11 && xval != 12 && xval != 13) break block12;
                        if (xlen < 24) break block4;
                        double[] point = this.getPoint(true);
                        extData = extData + point.toString();
                        xlen = (short)(xlen - 24);
                        break block7;
                    }
                    if (xval != 71) break block13;
                    if (xlen < 4) break block4;
                    int val = this.bb.getInt();
                    extData = extData + val;
                    xlen = (short)(xlen - 4);
                    break block7;
                }
                xlen = 0;
            }
            return extData;
        }
        return null;
    }

    private double[] getPoint(boolean b) {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        double x = this.bb.getDouble();
        double y = this.bb.getDouble();
        double z = 0.0;
        if (b) {
            z = this.bb.getDouble();
        }
        return new double[]{x, y, z};
    }

    private void readBlockTable(Dwg12Table blockTable) {
        short size = blockTable.s1;
        int numRecords = blockTable.i1;
        int start = blockTable.i2;
        int begin = -1;
        int end = -1;
        for (int i = 0; i < numRecords; ++i) {
            begin = start + i * size;
            this.bb.position(begin);
            end = begin + size - 2;
            byte flag = this.bb.get();
            byte[] nameByte = new byte[32];
            this.bb.get(nameByte);
            String name = new String(nameByte).trim();
            this.bb.order(ByteOrder.LITTLE_ENDIAN);
            short used = this.bb.getShort();
            byte b1 = this.bb.get();
            short w1 = this.bb.getShort();
            byte b2 = this.bb.get();
            short w3 = this.bb.getShort();
            short crc = this.bb.getShort();
            int offset = end - this.bb.position();
            if (offset > 0) {
                this.bb.position(this.bb.position() + end);
            }
            Block block = new Block();
            block.flag = flag;
            block.name = name;
            block.used = used;
            block.b1 = b1;
            block.w1 = w1;
            block.b2 = b2;
            block.w3 = w3;
            block.crc = crc;
            this.blocks.add(block);
        }
        byte[] crc32 = new byte[32];
        this.bb.get(crc32);
    }

    public void readHeader() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        short w1 = this.bb.getShort();
        double[] inBase = this.getPoint(true);
        double[] extMin = this.getPoint(true);
        this.dwgFile.setHeader("MSPACE_EXTMIN", extMin);
        double[] extMax = this.getPoint(true);
        this.dwgFile.setHeader("MSPACE_EXTMAX", extMax);
        double[] limMin = this.getPoint(false);
        double[] limMax = this.getPoint(false);
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        double vcx = this.bb.getDouble();
        double vcy = this.bb.getDouble();
        double d3 = this.bb.getDouble();
        double d4 = this.bb.getDouble();
        byte b1 = this.bb.get();
        byte b2 = this.bb.get();
        double sx = this.bb.getDouble();
        double sy = this.bb.getDouble();
        this.bb.order(ByteOrder.nativeOrder());
        byte[] b56 = new byte[56];
        this.bb.get(b56);
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        double d7 = this.bb.getDouble();
        double d8 = this.bb.getDouble();
        double d9 = this.bb.getDouble();
        this.bb.order(ByteOrder.nativeOrder());
        byte[] b18 = new byte[18];
        this.bb.get(b18);
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        double d10 = this.bb.getDouble();
        int at = this.bb.position();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        short w2 = this.bb.getShort();
        short w3 = this.bb.getShort();
        this.bb.order(ByteOrder.nativeOrder());
        byte[] b44 = new byte[44];
        this.bb.get(b44);
        at = this.bb.position();
        this.bb.order(ByteOrder.nativeOrder());
        byte[] b354 = new byte[354];
        this.bb.get(b354);
        if (b354[0] == 97 && b354[1] == 99 && b354[2] == 97 && b354[2] == 100) {
            System.out.println("Encontrada la cadena 'acad' al comienzo del bloque de 354 bytes");
        }
        this.bb.position(1007);
    }

    public Dwg12Table getTable() {
        Dwg12Table solution = null;
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        short s1 = this.bb.getShort();
        int i1 = this.bb.getInt();
        int i2 = this.bb.getInt();
        solution = new Dwg12Table();
        solution.s1 = s1;
        solution.i1 = i1;
        solution.i2 = i2;
        return solution;
    }

    public Dwg12TableTest getTableTest() {
        Dwg12TableTest solution = null;
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        short s1 = this.bb.getShort();
        short s2 = this.bb.getShort();
        short s3 = this.bb.getShort();
        int i1 = this.bb.getInt();
        solution = new Dwg12TableTest();
        solution.s1 = s1;
        solution.s2 = s2;
        solution.s3 = s3;
        solution.i1 = i1;
        return solution;
    }

    @Override
    public int readObjectHeader(int[] data, int offset, DwgObject dwgObject) throws RuntimeException, CorruptedDwgEntityException {
        return 0;
    }

    @Override
    public int readObjectTailer(int[] data, int offset, DwgObject dwgObject) throws RuntimeException, CorruptedDwgEntityException {
        return 0;
    }

    class Dwg12TableTest {
        short s1;
        short s2;
        short s3;
        int i1;

        Dwg12TableTest() {
        }
    }

    class Dwg12Table {
        short s1;
        int i1;
        int i2;

        Dwg12Table() {
        }
    }

    class VPortReader
    implements EntityReader {
        VPortReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            double[] pt10 = DwgFileV12Reader.this.getPoint(true);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            double d40 = bb.getDouble();
            double d41 = bb.getDouble();
            short w68 = bb.getShort();
        }
    }

    class DimReader
    implements EntityReader {
        DimReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
            short w1 = bb.getShort();
            double[] pt10 = DwgFileV12Reader.this.getPoint(true);
            double[] pt11 = DwgFileV12Reader.this.getPoint(false);
            if ((opts & 2) > 0) {
                byte by = bb.get();
            }
            if ((opts & 1) > 0) {
                double[] dArray = DwgFileV12Reader.this.getPoint(true);
            }
            if ((opts & 4) > 0) {
                String string = DwgFileV12Reader.this.getString();
            }
            if ((opts & 8) > 0) {
                double[] dArray = DwgFileV12Reader.this.getPoint(true);
            }
            if ((opts & 0x10) > 0) {
                double[] dArray = DwgFileV12Reader.this.getPoint(true);
            }
            if ((opts & 0x20) > 0) {
                double[] dArray = DwgFileV12Reader.this.getPoint(true);
            }
            if ((opts & 0x40) > 0) {
                double[] dArray = DwgFileV12Reader.this.getPoint(true);
            }
            bb.order(ByteOrder.LITTLE_ENDIAN);
            if ((opts & 0x80) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 0x100) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 0x200) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 0x400) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 0x800) > 0) {
                double d = bb.getDouble();
            }
        }
    }

    class Face3DReader
    implements EntityReader {
        Face3DReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            boolean zflag = false;
            if ((flags & 4) > 0) {
                zflag = true;
            }
            double[] pt10 = DwgFileV12Reader.this.getPoint(zflag);
            double[] pt11 = DwgFileV12Reader.this.getPoint(zflag);
            double[] pt12 = DwgFileV12Reader.this.getPoint(zflag);
            double[] pt13 = DwgFileV12Reader.this.getPoint(zflag);
        }
    }

    class VertexReader
    extends DefferedEntityReader {
        static final int FIT_POINT = 1;
        static final int TANGENT = 2;
        static final int SPLINE_LINE_FIT = 8;
        static final int SPLINE_CONTROL_POINT = 16;
        static final int POLYLINE_3D = 32;
        static final int MESH_3D = 64;
        static final int PFACE_MESH = 128;
        double[] pt10;
        double startWidth40;
        double endWidth41;
        double tangentDir50;
        byte vertexFlag70;
        int[] pfacefaceIndex;

        VertexReader() {
        }

        void reset() {
            this.pt10 = null;
            this.startWidth40 = 0.0;
            this.endWidth41 = 0.0;
            this.tangentDir50 = 0.0;
            this.vertexFlag70 = 0;
            this.pfacefaceIndex = null;
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            super.read(bb, flags, opts, dwgObj);
            if (opts != 16872) {
                int position = bb.position();
                this.pt10 = DwgFileV12Reader.this.getPoint(false);
                if (this.pt10[0] < 0.0 || this.pt10[0] < 600000.0 || this.pt10[0] > 800000.0) {
                    System.currentTimeMillis();
                }
                bb.order(ByteOrder.LITTLE_ENDIAN);
                if ((opts & 1) > 0) {
                    this.startWidth40 = bb.getDouble();
                }
                if ((opts & 2) > 0) {
                    this.endWidth41 = bb.getDouble();
                }
                if ((opts & 4) > 0) {
                    this.tangentDir50 = bb.getDouble();
                }
                if ((opts & 8) > 0) {
                    this.vertexFlag70 = bb.get();
                }
            } else {
                bb.order(ByteOrder.LITTLE_ENDIAN);
                if ((opts & 1) > 0) {
                    this.startWidth40 = bb.getDouble();
                }
                if ((opts & 2) > 0) {
                    this.endWidth41 = bb.getDouble();
                }
                if ((opts & 4) > 0) {
                    this.tangentDir50 = bb.getDouble();
                }
                if ((opts & 8) > 0) {
                    this.vertexFlag70 = bb.get();
                }
                short p1 = bb.getShort();
                short p2 = bb.getShort();
                short p3 = bb.getShort();
                short p4 = bb.getShort();
                this.pfacefaceIndex = new int[]{p1, p2, p3, p4};
            }
        }

        @Override
        DwgObject getDwgObject(int index) {
            DwgObject solution = null;
            if ((this.vertexFlag70 & 0x80) != 0) {
                if ((this.vertexFlag70 & 0x40) != 0) {
                    solution = new DwgVertexPFace(index);
                    ((DwgVertexPFace)solution).setPoint(this.pt10);
                    ((DwgVertexPFace)solution).setFlags(this.vertexFlag70);
                } else {
                    solution = new DwgVertexPFaceFace(index);
                    ((DwgVertexPFaceFace)solution).setVerticesidx(this.pfacefaceIndex);
                }
            } else if ((this.vertexFlag70 & 0x20) != 0) {
                solution = new DwgVertex3D(index);
                ((DwgVertex3D)solution).setPoint(this.pt10);
                ((DwgVertex3D)solution).setFlags(this.vertexFlag70);
            } else {
                solution = new DwgVertex2D(index);
                ((DwgVertex2D)solution).setPoint(this.pt10);
                ((DwgVertex2D)solution).setFlags(this.vertexFlag70);
            }
            this.reset();
            return solution;
        }
    }

    class PlineReader
    extends DefferedEntityReader {
        static final int CLOSED = 1;
        static final int CURVE_FIT = 2;
        static final int SPLINE_FIT = 4;
        static final int PLINE3D = 8;
        static final int MESH = 16;
        static final int MESH_CLOSED = 32;
        static final int ANY_MESH = 48;
        static final int PFACE = 64;
        static final int CONT_LTYPE = 128;
        byte flag70;
        byte meshM71;
        byte meshN72;
        double startW40;
        byte smoothM73;
        byte smoothN74;
        byte curveType75;

        PlineReader() {
        }

        private void reset() {
            this.flag70 = 0;
            this.meshM71 = 0;
            this.meshN72 = 0;
            this.startW40 = 0.0;
            this.smoothM73 = 0;
            this.smoothN74 = 0;
            this.curveType75 = 0;
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            super.read(bb, flags, opts, dwgObj);
            if ((opts & 1) > 0) {
                this.flag70 = bb.get();
            }
            bb.order(ByteOrder.LITTLE_ENDIAN);
            if ((opts & 2) > 0) {
                this.startW40 = bb.getDouble();
            }
            if ((opts & 4) > 0) {
                this.meshM71 = bb.get();
            }
            if ((opts & 8) > 0) {
                this.meshN72 = bb.get();
            }
            if ((opts & 0x10) > 0) {
                this.smoothM73 = bb.get();
            }
            if ((opts & 0x20) > 0) {
                this.smoothN74 = bb.get();
            }
            if ((opts & 0x40) > 0) {
                this.curveType75 = bb.get();
            }
        }

        @Override
        DwgObject getDwgObject(int index) {
            boolean isSpline;
            DwgObject solution = null;
            boolean bl = isSpline = (this.flag70 & 4) != 0;
            if ((this.flag70 & 0x40) != 0) {
                solution = new DwgPFacePolyline(index);
                if (this.meshM71 <= 0) {
                    this.meshM71 = (byte)16;
                }
                if (this.meshN72 <= 0) {
                    this.meshN72 = (byte)4;
                }
                ((DwgPFacePolyline)solution).setVertexCount(this.meshM71);
                ((DwgPFacePolyline)solution).setFaceCount(this.meshN72);
            } else if ((this.flag70 & 0x30) != 0) {
                solution = new DwgMeshPolyline(index);
                boolean isClosedM = (this.flag70 & 1) != 0;
                boolean isClosedN = (this.flag70 & 0x20) > 0;
                ((DwgMeshPolyline)solution).setClosedM(isClosedM);
                ((DwgMeshPolyline)solution).setClosedN(isClosedN);
                if (isSpline) {
                    ((DwgMeshPolyline)solution).setMVerticies(this.smoothM73);
                    ((DwgMeshPolyline)solution).setNVerticies(this.smoothN74);
                } else {
                    ((DwgMeshPolyline)solution).setMVerticies(this.meshM71);
                    ((DwgMeshPolyline)solution).setNVerticies(this.meshN72);
                }
                ((DwgMeshPolyline)solution).setCurveType(this.curveType75);
            } else {
                boolean is3DPolyline;
                boolean bl2 = is3DPolyline = (this.flag70 & 8) != 0;
                if (is3DPolyline) {
                    solution = new DwgPolyline3D(index);
                    boolean isClosed = (this.flag70 & 1) != 0;
                    ((DwgPolyline3D)solution).setClosedFlags(isClosed ? 1 : 0);
                    ((DwgPolyline3D)solution).setSplineFlags(isSpline ? 1 : 0);
                } else {
                    solution = new DwgPolyline2D(index);
                    ((DwgPolyline2D)solution).setCurveType(this.curveType75);
                    ((DwgPolyline2D)solution).setInitWidth(this.startW40);
                }
            }
            this.reset();
            return solution;
        }
    }

    class SbEndReader
    implements EntityReader {
        SbEndReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
            int l = bb.getInt();
        }
    }

    class AttribReader
    implements EntityReader {
        AttribReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            byte by;
            double[] p10 = DwgFileV12Reader.this.getPoint(false);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            double d40 = bb.getDouble();
            String s1 = DwgFileV12Reader.this.getString();
            String s2 = DwgFileV12Reader.this.getString();
            if ((opts & 1) > 0) {
                by = bb.get();
            }
            bb.order(ByteOrder.LITTLE_ENDIAN);
            if ((opts & 2) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 4) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 8) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 0x10) > 0) {
                by = bb.get();
            }
            if ((opts & 0x20) > 0) {
                by = bb.get();
            }
            if ((opts & 0x40) > 0) {
                by = bb.get();
            }
            if ((opts & 0x80) > 0) {
                double[] dArray = DwgFileV12Reader.this.getPoint(false);
            }
            double[] p210 = null;
            p210 = (opts & 0x100) > 0 ? DwgFileV12Reader.this.getPoint(true) : new double[]{0.0, 0.0, 1.0};
            bb.order(ByteOrder.LITTLE_ENDIAN);
            if ((opts & 0x200) > 0) {
                double d = bb.getDouble();
            }
        }
    }

    class AttDefReader
    implements EntityReader {
        AttDefReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            byte by;
            double[] p10 = DwgFileV12Reader.this.getPoint(false);
            String s1 = DwgFileV12Reader.this.getString();
            String s3 = DwgFileV12Reader.this.getString();
            String s2 = DwgFileV12Reader.this.getString();
            bb.order(ByteOrder.LITTLE_ENDIAN);
            byte b70 = bb.get();
            if ((opts & 1) > 0) {
                by = bb.get();
            }
            if ((opts & 2) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 4) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 8) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 0x10) > 0) {
                by = bb.get();
            }
            if ((opts & 0x20) > 0) {
                by = bb.get();
            }
            if ((opts & 0x40) > 0) {
                by = bb.get();
            }
            if ((opts & 0x80) > 0) {
                double[] dArray = DwgFileV12Reader.this.getPoint(false);
            }
            if ((opts & 0x100) > 0) {
                double[] dArray = DwgFileV12Reader.this.getPoint(true);
            }
            if ((opts & 0x200) > 0) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
                double d = bb.getDouble();
            }
        }
    }

    class InsertReader
    implements EntityReader {
        InsertReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            if (!(dwgObj instanceof DwgInsert)) {
                throw new RuntimeException("No es entidad INSERT");
            }
            DwgInsert insert = (DwgInsert)dwgObj;
            bb.order(ByteOrder.nativeOrder());
            short w1 = bb.getShort();
            DwgHandleReference blockHandle = new DwgHandleReference(5, w1);
            insert.setBlockHeaderHandle(blockHandle);
            double[] pt10 = DwgFileV12Reader.this.getPoint(false);
            insert.setInsertionPoint(pt10);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if ((opts & 1) > 0) {
                double db41;
                x = db41 = bb.getDouble();
            }
            if ((opts & 2) > 0) {
                double db42;
                y = db42 = bb.getDouble();
            }
            if ((opts & 4) > 0) {
                double db43;
                z = db43 = bb.getDouble();
            }
            insert.setScale(new double[]{x, y, z});
            if ((opts & 8) > 0) {
                double db50 = bb.getDouble();
                insert.setRotation(db50);
            }
            if ((opts & 0x10) > 0) {
                short s = bb.getShort();
            }
            if ((opts & 0x10) > 0) {
                short s = bb.getShort();
            }
            if ((opts & 0x40) > 0) {
                double d = bb.getDouble();
            }
            if ((opts & 0x80) > 0) {
                double d = bb.getDouble();
            }
            insert.setExtrusion(new double[]{0.0, 0.0, 1.0});
        }
    }

    class EndBlkReader
    implements EntityReader {
        EndBlkReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
        }
    }

    class BlkReader
    implements EntityReader {
        BlkReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            if (!(dwgObj instanceof DwgBlockHeader)) {
                throw new RuntimeException("No es entidad BLOCK");
            }
            DwgBlockHeader blk = (DwgBlockHeader)dwgObj;
            double[] pt10 = DwgFileV12Reader.this.getPoint(false);
            blk.setBasePoint(pt10);
            String blockName = DwgFileV12Reader.this.getString();
            blk.setName(blockName);
            Block block = DwgFileV12Reader.this.getBlock(blockName);
            if (block == null) {
                System.out.println(blockName + " no encontrado en la tabla de bloques");
            }
            if ((opts & 2) > 0) {
                String string = DwgFileV12Reader.this.getString();
            }
            if ((flags & 1) > 0) {
                blk.setAnonymous(true);
            }
            if ((flags & 2) > 0) {
                blk.setHasAttrs(true);
            }
            if ((flags & 4) > 0) {
                blk.setBlkIsXRef(true);
            }
            if ((flags & 0x10) > 0) {
                blk.setXdep(true);
            }
            if ((flags & 0x20) > 0) {
                blk.setXRefOverLaid(true);
            }
            if ((flags & 0x40) > 0) {
                blk.setLoaded(true);
            }
        }
    }

    class SolidReader
    implements EntityReader {
        SolidReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            if (!(dwgObj instanceof DwgSolid)) {
                throw new RuntimeException("No es entidad SOLID");
            }
            DwgSolid solid = (DwgSolid)dwgObj;
            double[] pt11 = DwgFileV12Reader.this.getPoint(false);
            solid.setCorner1(pt11);
            double[] pt12 = DwgFileV12Reader.this.getPoint(false);
            solid.setCorner2(pt12);
            double[] pt13 = DwgFileV12Reader.this.getPoint(false);
            solid.setCorner3(pt13);
            double[] pt14 = DwgFileV12Reader.this.getPoint(false);
            solid.setCorner4(pt14);
            if ((opts & 1) > 0) {
                double[] pt210 = DwgFileV12Reader.this.getPoint(true);
                solid.setExtrusion(pt210);
            }
            if ((opts & 2) > 0) {
                double db38;
                bb.order(ByteOrder.LITTLE_ENDIAN);
                solid.getCorner1()[2] = db38 = bb.getDouble();
                solid.getCorner2()[2] = db38;
                solid.getCorner3()[2] = db38;
                solid.getCorner4()[2] = db38;
            }
            solid.setExtrusion(new double[]{0.0, 0.0, 1.0});
        }
    }

    class TraceReader
    implements EntityReader {
        TraceReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            double[] pt10 = DwgFileV12Reader.this.getPoint(false);
            double[] pt11 = DwgFileV12Reader.this.getPoint(false);
            double[] pt12 = DwgFileV12Reader.this.getPoint(false);
            double[] pt13 = DwgFileV12Reader.this.getPoint(false);
            if ((opts & 1) > 0) {
                double[] dArray = DwgFileV12Reader.this.getPoint(true);
            }
            if ((opts & 2) > 0) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
                double d = bb.getDouble();
            }
        }
    }

    class ArcReader
    implements EntityReader {
        ArcReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            if (!(dwgObj instanceof DwgArc)) {
                throw new RuntimeException("No es entidad ARC");
            }
            DwgArc arc = (DwgArc)dwgObj;
            double[] pt10 = DwgFileV12Reader.this.getPoint(false);
            arc.setCenter(pt10);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            double d40 = bb.getDouble();
            arc.setRadius(d40);
            double d50 = bb.getDouble();
            arc.setInitAngle(d50);
            double d51 = bb.getDouble();
            arc.setEndAngle(51.0);
            double[] pt210 = null;
            if ((opts & 1) > 0) {
                pt210 = DwgFileV12Reader.this.getPoint(true);
                arc.setExtrusion(pt210);
            } else {
                pt210 = new double[]{1.0, 0.0, 0.0};
            }
            if ((opts & 2) > 0) {
                double db38;
                bb.order(ByteOrder.LITTLE_ENDIAN);
                arc.getCenter()[2] = db38 = bb.getDouble();
            }
        }
    }

    class TextReader
    implements EntityReader {
        TextReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            if (!(dwgObj instanceof DwgText)) {
                throw new RuntimeException("No es entidad TEXT");
            }
            DwgText txt = (DwgText)dwgObj;
            double[] pt10 = DwgFileV12Reader.this.getPoint(false);
            txt.setInsertionPoint(new Point2D.Double(pt10[0], pt10[1]));
            bb.order(ByteOrder.LITTLE_ENDIAN);
            double db40 = bb.getDouble();
            txt.setHeight(db40);
            String text = DwgFileV12Reader.this.getString();
            txt.setText(text);
            if ((opts & 1) > 0) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
                double db50 = bb.getDouble();
                txt.setRotationAngle(db50);
            }
            if ((opts & 2) > 0) {
                double db41 = bb.getDouble();
                txt.setWidthFactor(db41);
            }
            if ((opts & 4) > 0) {
                double db51 = bb.getDouble();
                txt.setObliqueAngle(db51);
            }
            if ((opts & 8) > 0) {
                byte db51 = bb.get();
            }
            if ((opts & 0x10) > 0) {
                byte b71 = bb.get();
                txt.setGeneration(b71);
            }
            if ((opts & 0x20) > 0) {
                byte b72 = bb.get();
                txt.setHalign(b72);
            }
            if ((opts & 0x40) > 0) {
                double[] pt11 = DwgFileV12Reader.this.getPoint(false);
                txt.setAlignmentPoint(new Point2D.Double(pt11[0], pt11[1]));
            }
            if ((opts & 0x100) > 0) {
                byte b73 = bb.get();
                txt.setValign(b73);
            }
            double[] ext = new double[]{0.0, 0.0, 1.0};
            txt.setExtrusion(ext);
        }
    }

    class ShapeReader
    implements EntityReader {
        ShapeReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            double[] pt10 = DwgFileV12Reader.this.getPoint(false);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            short w2 = bb.getShort();
            if ((opts & 1) > 0) {
                double[] dArray = DwgFileV12Reader.this.getPoint(true);
            }
            if ((opts & 2) > 0) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
                double d = bb.getDouble();
            }
        }
    }

    class CircleReader
    implements EntityReader {
        CircleReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            if (!(dwgObj instanceof DwgCircle)) {
                throw new RuntimeException("No es entidad CIRCLE");
            }
            DwgCircle circle = (DwgCircle)dwgObj;
            boolean zflag = true;
            if ((flags & 4) > 0) {
                zflag = false;
            }
            double[] pt10 = DwgFileV12Reader.this.getPoint(zflag);
            circle.setCenter(pt10);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            double d40 = bb.getDouble();
            circle.setRadius(d40);
            double[] pt210 = null;
            pt210 = (opts & 1) > 0 ? DwgFileV12Reader.this.getPoint(true) : new double[]{0.0, 0.0, 1.0};
            circle.setExtrusion(pt210);
            if ((opts & 2) > 0) {
                double db38;
                bb.order(ByteOrder.LITTLE_ENDIAN);
                circle.getCenter()[2] = db38 = bb.getDouble();
            }
        }
    }

    class PointReader
    implements EntityReader {
        PointReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            if (!(dwgObj instanceof DwgPoint)) {
                throw new RuntimeException("No es entidad POINT");
            }
            DwgPoint point = (DwgPoint)dwgObj;
            boolean zflag = true;
            if ((flags & 4) > 0) {
                zflag = false;
            }
            double[] pt10 = DwgFileV12Reader.this.getPoint(zflag);
            point.setPoint(pt10);
            if ((opts & 1) > 0) {
                double[] pt210 = DwgFileV12Reader.this.getPoint(true);
                point.setExtrusion(pt210);
            }
            if ((opts & 2) > 0) {
                double db38;
                bb.order(ByteOrder.LITTLE_ENDIAN);
                point.getPoint()[2] = db38 = bb.getDouble();
            }
        }
    }

    class LineReader
    implements EntityReader {
        LineReader() {
        }

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            if (!(dwgObj instanceof DwgLine)) {
                throw new RuntimeException("No es entidad LINE");
            }
            DwgLine line = (DwgLine)dwgObj;
            boolean zflag = true;
            if ((flags & 4) > 0) {
                zflag = false;
            }
            double[] pt10 = DwgFileV12Reader.this.getPoint(zflag);
            double[] pt11 = DwgFileV12Reader.this.getPoint(zflag);
            line.setP1(pt10);
            line.setP2(pt11);
            if ((opts & 1) > 0) {
                double[] pt210 = DwgFileV12Reader.this.getPoint(true);
                line.setExtrusion(pt210);
            }
            if ((opts & 2) > 0) {
                double db38;
                bb.order(ByteOrder.LITTLE_ENDIAN);
                line.getP1()[2] = db38 = bb.getDouble();
                line.getP2()[2] = db38;
            }
        }
    }

    abstract class DefferedEntityReader
    implements EntityReader {
        DefferedEntityReader() {
        }

        abstract DwgObject getDwgObject(int var1);

        @Override
        public void read(ByteBuffer bb, byte flags, short opts, DwgObject dwgObj) {
            if (dwgObj != null) {
                throw new RuntimeException("DefferedEntityReader es el encargado de construir los objetos, debe recibirlos a null");
            }
        }
    }

    static interface EntityReader {
        public void read(ByteBuffer var1, byte var2, short var3, DwgObject var4);
    }

    class Block {
        byte flag;
        String name;
        short used;
        byte b1;
        short w1;
        byte b2;
        short w3;
        short crc;

        Block() {
        }
    }
}

