/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers.v2004;

import java.util.ArrayList;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.objects.DwgDictionary;
import org.gvsig.dwg.lib.readers.v2004.AbstractDwg2004Reader;

public class DwgDictionaryReader2004
extends AbstractDwg2004Reader {
    @Override
    public void readSpecificObj(int[] data, int offset, DwgObject dwgObj) {
        if (!(dwgObj instanceof DwgDictionary)) {
            throw new RuntimeException("DictionaryReader2004 solo puede leer DwgDictionary");
        }
        DwgDictionary dict = (DwgDictionary)dwgObj;
        try {
            int bitPos = offset;
            ArrayList v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            int numReactors = (Integer)v.get(1);
            dict.setNumReactors(numReactors);
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            boolean XdicFlag = (Boolean)v.get(1);
            v = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)v.get(0);
            int numItems = (Integer)v.get(1);
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            int cloningFlag = (Integer)v.get(1);
            dict.setCloningFlag(cloningFlag);
            v = DwgUtil.getRawChar(data, bitPos);
            bitPos = (Integer)v.get(0);
            int hardOwnerFlag = (Integer)v.get(1);
            dict.setHardOwnerFlag(hardOwnerFlag);
            dict.inserta();
            ArrayList<String> entradasTexto = new ArrayList<String>();
            for (int i = 0; i < numItems; ++i) {
                v = DwgUtil.getTextString(data, bitPos);
                bitPos = (Integer)v.get(0);
                String text = (String)v.get(1);
                entradasTexto.add(text);
            }
            for (int i = 0; i < numItems; ++i) {
                DwgHandleReference handle = new DwgHandleReference();
                bitPos = handle.read(data, bitPos);
                dict.put(entradasTexto.get(i), handle);
            }
        }
        catch (Exception e) {
            System.out.println("Se ha producido una excepion leyendo un diccionario." + e.getMessage());
        }
    }
}

