/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers.v2004;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.objects.DwgText;
import org.gvsig.dwg.lib.readers.v2004.AbstractDwg2004Reader;
import org.gvsig.dwg.lib.util.TextToUnicodeConverter;

public class DwgTextReader2004
extends AbstractDwg2004Reader {
    @Override
    public void readSpecificObj(int[] data, int offset, DwgObject dwgObj) throws RuntimeException, CorruptedDwgEntityException {
        double th;
        double z;
        double y;
        double x;
        if (!(dwgObj instanceof DwgText)) {
            throw new RuntimeException("TextReader 2004 solo puede leer DwgText");
        }
        DwgText txt = (DwgText)dwgObj;
        int bitPos = offset;
        bitPos = this.readObjectHeader(data, bitPos, txt);
        ArrayList v = DwgUtil.getRawChar(data, bitPos);
        bitPos = (Integer)v.get(0);
        int dflag = (Integer)v.get(1);
        txt.setDataFlag(dflag);
        if ((dflag & 1) == 0) {
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            double elev = (Double)v.get(1);
            txt.setElevation(elev);
        }
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double x1 = (Double)v.get(1);
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double y1 = (Double)v.get(1);
        txt.setInsertionPoint(new Point2D.Double(x1, y1));
        if ((dflag & 2) == 0) {
            v = DwgUtil.getDefaultDouble(data, bitPos, x1);
            bitPos = (Integer)v.get(0);
            double xa = (Double)v.get(1);
            v = DwgUtil.getDefaultDouble(data, bitPos, y1);
            bitPos = (Integer)v.get(0);
            double ya = (Double)v.get(1);
            txt.setAlignmentPoint(new Point2D.Double(xa, ya));
        }
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean flag = (Boolean)v.get(1);
        if (flag) {
            x = 0.0;
            y = 0.0;
            z = 1.0;
        } else {
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            x = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            z = (Double)v.get(1);
        }
        txt.setExtrusion(new double[]{x, y, z});
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        flag = (Boolean)v.get(1);
        if (flag) {
            th = 0.0;
        } else {
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            th = (Double)v.get(1);
        }
        txt.setThickness(th);
        if ((dflag & 4) == 0) {
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            double oblique = (Double)v.get(1);
            txt.setObliqueAngle(oblique);
        }
        if ((dflag & 8) == 0) {
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            double rot = (Double)v.get(1);
            txt.setRotationAngle(rot);
        }
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double height = (Double)v.get(1);
        txt.setHeight(height);
        if ((dflag & 0x10) == 0) {
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            double width = (Double)v.get(1);
            txt.setWidthFactor(width);
        }
        v = DwgUtil.getTextString(data, bitPos);
        bitPos = (Integer)v.get(0);
        String text = (String)v.get(1);
        text = TextToUnicodeConverter.convertText(text);
        txt.setText(text);
        if ((dflag & 0x20) == 0) {
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            int gen = (Integer)v.get(1);
            txt.setGeneration(gen);
        }
        if ((dflag & 0x40) == 0) {
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            int halign = (Integer)v.get(1);
            txt.setHalign(halign);
        }
        if ((dflag & 0x80) == 0) {
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            int valign = (Integer)v.get(1);
            txt.setValign(valign);
        }
        txt.inserta();
        bitPos = this.readObjectTailer(data, bitPos, txt);
    }
}

