/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.exportto.generic.util;

import java.awt.geom.PathIterator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.gpe.exportto.generic.util.CoordinatesSequenceGeneralPath;
import org.gvsig.gpe.exportto.generic.util.CoordinatesSequencePoint;
import org.gvsig.gpe.lib.api.writer.ICoordinateSequence;
import org.gvsig.gpe.lib.api.writer.IGPEWriterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryToGPEWriter {
    private static Logger logger = LoggerFactory.getLogger(GeometryToGPEWriter.class);
    private IGPEWriterHandler writer = null;
    private String srs = null;

    public GeometryToGPEWriter(IGPEWriterHandler writer) {
        this.writer = writer;
    }

    public String getCrs() {
        return this.srs;
    }

    public void setCrs(String thesrs) {
        this.srs = thesrs;
    }

    public void writeGeometry(Geometry geom, boolean addLabelPoint) {
        if (geom == null) {
            logger.error("GPE Writer cannot write geometry.", (Throwable)new Exception("Geometry is NULL"));
            return;
        }
        if (geom instanceof MultiPoint) {
            this.writeMultiPoint((MultiPoint)geom);
            return;
        }
        if (geom instanceof MultiCurve) {
            this.writeMultiLine((MultiCurve)geom, addLabelPoint);
            return;
        }
        if (geom instanceof MultiSurface) {
            this.writeMultiPolygon((MultiSurface)geom, addLabelPoint);
            return;
        }
        if (geom instanceof Point) {
            this.writePoint((Point)geom);
            return;
        }
        if (geom instanceof Curve) {
            this.writeLine((Curve)geom, addLabelPoint);
            return;
        }
        if (geom instanceof Surface) {
            this.writePolygon((Surface)geom, addLabelPoint);
            return;
        }
        logger.error("GPE Writer cannot write geometry", (Throwable)new Exception("Unexpected geometry: " + geom.getClass().getName()));
    }

    private void writePoint(Point point) {
        this.writer.startPoint(null, (ICoordinateSequence)new CoordinatesSequencePoint(point), this.srs);
        this.writer.endPoint();
    }

    private void writeMultiPoint(MultiPoint multi) {
        this.writer.startMultiPoint(null, this.srs);
        for (int i = 0; i < multi.getPrimitivesNumber(); ++i) {
            Point p = multi.getPointAt(i);
            this.writePoint(p);
        }
        this.writer.endMultiPoint();
    }

    private void writeLine(Curve curve, boolean addLabelPoint) {
        boolean ismulti = this.isMultiple(curve.getPathIterator(null));
        if (addLabelPoint) {
            Point po = null;
            try {
                po = this.getLabelPoint(curve.getPathIterator(null), curve.getEnvelope());
            }
            catch (Exception ex) {
                logger.info("While getting label point.", (Throwable)ex);
                return;
            }
            this.writer.startMultiGeometry(null, this.srs);
            CoordinatesSequencePoint pseq = new CoordinatesSequencePoint(po);
            this.writer.startPoint(null, (ICoordinateSequence)pseq, this.srs);
            this.writer.endPoint();
        } else if (ismulti) {
            this.writer.startMultiLineString(null, this.srs);
        }
        CoordinatesSequenceGeneralPath sequence = new CoordinatesSequenceGeneralPath(curve.getPathIterator(null));
        this.writer.startLineString(null, (ICoordinateSequence)sequence, this.srs);
        this.writer.endLineString();
        if (ismulti) {
            while (sequence.hasMoreGeometries()) {
                sequence.initialize();
                this.writer.startLineString(null, (ICoordinateSequence)sequence, this.srs);
                this.writer.endLineString();
            }
        }
        if (addLabelPoint) {
            this.writer.endMultiGeometry();
        } else if (ismulti) {
            this.writer.endMultiLineString();
        }
    }

    private void writeMultiLine(MultiCurve mcurve, boolean addLabelPoint) {
        if (addLabelPoint) {
            Point po = null;
            try {
                po = this.getLabelPoint(mcurve.getPathIterator(null), mcurve.getEnvelope());
            }
            catch (Exception exc) {
                logger.info("While getting label point.", (Throwable)exc);
                return;
            }
            this.writer.startMultiGeometry(null, this.srs);
            CoordinatesSequencePoint pseq = new CoordinatesSequencePoint(po);
            this.writer.startPoint(null, (ICoordinateSequence)pseq, this.srs);
            this.writer.endPoint();
        } else {
            this.writer.startMultiLineString(null, this.srs);
        }
        CoordinatesSequenceGeneralPath sequence = new CoordinatesSequenceGeneralPath(mcurve.getPathIterator(null));
        this.writer.startLineString(null, (ICoordinateSequence)sequence, this.srs);
        this.writer.endLineString();
        while (sequence.hasMoreGeometries()) {
            sequence.initialize();
            this.writer.startLineString(null, (ICoordinateSequence)sequence, this.srs);
            this.writer.endLineString();
        }
        if (addLabelPoint) {
            this.writer.endMultiGeometry();
        } else {
            this.writer.endMultiLineString();
        }
    }

    private void writePolygon(Surface surface, boolean addLabelPoint) {
        boolean ismulti = this.isMultiple(surface.getPathIterator(null));
        CoordinatesSequenceGeneralPath sequence = null;
        if (addLabelPoint) {
            Point po = null;
            try {
                po = surface.getInteriorPoint();
            }
            catch (Exception ex) {
                logger.info("While getting label point.", (Throwable)ex);
                return;
            }
            this.writer.startMultiGeometry(null, this.srs);
            CoordinatesSequencePoint pseq = new CoordinatesSequencePoint(po);
            this.writer.startPoint(null, (ICoordinateSequence)pseq, this.srs);
            this.writer.endPoint();
        } else if (ismulti) {
            this.writer.startMultiPolygon(null, this.srs);
        }
        sequence = new CoordinatesSequenceGeneralPath(surface.getPathIterator(null));
        this.writer.startPolygon(null, (ICoordinateSequence)sequence, this.srs);
        this.writer.endPolygon();
        if (ismulti) {
            while (sequence.hasMoreGeometries()) {
                sequence.initialize();
                this.writer.startPolygon(null, (ICoordinateSequence)sequence, this.srs);
                this.writer.endPolygon();
            }
        }
        if (addLabelPoint) {
            this.writer.endMultiGeometry();
        } else if (ismulti) {
            this.writer.endMultiPolygon();
        }
    }

    private Point getLabelPoint(PathIterator pathIterator, Envelope envelope) throws Exception {
        if (pathIterator == null || envelope == null) {
            throw new Exception("Null iterator or envelope");
        }
        double bestx = 0.0;
        double besty = 0.0;
        double cx = envelope.getCenter(0);
        double cy = envelope.getCenter(1);
        double dist = Double.MAX_VALUE;
        double auxdist = 0.0;
        double[] coords = new double[6];
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(coords);
            auxdist = this.getDist2(cx, cy, coords[0], coords[1]);
            if (auxdist < dist) {
                dist = auxdist;
                bestx = coords[0];
                besty = coords[1];
            }
            pathIterator.next();
        }
        Point resp = GeometryLocator.getGeometryManager().createPoint(bestx, besty, 0);
        return resp;
    }

    private Point getLabelPoint(MultiSurface msurf) throws Exception {
        if (msurf == null) {
            throw new Exception("Surface is Null");
        }
        int n = msurf.getPrimitivesNumber();
        Surface surf = null;
        Surface bigsurf = null;
        double importance = 0.0;
        double auximportance = 0.0;
        Envelope env = null;
        long nverts = 0L;
        for (int i = 0; i < n; ++i) {
            surf = (Surface)msurf.getPrimitiveAt(i);
            nverts = surf.getNumVertices();
            auximportance = (double)nverts * (env = surf.getEnvelope()).getLength(0) * env.getLength(1);
            if (!(auximportance >= importance)) continue;
            importance = auximportance;
            bigsurf = surf;
        }
        if (bigsurf != null) {
            return bigsurf.getInteriorPoint();
        }
        return msurf.getInteriorPoint();
    }

    private double getDist2(double ax, double ay, double bx, double by) {
        double dx = bx - ax;
        double dy = by - ay;
        return dx * dx + dy * dy;
    }

    private void writeMultiPolygon(MultiSurface msurface, boolean addLabelPoint) {
        if (addLabelPoint) {
            Point po = null;
            try {
                po = this.getLabelPoint(msurface);
            }
            catch (Exception ex) {
                logger.info("While getting label point.", (Throwable)ex);
                return;
            }
            this.writer.startMultiGeometry(null, this.srs);
            CoordinatesSequencePoint pseq = new CoordinatesSequencePoint(po);
            this.writer.startPoint(null, (ICoordinateSequence)pseq, this.srs);
            this.writer.endPoint();
        } else {
            this.writer.startMultiPolygon(null, this.srs);
        }
        CoordinatesSequenceGeneralPath sequence = new CoordinatesSequenceGeneralPath(msurface.getPathIterator(null));
        this.writer.startPolygon(null, (ICoordinateSequence)sequence, this.srs);
        this.writer.endPolygon();
        while (sequence.hasMoreGeometries()) {
            sequence.initialize();
            this.writer.startPolygon(null, (ICoordinateSequence)sequence, this.srs);
            this.writer.endPolygon();
        }
        if (addLabelPoint) {
            this.writer.endMultiGeometry();
        } else {
            this.writer.endMultiPolygon();
        }
    }

    public boolean isMultiple(PathIterator path) {
        double[] coords = new double[2];
        int type = 0;
        int numGeometries = 0;
        while (!path.isDone()) {
            type = path.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (++numGeometries != 2) break;
                    return true;
                }
            }
            path.next();
        }
        return false;
    }
}

