/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.preferences.general;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.coreplugin.preferences.general.GeneralPage;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.gui.beans.swing.JButton;

public class ScreenSettingsPage
extends AbstractPreferencePage {
    protected static String id = ScreenSettingsPage.class.getName();
    private static final long serialVersionUID = 6012279465073443753L;
    private static final double MILLIMETERS_PER_INCH = 2.54;
    private static Preferences prefs = Preferences.userRoot().node("gvsig.configuration.screen");
    private ImageIcon icon;
    private JPanel pTestMeasure;
    private JTextField txtResolution;
    private JTextField txtMeasure;
    private JComboBox cmbUnits;
    private JButton btnRefresh;

    public ScreenSettingsPage() {
        this.setParentID(GeneralPage.id);
        this.icon = PluginServices.getIconTheme().get("edit-setup-screensetting");
        this.txtResolution = new JTextField("", 15);
        this.addComponent(PluginServices.getText((Object)((Object)this), (String)"resolution") + ":", this.txtResolution);
        this.pTestMeasure = new TestMeasurePanel();
        this.addComponent(this.pTestMeasure);
        this.addComponent(new JLabel(PluginServices.getText((Object)((Object)this), (String)"the_length_of_the_line_above_is") + ":"));
        this.cmbUnits = new JComboBox();
        this.cmbUnits.addItem(PluginServices.getText((Object)((Object)this), (String)"centimeters"));
        this.cmbUnits.addItem(PluginServices.getText((Object)((Object)this), (String)"inches"));
        this.cmbUnits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        this.txtMeasure = new JTextField();
        this.addComponent(this.txtMeasure, this.cmbUnits);
        this.addComponent((Component)new JBlank(1, 1));
        this.btnRefresh = new JButton(PluginServices.getText((Object)((Object)this), (String)"button.resolution.calculate"));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                double d = Double.parseDouble(ScreenSettingsPage.this.txtMeasure.getText().replace(',', '.'));
                if (ScreenSettingsPage.this.cmbUnits.getSelectedIndex() == 0) {
                    ScreenSettingsPage.this.txtResolution.setText(String.valueOf((int)(533.4 / d)));
                } else {
                    ScreenSettingsPage.this.txtResolution.setText(String.valueOf((int)(210.0 / d)));
                }
            }
        });
        this.addComponent((Component)this.btnRefresh);
        this.initialize();
    }

    private void initialize() {
    }

    public void storeValues() throws StoreException {
        int dpi = Integer.parseInt(this.txtResolution.getText());
        prefs.putInt("dpi", dpi);
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }

    public String getID() {
        return id;
    }

    public String getTitle() {
        return PluginServices.getText((Object)((Object)this), (String)"options.configuration.screen");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        double dpi = kit.getScreenResolution();
        int resDPI = prefs.getInt("dpi", (int)dpi);
        this.txtResolution.setText(String.valueOf(resDPI));
        this.txtMeasure.setText(String.valueOf(this.format(533.4 / (double)resDPI)));
        this.cmbUnits.setSelectedIndex(0);
    }

    public void initializeDefaults() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        int dpi = kit.getScreenResolution();
        this.txtResolution.setText(String.valueOf(dpi));
        this.txtMeasure.setText(String.valueOf(this.format(533.4 / (double)dpi)));
        this.cmbUnits.setSelectedIndex(0);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        return super.hasChanged();
    }

    private String format(double d) {
        NumberFormat nf = NumberFormat.getInstance();
        if (d % (double)((long)d) != 0.0) {
            nf.setMaximumFractionDigits(2);
        } else {
            nf.setMaximumFractionDigits(0);
        }
        return nf.format(d);
    }

    private class TestMeasurePanel
    extends JPanel {
        private static final long serialVersionUID = -8307475893309753439L;

        public TestMeasurePanel() {
            this.setPreferredSize(new Dimension(250, 60));
            TitledBorder border = BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"test_measure"));
            this.setBorder(border);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            g.setColor(Color.black);
            g.drawLine(20, 30, 230, 30);
            g.drawLine(20, 20, 20, 40);
            g.drawLine(230, 20, 230, 40);
        }
    }
}

