/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.stretch;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.prov.stretch.operation.StretchOperation;
import org.gvsig.vectorediting.lib.prov.stretch.operation.StretchOperationUtils;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StretchEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StretchEditingProvider.class);
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter geometryParameter;
    private final EditingServiceParameter firstPointParameter;
    private final EditingServiceParameter secondPointParameter;
    private Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private List<Feature> selectedFeatures;

    public StretchEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.selectionParameter = new DefaultEditingServiceParameter("selection", i18nManager.getTranslation("selection"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.geometryParameter = new DefaultEditingServiceParameter("Draw geometry", "draw_geometry_to_select_vertex", 9, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.GEOMETRY});
        this.firstPointParameter = new DefaultEditingServiceParameter("first_point", i18nManager.getTranslation("first_point"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.POSITION});
        this.secondPointParameter = new DefaultEditingServiceParameter("second_point", i18nManager.getTranslation("second_point"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.POSITION});
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.selectionParameter);
        list.add(this.geometryParameter);
        list.add(this.firstPointParameter);
        list.add(this.secondPointParameter);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.selectionParameter) {
            if (!(value instanceof FeatureSelection)) return;
            this.values.put(param, value);
            this.selectedFeatures = this.getSelectedFeaturesCopy((FeatureSelection)value);
            return;
        }
        if (param == this.firstPointParameter) {
            if (!(value instanceof Point)) return;
            this.values.put(param, value);
            return;
        }
        if (param == this.secondPointParameter) {
            if (!(value instanceof Point)) return;
            this.values.put(param, value);
            return;
        }
        if (param != this.geometryParameter) return;
        if (!(value instanceof Geometry)) return;
        Geometry geometry = (Geometry)value;
        FeatureSelection selection = (FeatureSelection)this.values.get(this.selectionParameter);
        DisposableIterator it = null;
        try {
            it = selection.fastIterator();
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                Geometry defaultGeometry = feature.getDefaultGeometry();
                if (defaultGeometry.intersects(geometry) || defaultGeometry.contains(geometry)) {
                    this.values.put(param, value);
                    return;
                }
            }
            throw new InvalidEntryException(null);
        }
        catch (BaseException e) {
            throw new InvalidEntryException((Throwable)e);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)it);
        }
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selectionParameter) == null) {
            return this.selectionParameter;
        }
        if (this.values.get(this.geometryParameter) == null) {
            return this.geometryParameter;
        }
        if (this.values.get(this.firstPointParameter) == null) {
            return this.firstPointParameter;
        }
        if (this.values.get(this.secondPointParameter) == null) {
            return this.secondPointParameter;
        }
        return null;
    }

    public static Geometry applyTransform(Geometry geometry, AffineTransform at, Geometry roi) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        StretchOperation operation;
        if (geometry instanceof MultiPrimitive) {
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            MultiPrimitive aggregate = (MultiPrimitive)geometry;
            GeometryType geometryType = aggregate.getGeometryType();
            MultiPrimitive newAggregate = (MultiPrimitive)geometryManager.create(geometryType.getType(), geometryType.getSubType());
            for (int i = 0; i < aggregate.getPrimitivesNumber(); ++i) {
                Primitive primitive = aggregate.getPrimitiveAt(i);
                StretchOperation operation2 = StretchOperationUtils.getOperation(primitive);
                if (operation2 != null) {
                    Geometry element = operation2.transform(at, primitive, roi);
                    if (element instanceof MultiPrimitive) {
                        for (int j = 0; j < ((MultiPrimitive)element).getPrimitivesNumber(); ++j) {
                            newAggregate.addPrimitive(((MultiPrimitive)element).getPrimitiveAt(j));
                        }
                        continue;
                    }
                    if (element instanceof Primitive) {
                        newAggregate.addPrimitive((Primitive)element);
                        continue;
                    }
                    LOGGER.warn("StretchOperation has returned a not-supported geometry type. " + operation2.toString() + " " + element.getClass().getName());
                    continue;
                }
                newAggregate.addPrimitive(primitive);
            }
            return newAggregate;
        }
        if (geometry instanceof Primitive && (operation = StretchOperationUtils.getOperation((Primitive)geometry)) != null) {
            return operation.transform(at, (Primitive)geometry, roi);
        }
        return geometry;
    }

    public static List<Point> getSelectedVertex(Geometry geometry, Geometry roi) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive primitive;
        StretchOperation operation;
        ArrayList<Point> selectedVertex = new ArrayList<Point>();
        if (geometry instanceof MultiPrimitive) {
            MultiPrimitive aggregate = (MultiPrimitive)geometry;
            for (int i = 0; i < aggregate.getPrimitivesNumber(); ++i) {
                Primitive primitive2 = aggregate.getPrimitiveAt(i);
                StretchOperation operation2 = StretchOperationUtils.getOperation(primitive2);
                if (operation2 == null) continue;
                selectedVertex.addAll(operation2.getSelectedVertex(primitive2, roi));
            }
        } else if (geometry instanceof Primitive && (operation = StretchOperationUtils.getOperation(primitive = (Primitive)geometry)) != null) {
            selectedVertex.addAll(operation.getSelectedVertex(primitive, roi));
        }
        return selectedVertex;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        block21: {
            DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol selectedVertexEditingSymbol = editingProviderManager.getSymbol("selected-vertex-symbol-editing");
            ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
            ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            FeatureSelection selection = (FeatureSelection)this.values.get(this.selectionParameter);
            try {
                if (!CollectionUtils.isNotEmpty(this.selectedFeatures)) break block21;
                Geometry geometry = (Geometry)this.values.get(this.geometryParameter);
                if (geometry != null) {
                    Point firstPoint;
                    ArrayList<Point> selectedVertex = new ArrayList<Point>();
                    try {
                        for (Feature feature : this.selectedFeatures) {
                            Geometry featureGeometry = feature.getDefaultGeometry();
                            List<Point> vertex = StretchEditingProvider.getSelectedVertex(featureGeometry, geometry);
                            if (vertex == null) continue;
                            selectedVertex.addAll(vertex);
                        }
                    }
                    catch (BaseException e) {
                        throw new InvalidEntryException((Throwable)e);
                    }
                    if (!selectedVertex.isEmpty()) {
                        for (Point point : selectedVertex) {
                            drawingStatus.addStatus((Geometry)point, selectedVertexEditingSymbol, "");
                        }
                    }
                    if ((firstPoint = (Point)this.values.get(this.firstPointParameter)) != null) {
                        AffineTransform at = this.getMoveAffineTransform(firstPoint, mousePosition);
                        if (!selectedVertex.isEmpty()) {
                            Iterator<Object> iterator = selectedVertex.iterator();
                            while (iterator.hasNext()) {
                                Point point = ((Point)iterator.next()).cloneGeometry();
                                point.transform(at);
                                drawingStatus.addStatus((Geometry)point, selectedVertexEditingSymbol, "");
                            }
                        }
                        try {
                            for (Feature feature : this.selectedFeatures) {
                                ISymbol previewSymbol = this.getPreviewSymbol(feature);
                                Geometry featureGeometry = feature.getDefaultGeometry();
                                Geometry transformedGeometry = StretchEditingProvider.applyTransform(featureGeometry, at, geometry);
                                ISymbol symbol = null;
                                if (transformedGeometry instanceof Curve || transformedGeometry instanceof MultiCurve) {
                                    symbol = lineSymbolEditing;
                                } else if (transformedGeometry instanceof Surface || transformedGeometry instanceof MultiSurface) {
                                    symbol = polygonSymbolEditing;
                                } else if (transformedGeometry instanceof Point || transformedGeometry instanceof MultiPoint) {
                                    symbol = auxiliaryPointSymbolEditing;
                                }
                                if (transformedGeometry instanceof Aggregate) {
                                    int primitivesNumber = ((Aggregate)transformedGeometry).getPrimitivesNumber();
                                    for (int i = 0; i < primitivesNumber; ++i) {
                                        drawingStatus.addStatus((Geometry)((Aggregate)transformedGeometry).getPrimitiveAt(i), symbol, "");
                                        drawingStatus.addStatus((Geometry)((Aggregate)transformedGeometry).getPrimitiveAt(i), previewSymbol, "");
                                    }
                                    continue;
                                }
                                drawingStatus.addStatus(transformedGeometry, symbol, "");
                                drawingStatus.addStatus(transformedGeometry, previewSymbol, "");
                            }
                        }
                        catch (BaseException e) {
                            throw new InvalidEntryException((Throwable)e);
                        }
                    }
                }
                return drawingStatus;
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return null;
    }

    private AffineTransform getMoveAffineTransform(Point p1, Point p2) {
        AffineTransform translate = AffineTransform.getTranslateInstance(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        return translate;
    }

    public void stop() {
        this.values.clear();
        this.selectedFeatures = Collections.EMPTY_LIST;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    public void finishAndStore() throws FinishServiceException {
        block5: {
            FeatureSelection selection = (FeatureSelection)this.values.get(this.selectionParameter);
            try {
                Point secondPoint;
                Point firstPoint;
                Geometry geometry;
                if (!CollectionUtils.isNotEmpty(this.selectedFeatures) || (geometry = (Geometry)this.values.get(this.geometryParameter)) == null || (firstPoint = (Point)this.values.get(this.firstPointParameter)) == null || (secondPoint = (Point)this.values.get(this.secondPointParameter)) == null) break block5;
                AffineTransform at = this.getMoveAffineTransform(firstPoint, secondPoint);
                try {
                    for (Feature feature : this.selectedFeatures) {
                        Geometry featureGeometry = feature.getDefaultGeometry();
                        Geometry geom = StretchEditingProvider.applyTransform(featureGeometry, at, geometry);
                        EditableFeature editableFeature = feature.getEditable();
                        editableFeature.setDefaultGeometry(geom);
                        this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
                    }
                }
                catch (BaseException e) {
                    throw new FinishServiceException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        if (this.featureStore != null) {
            FeatureSelection selected = null;
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("Can't init selection", (Throwable)ex);
            }
            if (selected != null && selected.getSelectedCount() > 0L) {
                this.values.put(this.selectionParameter, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public String getName() {
        return "modify-stretch";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

