/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.stretch.operation;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.EllipticArc;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Spline;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.vectorediting.lib.prov.stretch.operation.StretchOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StretchOperationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StretchOperationUtils.class);
    private static final Map<Integer, StretchOperation> operations = new HashMap<Integer, StretchOperation>();

    private StretchOperationUtils() {
    }

    public static void register(StretchOperation operation, int geometryType) {
        operations.put(geometryType, operation);
    }

    public static StretchOperation getOperation(Primitive geom) {
        Integer type = geom.getGeometryType().getType();
        if (StretchOperationUtils.isPolygon((Geometry)geom)) {
            type = 19;
        } else if (StretchOperationUtils.isLine((Geometry)geom)) {
            type = 18;
        }
        StretchOperation operation = operations.get(type);
        return operation;
    }

    private static boolean isPolygon(Geometry geometry) {
        if (!(geometry instanceof Surface)) {
            return false;
        }
        if (geometry instanceof Ellipse) {
            return false;
        }
        if (geometry instanceof EllipticArc) {
            return false;
        }
        return !(geometry instanceof Circle);
    }

    private static boolean isLine(Geometry geometry) {
        if (!(geometry instanceof Curve)) {
            return false;
        }
        if (geometry instanceof Arc) {
            return false;
        }
        return !(geometry instanceof Spline);
    }

    public static void setVertex(OrientablePrimitive geom, int index, Point p) {
        Point point = geom.getVertex(index);
        int min = p.getDimension() < point.getDimension() ? p.getDimension() : point.getDimension();
        for (int i = 0; i < min; ++i) {
            point.setCoordinateAt(i, p.getCoordinateAt(i));
        }
    }
}

