/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.stretch.operation;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.vectorediting.lib.prov.stretch.operation.StretchOperation;
import org.gvsig.vectorediting.lib.prov.stretch.operation.StretchOperationUtils;

public class SurfaceStretchOperation
implements StretchOperation {
    @Override
    public Geometry transform(AffineTransform at, Primitive geom, Geometry roi) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        Polygon polygon = geometryManager.createPolygon(geom.getGeometryType().getSubType());
        polygon.setGeneralPath((GeneralPathX)geom.getGeneralPath().clone());
        for (int j = 0; j < polygon.getNumVertices(); ++j) {
            Point point = polygon.getVertex(j);
            if (!roi.intersects((Geometry)point) && !roi.contains((Geometry)point)) continue;
            point.transform(at);
            StretchOperationUtils.setVertex((OrientablePrimitive)polygon, j, point);
        }
        return polygon;
    }

    @Override
    public List<Point> getSelectedVertex(Primitive geom, Geometry roi) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        ArrayList<Point> vertexList = new ArrayList<Point>();
        Polygon polygon = geometryManager.createPolygon(geom.getGeometryType().getSubType());
        polygon.setGeneralPath(geom.getGeneralPath());
        for (int j = 0; j < polygon.getNumVertices(); ++j) {
            Point point = polygon.getVertex(j);
            if (!roi.intersects((Geometry)point) && !roi.contains((Geometry)point)) continue;
            vertexList.add(point);
        }
        return vertexList;
    }
}

