/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.filedialogchooser.impl;

import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileFilter;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.filedialogchooser.FileDialogChooserManager;
import org.gvsig.filedialogchooser.impl.DefaultFileDialogChooserManager;
import org.gvsig.tools.swing.api.pickercontroller.CharsetPickerController;
import org.gvsig.tools.util.ToolsUtilLocator;

public class VFSJFileChooserBased
implements FileDialogChooser {
    private final VFSJFileChooser jfc = new VFSJFileChooser();
    private final String fileChooserID;
    private boolean visibleCharsetPicker;
    private CharsetPickerController charsetPicker;

    public VFSJFileChooserBased(String fileChooserID) {
        this.fileChooserID = fileChooserID;
    }

    public void setCurrentDirectory(File dir) {
        if (dir == null) {
            dir = new File(System.getProperty("user.home"));
        }
        this.jfc.setCurrentDirectory(dir);
    }

    public File getCurrentDirectory() {
        return this.jfc.getCurrentDirectory();
    }

    public void setDialogTitle(String dialogTitle) {
        this.jfc.setDialogTitle(dialogTitle);
    }

    public void setDialogType(int dialogType) {
        switch (dialogType) {
            default: {
                this.jfc.setDialogType(VFSJFileChooser.DIALOG_TYPE.OPEN);
                break;
            }
            case 1: {
                this.jfc.setDialogType(VFSJFileChooser.DIALOG_TYPE.SAVE);
            }
        }
    }

    public void setDragEnabled(boolean b) {
        this.jfc.setDragEnabled(b);
    }

    public void setFileFilter(FileFilter filter) {
        if (filter == null) {
            this.jfc.setFileFilter(null);
        } else {
            this.jfc.setFileFilter((AbstractVFSFileFilter)new FileFilterAdapter(filter));
        }
    }

    public FileFilter getFileFilter() {
        FileFilterAdapter f = (FileFilterAdapter)this.jfc.getFileFilter();
        return f.getFilter();
    }

    public void setFileSelectionMode(int mode) {
        switch (mode) {
            case 0: {
                this.jfc.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.FILES_ONLY);
                break;
            }
            case 1: {
                this.jfc.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.DIRECTORIES_ONLY);
                break;
            }
            default: {
                this.jfc.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.FILES_AND_DIRECTORIES);
            }
        }
    }

    public File getSelectedFile() {
        return this.jfc.getSelectedFile();
    }

    public File[] getSelectedFiles() {
        return this.jfc.getSelectedFiles();
    }

    public void setFileHidingEnabled(boolean b) {
        this.jfc.setFileHidingEnabled(b);
    }

    public void setMultiSelectionEnabled(boolean b) {
        this.jfc.setMultiSelectionEnabled(b);
    }

    public boolean isMultiSelectionEnabled() {
        return this.jfc.isMultiSelectionEnabled();
    }

    public int showOpenDialog(Component parent) {
        VFSJFileChooser.RETURN_TYPE r;
        FileDialogChooserManager manager = ToolsUtilLocator.getFileDialogChooserManager();
        File f = this.getCurrentDirectory();
        if (f == null) {
            f = manager.getLastPath(this.fileChooserID, null);
            this.jfc.setCurrentDirectory(f);
        }
        if (this.visibleCharsetPicker) {
            this.charsetPicker = DefaultFileDialogChooserManager.setCharsetAccesoryPanel(this);
        }
        if ((r = this.jfc.showOpenDialog(parent)) == VFSJFileChooser.RETURN_TYPE.CANCEL) {
            return 1;
        }
        if (r == VFSJFileChooser.RETURN_TYPE.APPROVE) {
            manager.setLastPath(this.fileChooserID, this.getCurrentDirectory());
            return 0;
        }
        if (r == VFSJFileChooser.RETURN_TYPE.ERROR) {
            return -1;
        }
        return -1;
    }

    public int showSaveDialog(Component parent) {
        return this.showSaveDialog(parent, null);
    }

    public int showSaveDialog(Component parent, File folder) {
        VFSJFileChooser.RETURN_TYPE r;
        FileDialogChooserManager manager = ToolsUtilLocator.getFileDialogChooserManager();
        if (folder != null) {
            this.jfc.setCurrentDirectory(folder);
        } else {
            File f = manager.getLastPath(this.fileChooserID, this.getCurrentDirectory());
            this.jfc.setCurrentDirectory(f);
        }
        if (this.visibleCharsetPicker) {
            this.charsetPicker = DefaultFileDialogChooserManager.setCharsetAccesoryPanel(this);
        }
        if ((r = this.jfc.showSaveDialog(parent)) == VFSJFileChooser.RETURN_TYPE.CANCEL) {
            return 1;
        }
        if (r == VFSJFileChooser.RETURN_TYPE.APPROVE) {
            manager.setLastPath(this.fileChooserID, this.getCurrentDirectory());
            return 0;
        }
        if (r == VFSJFileChooser.RETURN_TYPE.ERROR) {
            return -1;
        }
        return -1;
    }

    public void setAcceptAllFileFilterUsed(boolean b) {
        this.jfc.setAcceptAllFileFilterUsed(b);
    }

    public void addChoosableFileFilter(FileFilter next) {
        this.jfc.addChoosableFileFilter((AbstractVFSFileFilter)new FileFilterAdapter(next));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.jfc.addPropertyChangeListener(listener);
    }

    public void setAccessory(JComponent newAccessory) {
        this.jfc.setAccessory(newAccessory);
    }

    public void setVisibleCharsetPicker(boolean b) {
        this.visibleCharsetPicker = b;
    }

    public Charset getCharset() {
        if (this.charsetPicker == null) {
            return null;
        }
        return (Charset)this.charsetPicker.get();
    }

    private static class FileFilterAdapter
    extends AbstractVFSFileFilter {
        private final FileFilter filter;

        FileFilterAdapter(FileFilter filter) {
            this.filter = filter;
        }

        public boolean accept(FileObject f) {
            if (f instanceof LocalFile) {
                return this.filter.accept(new File(f.getName().getPath()));
            }
            return false;
        }

        public String getDescription() {
            return this.filter.getDescription();
        }

        public FileFilter getFilter() {
            return this.filter;
        }
    }
}

