/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.gui.wizards.WizardListener;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.WCSParamsPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderWizardPanel
implements WizardListener,
ListSelectionListener {
    private Logger logger = LoggerFactory.getLogger(LoaderWizardPanel.class);
    private WizardPanel wizardPanel;
    private JButton OKButton;
    private JButton CancelButton;
    private DataStoreParameters dataStoreParameters;

    public LoaderWizardPanel(WizardPanel panel) {
        this(panel, null);
    }

    public LoaderWizardPanel(WizardPanel panel, DataStoreParameters dataStoreParameters) {
        this.dataStoreParameters = dataStoreParameters;
        this.wizardPanel = panel;
        this.wizardPanel.setVisible(true);
        this.wizardPanel.setPreferredSize(new Dimension(510, 427));
        this.wizardPanel.addWizardListener((WizardListener)this);
        ((WCSParamsPanel)this.wizardPanel).getFormatsPanel().getLstCRSs().addListSelectionListener(this);
        ((WCSParamsPanel)this.wizardPanel).getFormatsPanel().getLstFormats().addListSelectionListener(this);
        this.OKButton = new JButton(Messages.getText((String)"Connect"));
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane pane = LoaderWizardPanel.this.getOptionPane((JComponent)e.getSource());
                pane.setValue(LoaderWizardPanel.this.OKButton);
            }
        });
        this.OKButton.setEnabled(false);
        this.CancelButton = new JButton(Messages.getText((String)"Cancel"));
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane pane = LoaderWizardPanel.this.getOptionPane((JComponent)e.getSource());
                pane.setValue(LoaderWizardPanel.this.CancelButton);
            }
        });
    }

    protected JOptionPane getOptionPane(JComponent parent) {
        JOptionPane pane = null;
        pane = !(parent instanceof JOptionPane) ? this.getOptionPane((JComponent)parent.getParent()) : (JOptionPane)parent;
        return pane;
    }

    public void wizardStateChanged(boolean finishable) {
        this.logger.debug("Thing happened!");
    }

    public WizardPanel getWizardPanel() {
        return this.wizardPanel;
    }

    public void error(Exception e) {
    }

    public boolean showWizardOnDialog() {
        int option = JOptionPane.showOptionDialog(null, this.wizardPanel, Messages.getText((String)"WCS_Parameters"), 2, -1, null, new JButton[]{this.CancelButton, this.OKButton}, this.OKButton);
        if (option == 1) {
            WCSParamsPanel wcsParamsPanel = (WCSParamsPanel)this.wizardPanel;
            this.dataStoreParameters.setDynValue("srsstr", (Object)wcsParamsPanel.getSRS());
            this.dataStoreParameters.setDynValue("format", (Object)wcsParamsPanel.getFormat());
            this.dataStoreParameters.setDynValue("parameter", (Object)wcsParamsPanel.getParameterPanel().getParameterString());
            return true;
        }
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.logger.debug("Thing happened!");
        WCSParamsPanel wcsParamsPanel = (WCSParamsPanel)this.wizardPanel;
        if (!StringUtils.isBlank((CharSequence)wcsParamsPanel.getSRS()) && !StringUtils.isBlank((CharSequence)wcsParamsPanel.getFormat())) {
            this.OKButton.setEnabled(true);
        }
    }
}

