/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.loaders;

import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.catalog.loaders.LayerLoader;
import org.gvsig.catalog.loaders.LayerLoaderException;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public abstract class GvSigLayerLoader
extends LayerLoader {
    protected static final MapContextManager MAP_CONTEXT_MANAGER = MapContextLocator.getMapContextManager();
    protected static final DataManager DATA_MANAGER = DALLocator.getDataManager();
    private static final ExtensionPointManager EXTENSION_POINT_MANAGER = ToolsLocator.getExtensionPointManager();

    public GvSigLayerLoader(Resource resource) {
        super(resource);
    }

    public void loadLayer() throws LayerLoaderException {
        FLayer layer;
        try {
            layer = this.hasSpecificLayer() ? this.createLayerFromExtensionPoint() : this.createLayerFromParameters();
        }
        catch (LayerLoaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LayerLoaderException("Can't load layer", (Throwable)e, this.getWindowMessage());
        }
        if (layer != null) {
            this.addLayerToView(layer);
        }
    }

    protected FLayer createLayerFromParameters() throws InitializeException, ProviderNotRegisteredException, LoadLayerException {
        DataStoreParameters dataStoreParameters = this.createDataStoreParameters();
        return MAP_CONTEXT_MANAGER.createLayer(this.getLayerName(), dataStoreParameters);
    }

    protected FLayer createLayerFromExtensionPoint() throws Exception {
        DataStoreParameters dataStoreParameters = this.createDataStoreParameters();
        ExtensionPoint extensionPoint = EXTENSION_POINT_MANAGER.get("CatalogLayers");
        return (FLayer)extensionPoint.create(this.extensionPointName(), new Object[]{dataStoreParameters});
    }

    protected void addLayerToView(FLayer lyr) {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        AbstractViewPanel theView = (AbstractViewPanel)application.getActiveWindow(ViewDocument.class);
        theView.getMapControl().getMapContext().getLayers().addLayer(lyr);
    }

    protected abstract boolean hasSpecificLayer();

    protected String extensionPointName() {
        return null;
    }

    protected abstract DataStoreParameters createDataStoreParameters() throws InitializeException, ProviderNotRegisteredException;

    protected abstract String getLayerName();
}

