/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.checkslidertext;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.gui.beans.slidertext.SliderTextContainer;

public class CheckSliderTextContainer
extends SliderTextContainer
implements ActionListener {
    private static final long serialVersionUID = -542842897847364459L;
    public JCheckBox check = null;
    private JPanel pLabel = null;
    private String text = null;
    private boolean showCheck = true;
    private JLabel labelWithoutCheck = null;

    public CheckSliderTextContainer(int min, int max, int defaultPos, boolean up, String txt, boolean active) {
        this(min, max, defaultPos, up, txt, active, false, true);
    }

    public CheckSliderTextContainer(int min, int max, int defaultPos, boolean up, String txt, boolean active, boolean border, boolean showCheck) {
        super(min, max, defaultPos, border);
        this.showCheck = showCheck;
        this.text = txt;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        if (!up) {
            super.add((Component)this.getPCheck(up), "West");
        } else {
            super.add((Component)this.getPCheck(up), "North");
        }
        if (showCheck) {
            this.check.addActionListener(this);
            this.check.setSelected(active);
        }
        this.setControlEnabled(active);
    }

    private JPanel getPCheck(boolean up) {
        if (this.pLabel == null) {
            this.pLabel = new JPanel();
            if (!up) {
                GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
                this.pLabel.setLayout(new GridBagLayout());
                if (this.showCheck) {
                    gridBagConstraints1.insets = new Insets(0, 10, 13, 0);
                    this.pLabel.add((Component)this.getCheck(), gridBagConstraints1);
                } else {
                    gridBagConstraints1.insets = new Insets(0, 0, 13, 0);
                    this.labelWithoutCheck = new JLabel(this.text);
                    this.pLabel.add((Component)this.labelWithoutCheck, gridBagConstraints1);
                }
            } else {
                FlowLayout fl = new FlowLayout();
                fl.setAlignment(0);
                this.pLabel.setLayout(fl);
                if (this.showCheck) {
                    this.pLabel.add((Component)this.getCheck(), null);
                } else {
                    this.labelWithoutCheck = new JLabel(this.text);
                    this.pLabel.add((Component)this.labelWithoutCheck, null);
                }
            }
        }
        return this.pLabel;
    }

    public JCheckBox getCheck() {
        if (this.check == null) {
            this.check = new JCheckBox(this.text);
        }
        return this.check;
    }

    @Override
    public void setControlEnabled(boolean active) {
        if (this.showCheck) {
            this.getCheck().setSelected(active);
        }
        if (this.labelWithoutCheck != null) {
            this.labelWithoutCheck.setEnabled(active);
        }
        super.setControlEnabled(active);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.check) {
            this.setControlEnabled(this.check.isSelected());
            this.callChangeValue(true);
        }
    }
}

