/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.colorbutton;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JComponent;
import org.gvsig.gui.beans.colorbutton.ColorButtonDialog;
import org.gvsig.gui.beans.colorbutton.ColorButtonEvent;
import org.gvsig.gui.beans.colorbutton.ColorButtonListener;
import org.gvsig.gui.beans.colorchooser.ColorChooserListener;

public class ColorButton
extends JComponent
implements MouseListener,
ColorChooserListener {
    private static final long serialVersionUID = 6003841064431749542L;
    private ArrayList<ColorButtonListener> actionCommandListeners = new ArrayList();
    private Color color = Color.black;
    private ColorButtonDialog colorButtonPanel = null;
    private Image bufferImage = null;
    private int width = 0;
    private int height = 0;
    private Graphics bufferGraphics = null;

    public ColorButton() {
        this.setPreferredSize(new Dimension(40, 22));
        this.setCursor(new Cursor(12));
        this.setColor(Color.black);
        this.addMouseListener(this);
    }

    public void setColor(Color value) {
        this.color = value;
        this.refreshImage();
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.colorButtonPanel = new ColorButtonDialog();
        Color oldColor = this.getColor();
        this.colorButtonPanel.setColor(oldColor);
        this.colorButtonPanel.addValueChangedListener(this);
        if (!this.colorButtonPanel.showDialog()) {
            this.setColor(oldColor);
            this.callValueChangedListeners();
        }
    }

    @Override
    public void actionValueChanged(EventObject e) {
        this.setColor(this.colorButtonPanel.getColor());
        this.callValueChangedListeners();
    }

    @Override
    public void actionValueDragged(EventObject e) {
        this.setColor(this.colorButtonPanel.getColor());
        this.callValueDraggedListeners();
    }

    private Graphics getBufferGraphics() {
        int width2 = this.getBounds().width;
        int height2 = this.getBounds().height;
        if (width2 <= 0) {
            width2 = 1;
        }
        if (height2 <= 0) {
            height2 = 1;
        }
        if (this.width != width2 || this.height != height2) {
            this.bufferImage = this.createImage(width2, height2);
            if (this.bufferImage == null) {
                return null;
            }
            this.bufferGraphics = this.bufferImage.getGraphics();
        }
        this.width = width2;
        this.height = height2;
        return this.bufferGraphics;
    }

    private void redrawBuffer() {
        if (this.getBufferGraphics() == null) {
            return;
        }
        Color newColor = this.color;
        if (this.isEnabled()) {
            Shape oldClip = this.getBufferGraphics().getClip();
            this.getBufferGraphics().setClip(1, 1, this.width - 2, this.height - 2);
            if (this.color == null || this.color.getAlpha() != 255) {
                int i = 0;
                while (i * 4 <= this.width) {
                    int j = 0;
                    while (j * 4 <= this.height) {
                        if ((i + j) % 2 == 0) {
                            this.getBufferGraphics().setColor(Color.white);
                        } else {
                            this.getBufferGraphics().setColor(new Color(204, 204, 204));
                        }
                        this.getBufferGraphics().fillRect(1 + i * 4, 1 + j * 4, 4, 4);
                        ++j;
                    }
                    ++i;
                }
            }
            this.getBufferGraphics().setClip(oldClip);
            newColor = this.color;
        } else {
            newColor = this.getBackground();
        }
        if (newColor != null) {
            this.getBufferGraphics().setColor(newColor);
            this.getBufferGraphics().fillRect(1, 1, this.width - 2, this.height - 2);
        }
        if (this.isEnabled()) {
            this.getBufferGraphics().setColor(Color.black);
        } else {
            this.getBufferGraphics().setColor(new Color(172, 168, 153));
        }
        this.getBufferGraphics().drawRect(0, 0, this.width - 1, this.height - 1);
    }

    private void refreshImage() {
        this.redrawBuffer();
        if (this.bufferImage != null) {
            this.getGraphics().drawImage(this.bufferImage, 0, 0, this);
        }
        super.paint(this.getGraphics());
    }

    @Override
    public void paint(Graphics g) {
        this.redrawBuffer();
        g.drawImage(this.bufferImage, 0, 0, this);
        super.paint(g);
    }

    public void addValueChangedListener(ColorButtonListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeValueChangedListener(ColorButtonListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callValueChangedListeners() {
        for (ColorButtonListener listener : this.actionCommandListeners) {
            listener.actionValueChanged(new ColorButtonEvent(this));
        }
    }

    private void callValueDraggedListeners() {
        for (ColorButtonListener listener : this.actionCommandListeners) {
            listener.actionValueDragged(new ColorButtonEvent(this));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

