/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JPanel;
import org.gvsig.gui.beans.checkslidertext.CheckColorSliderTextContainer;
import org.gvsig.gui.beans.colorchooser.ColorChooserListener;
import org.gvsig.gui.beans.doubleslider.DoubleSliderEvent;
import org.gvsig.gui.beans.doubleslider.DoubleSliderListener;

public class ColorChooser
extends JPanel
implements DoubleSliderListener {
    private static final long serialVersionUID = 2397304969793748653L;
    private ArrayList<ColorChooserListener> actionCommandListeners = new ArrayList();
    private CheckColorSliderTextContainer sliderRed = null;
    private CheckColorSliderTextContainer sliderGreen = null;
    private CheckColorSliderTextContainer sliderBlue = null;
    private CheckColorSliderTextContainer sliderAlpha = null;

    public ColorChooser() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.sliderRed = new CheckColorSliderTextContainer(0, 255, 0, "R", true);
        this.sliderGreen = new CheckColorSliderTextContainer(0, 255, 0, "G", true);
        this.sliderBlue = new CheckColorSliderTextContainer(0, 255, 0, "B", true);
        this.sliderAlpha = new CheckColorSliderTextContainer(0, 255, 255, "A", true);
        this.sliderRed.setCheckboxVisible(false);
        this.sliderGreen.setCheckboxVisible(false);
        this.sliderBlue.setCheckboxVisible(false);
        this.sliderAlpha.setCheckboxVisible(false);
        this.sliderRed.addValueChangedListener(this);
        this.sliderGreen.addValueChangedListener(this);
        this.sliderBlue.addValueChangedListener(this);
        this.sliderAlpha.addValueChangedListener(this);
        this.setColor(Color.black);
        this.updateColors();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.sliderRed, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.sliderGreen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.sliderBlue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.sliderAlpha, gridBagConstraints);
    }

    @Override
    public void actionValueChanged(DoubleSliderEvent e) {
        this.updateColors();
        this.callChangeValue();
    }

    private void updateColors() {
        this.sliderRed.setColor1(new Color(0, this.sliderGreen.getValue(), this.sliderBlue.getValue(), this.sliderAlpha.getValue()), false);
        this.sliderRed.setColor2(new Color(255, this.sliderGreen.getValue(), this.sliderBlue.getValue(), this.sliderAlpha.getValue()), true);
        this.sliderGreen.setColor1(new Color(this.sliderRed.getValue(), 0, this.sliderBlue.getValue(), this.sliderAlpha.getValue()), false);
        this.sliderGreen.setColor2(new Color(this.sliderRed.getValue(), 255, this.sliderBlue.getValue(), this.sliderAlpha.getValue()), true);
        this.sliderBlue.setColor1(new Color(this.sliderRed.getValue(), this.sliderGreen.getValue(), 0, this.sliderAlpha.getValue()), false);
        this.sliderBlue.setColor2(new Color(this.sliderRed.getValue(), this.sliderGreen.getValue(), 255, this.sliderAlpha.getValue()), true);
        this.sliderAlpha.setColor1(new Color(this.sliderRed.getValue(), this.sliderGreen.getValue(), this.sliderBlue.getValue(), 0), false);
        this.sliderAlpha.setColor2(new Color(this.sliderRed.getValue(), this.sliderGreen.getValue(), this.sliderBlue.getValue(), 255), true);
    }

    @Override
    public void actionValueDragged(DoubleSliderEvent e) {
        this.updateColors();
        this.callDraggedValue();
    }

    public Color getColor() {
        return new Color(this.sliderRed.getValue(), this.sliderGreen.getValue(), this.sliderBlue.getValue(), this.sliderAlpha.getValue());
    }

    public void setColor(Color value) {
        this.sliderRed.setValue(value.getRed());
        this.sliderGreen.setValue(value.getGreen());
        this.sliderBlue.setValue(value.getBlue());
        this.sliderAlpha.setValue(value.getAlpha());
        this.updateColors();
    }

    public void addValueChangedListener(ColorChooserListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.sliderRed.setEnabled(enabled);
        this.sliderGreen.setEnabled(enabled);
        this.sliderBlue.setEnabled(enabled);
        this.sliderAlpha.setEnabled(enabled);
    }

    public void removeValueChangedListener(ColorChooserListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    protected void callChangeValue() {
        for (ColorChooserListener listener : this.actionCommandListeners) {
            listener.actionValueChanged(new EventObject(this));
        }
    }

    protected void callDraggedValue() {
        for (ColorChooserListener listener : this.actionCommandListeners) {
            listener.actionValueDragged(new EventObject(this));
        }
    }
}

