/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing.cellrenderers;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.gvsig.gui.beans.swing.JNumberSpinner;

public class NumberTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -4551232953341602636L;
    private JNumberSpinner txt;
    private boolean isBordered;
    private MatteBorder selectedBorder;
    private MatteBorder unselectedBorder;
    private boolean acceptsDoubles;

    public NumberTableCellRenderer(boolean bordered, boolean acceptsDoubles) {
        this.isBordered = bordered;
        this.acceptsDoubles = acceptsDoubles;
        this.setOpaque(true);
    }

    public JNumberSpinner getIncrementalNumberField() {
        return this.txt;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        try {
            JPanel content = new JPanel(new FlowLayout(1, 0, 0));
            content.setBackground(table.getBackground());
            int decimals = 0;
            if (this.acceptsDoubles) {
                decimals = 3;
            }
            this.txt = new JNumberSpinner(0.0, 6, 0.0, 80.0, 1.0, decimals);
            this.txt.setBackground(table.getBackground());
            this.txt.setValue(value);
            content.add(this.txt);
            return content;
        }
        catch (ClassCastException ccEx) {
            throw new RuntimeException("Trying to use a numeric cell renderer with a non-numeric datatype");
        }
    }
}

