/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.swing.impl.report;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.json.JsonObject;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.LabelsCacheForFieldValues;
import org.gvsig.fmap.dal.swing.report.AbstractReportAction;
import org.gvsig.fmap.dal.swing.report.ReportAction;
import org.gvsig.fmap.dal.swing.report.ReportActionFactory;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.pdf.swing.api.PDFSwingLocator;
import org.gvsig.pdf.swing.api.PDFSwingManager;
import org.gvsig.pdf.swing.api.PDFViewer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.task.JTaskStatus;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTextReportAction
extends AbstractReportAction
implements ReportAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTextReportAction.class);
    public static String TAG_REPORT_ATTR_LABEL = "report.attr.label";
    private final JsonObject json;
    private String template;
    private FeatureSet set;
    private LabelsCacheForFieldValues labelsCacheForFieldValues;
    private final FeatureStore store;
    private final FeatureQuery query;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicTextReportAction(ReportActionFactory factory, FeatureStore store, FeatureQuery query, FeatureSet set, JsonObject json) {
        super(factory, null);
        this.json = json;
        this.setReportName(this.json.getString("name", store.getName()));
        this.setReportLabel(this.json.getString("label", this.getReportName()));
        this.template = null;
        String templateName = this.json.getString("templateName", "dynamictext");
        ResourcesStorage resources = store.getResourcesStorage();
        if (resources != null) {
            ResourcesStorage.Resource resource = resources.getResource(templateName);
            InputStream is = null;
            try {
                is = resource.asInputStream();
                this.template = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't load dynamictext/report form resource (" + resource.getURL() + ")", (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        this.set = set;
        this.store = store;
        this.query = query;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        JTaskStatus taskStatusPanel = ToolsSwingLocator.getTaskStatusSwingManager().createJTaskStatus();
        DynamicTextReportAction report = this;
        this.getStatus().setIndeterminate();
        taskStatusPanel.setShowRemoveTaskButton(false);
        taskStatusPanel.bind((TaskStatus)this.getStatus());
        ToolsSwingUtils.ensureRowsCols((JComponent)taskStatusPanel, (int)4, (int)100, (int)5, (int)200);
        windowManager.showWindow(taskStatusPanel.asJComponent(), "Creating report '" + this.getReportLabel() + "'...", WindowManager.MODE.TOOL);
        Thread task = new Thread(() -> {
            try {
                PDFManager pdfManager = PDFLocator.getPDFManager();
                MutableSymbolTable symbolTable = ExpressionUtils.createSymbolTable();
                symbolTable.setVar("$REPORT", (Object)report);
                String html = ExpressionUtils.evaluateDynamicText((SymbolTable)symbolTable, (String)report.template);
                if (report.getStatus().isCancellationRequested()) {
                    report.getStatus().cancel();
                    return;
                }
                report.getStatus().message("Creating pdf...");
                PDFDocument pdfdoc = pdfManager.createPDFDocument(html);
                if (pdfdoc == null) {
                    LOGGER.debug("Can't create pdf doc from html");
                    report.getStatus().message("Can't create pdf document");
                    report.getStatus().abort();
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    try {
                        PDFSwingManager pdfSwingManager = PDFSwingLocator.getPDFSwingManager();
                        report.getStatus().message("Loading viewer...");
                        PDFViewer viewer = pdfSwingManager.createPDFViewer();
                        viewer.put(pdfdoc);
                        viewer.setMode(0);
                        JComponent comp = viewer.asJComponent();
                        Dimension screensize = ToolsSwingLocator.getToolsSwingManager().getDesktopPanelSize();
                        ToolsSwingUtils.ensureHeightWitdh((JComponent)comp, (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)20)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
                        String title = ToolsSwingUtils.makeTitle((String)"Report", (String)report.getReportLabel(), null);
                        windowManager.showWindow(comp, title, WindowManager.MODE.WINDOW);
                        taskStatusPanel.setVisible(false);
                        report.getStatus().terminate();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't show dynamictext/report", (Throwable)ex);
                        report.getStatus().abort();
                    }
                });
            }
            catch (Exception ex) {
                LOGGER.warn("Can't show dynamictext/report", (Throwable)ex);
                report.getStatus().message("Errors creating  report.\n\n" + BaseException.getMessageStack((Throwable)ex, (int)0));
                report.getStatus().abort();
            }
        }, "Report_" + report.getReportName());
        task.start();
    }

    public FeatureSet rows() {
        if (this.set == null) {
            try {
                this.set = this.store.getFeatureSet(this.query);
            }
            catch (DataException ex) {
                throw new RuntimeException("Can't create dynamic-text report.", ex);
            }
        }
        return this.set;
    }

    public String getLabelForFieldValue(Feature feature, String fieldname) {
        return this.formatFieldValue(feature, fieldname);
    }

    public String formatFieldValue(Feature feature, String fieldname) {
        String v;
        if (StringUtils.isBlank((CharSequence)fieldname)) {
            LOGGER.warn("Illegal fieldname value (null)");
            return "NULL";
        }
        if (feature == null) {
            LOGGER.warn("Can't access attribute '" + fieldname + "', feature is null.");
            return "NULL";
        }
        try {
            if (this.labelsCacheForFieldValues == null) {
                this.labelsCacheForFieldValues = DALLocator.getDataManager().createLabelsCacheForFieldValues(args -> {
                    String fieldName = "unknown";
                    try {
                        FeatureType featureType = (FeatureType)args[0];
                        Feature feat = (Feature)args[1];
                        fieldName = (String)args[2];
                        FeatureAttributeDescriptor attr = featureType.getAttributeDescriptor(fieldName);
                        String labelFormula = attr.getTags().getString(TAG_REPORT_ATTR_LABEL, null);
                        return labelFormula;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't get formula for field '" + fieldName + "'.", (Throwable)ex);
                        return null;
                    }
                }, this.getStatus());
            }
            v = this.labelsCacheForFieldValues.getLabelForFieldValue(feature, fieldname);
        }
        catch (Exception ex) {
            v = feature.getLabelOfValue(fieldname);
        }
        try {
            v = StringEscapeUtils.escapeHtml4((String)v);
        }
        catch (Exception ex) {
            LOGGER.debug("Esto no deberia estar pasando!!!", (Throwable)ex);
        }
        return v;
    }

    public static void selfRegister() {
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        dynObjectManager.registerTag(TAG_REPORT_ATTR_LABEL, "Expression to use in reports for fields domain values (@label).");
    }
}

