/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.shape.service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.gvsig.export.ExportException;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.shape.service.ExportShapeParameters;
import org.gvsig.export.spi.AbstractExportService;
import org.gvsig.export.spi.ExportService;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.spi.ExportServiceManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.util.HasAFile;

public class ExportShapeService
extends AbstractExportService
implements ExportService {
    public static final int MAX_FIELD_NAME_LENGTH = 10;
    private final List<OpenDataStoreParameters> targetOpenStoreParameters = new ArrayList<OpenDataStoreParameters>();

    public ExportShapeService(ExportServiceFactory factory, ExportShapeParameters parameters) {
        super(factory, (ExportParameters)parameters);
    }

    public ExportShapeParameters getParameters() {
        return (ExportShapeParameters)super.getParameters();
    }

    protected DataServerExplorer createServerExplorer() throws ExportException {
        FilesystemServerExplorerParameters explorerParams;
        DataManager dataManager = DALLocator.getDataManager();
        try {
            explorerParams = (FilesystemServerExplorerParameters)dataManager.createServerExplorerParameters("FilesystemExplorer");
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
        File parametersFile = this.getParameters().getEvaluatedFile();
        explorerParams.setRoot(parametersFile.getParent());
        try {
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)dataManager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)explorerParams);
            return explorer;
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
    }

    protected NewDataStoreParameters createTargetNewStoreParameters() throws ExportException {
        try {
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)this.createServerExplorer();
            NewFeatureStoreParameters newStoreParameters = (NewFeatureStoreParameters)explorer.getAddParameters("Shape");
            ((HasAFile)newStoreParameters).setFile(this.getParameters().getEvaluatedFile());
            newStoreParameters.setDynValue("Encoding", (Object)this.getParameters().getEncoding());
            newStoreParameters.setDynValue("CRS", (Object)this.getParameters().getTargetProjection());
            FeatureType ft = this.getParameters().getExportAttributes() != null ? this.getParameters().getExportAttributes().getTargetFeatureType() : this.getParameters().getSourceFeatureType();
            newStoreParameters.setDefaultFeatureType((FeatureType)ft.getEditable());
            return newStoreParameters;
        }
        catch (DataException ex) {
            throw new ExportException((Throwable)ex);
        }
    }

    public List<OpenDataStoreParameters> getTargetOpenStoreParameters() throws ExportException {
        return this.targetOpenStoreParameters;
    }

    public OpenDataStoreParameters createTargetOpenStoreParameters() throws ExportException {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            OpenFeatureStoreParameters openStoreParameters = (OpenFeatureStoreParameters)dataManager.createStoreParameters("Shape");
            ((HasAFile)openStoreParameters).setFile(this.getParameters().getEvaluatedFile());
            openStoreParameters.setDynValue("Encoding", (Object)this.getParameters().getEncoding());
            openStoreParameters.setDynValue("CRS", (Object)this.getParameters().getTargetProjection());
            return openStoreParameters;
        }
        catch (DataException ex) {
            throw new ExportException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(FeatureSet featureSet) throws ExportException {
        File parametersFile = ExpressionUtils.evaluateFilename((File)this.getParameters().getFile());
        String pathName = FilenameUtils.removeExtension((String)parametersFile.getAbsolutePath());
        int geometryType = this.getParameters().getTargetGeometryTypeAsInt();
        if (geometryType == 0) {
            try {
                String fullPathName = pathName + "_surface" + ".shp";
                this.getParameters().setFile(new File(fullPathName));
                this.getTaskStatus().setTitle("Exporting surfaces");
                this.export(featureSet, 22, true);
                fullPathName = pathName + "_curve" + ".shp";
                this.getParameters().setFile(new File(fullPathName));
                this.getTaskStatus().setTitle("Exporting curves");
                this.export(featureSet, 21, true);
                fullPathName = pathName + "_point" + ".shp";
                this.getParameters().setFile(new File(fullPathName));
                this.getTaskStatus().setTitle("Exporting points");
                this.export(featureSet, 7, true);
            }
            finally {
                this.getParameters().setFile(parametersFile);
            }
        } else {
            this.export(featureSet, geometryType, false);
        }
        this.getTaskStatus().terminate();
        this.getTaskStatus().remove();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void export(FeatureSet featureSet, int geometryType, boolean checkType) throws ExportException {
        DataServerExplorer explorer = this.createServerExplorer();
        NewFeatureStoreParameters params = (NewFeatureStoreParameters)this.createTargetNewStoreParameters();
        String providerName = params.getDataStoreName();
        String explorerName = explorer.getProviderName();
        boolean there_was_error = false;
        String filenameForLog = "unknown";
        DisposableIterator it = null;
        try {
            if (params instanceof HasAFile) {
                filenameForLog = ((HasAFile)params).getFile().getAbsolutePath();
            }
            LOG.info("Start Export to shape file '" + filenameForLog + "'");
            EditableFeatureType type = params.getDefaultFeatureType();
            String geomFieldName = this.getParameters().getSourceGeometryFieldName();
            FeatureAttributeDescriptor geomFieldDescSource = type.getDefaultGeometryAttribute();
            if (geomFieldDescSource != null) {
                type.remove(geomFieldDescSource.getName());
            }
            EditableFeatureAttributeDescriptor geomFieldDescTarget = type.add("GEOMETRY", 66);
            geomFieldDescTarget.setDefaultValue(null);
            int gsubtype = this.getParameters().getTargetGeometrySubtype();
            GeometryType gty = null;
            try {
                GeometryManager geoManager = GeometryLocator.getGeometryManager();
                gty = geoManager.getGeometryType(geometryType, gsubtype);
            }
            catch (Exception e) {
                throw new ExportException((Throwable)e);
            }
            geomFieldDescTarget.setGeometryType(gty);
            String newGeometryFieldName = this.getParameters().getExportAttributes().getTargetName("GEOMETRY") == null ? "GEOMETRY" : this.getParameters().getExportAttributes().getTargetName("GEOMETRY");
            geomFieldDescTarget.setName(newGeometryFieldName);
            type.setDefaultGeometryAttributeName(geomFieldDescTarget.getName());
            params.setDefaultFeatureType(type.getNotEditableCopy());
            params.setDynValue("geometryType", null);
            DataManager manager = DALLocator.getDataManager();
            manager.newStore(explorerName, providerName, (NewDataStoreParameters)params, true);
            FeatureStore target = (FeatureStore)manager.openStore(providerName, (DataStoreParameters)params);
            FeatureType targetType = target.getDefaultFeatureType();
            this.getTaskStatus().setRangeOfValues(0L, featureSet.getSize());
            target.edit(2);
            it = featureSet.fastIterator();
            int featureCount = 0;
            EditableFeature edit_feat = null;
            ICoordTrans coord_trans = this.getParameters().getTransformationToUse();
            Coercion toGeometry = ToolsLocator.getDataTypesManager().getCoercion(66);
            ExportServiceManager serviceManager = ExportLocator.getServiceManager();
            FeatureType theTargetFeatureType = target.getDefaultFeatureType();
            int targetGeometryIndex = theTargetFeatureType.getDefaultGeometryAttributeIndex();
            LOG.info("Create shape file.");
            while (true) {
                block26: {
                    List<Object> extracted;
                    Geometry gitem;
                    Feature feature;
                    block27: {
                        block24: {
                            block25: {
                                if (!it.hasNext()) break block24;
                                feature = (Feature)it.next();
                                if (geomFieldName != null) break block25;
                                edit_feat = target.createNewFeature(true);
                                there_was_error |= this.setNonNulls(this.getParameters().getSourceFeatureType(), targetType, feature, edit_feat);
                                edit_feat.setDefaultGeometry(null);
                                target.insert(edit_feat);
                                break block26;
                            }
                            Geometry x = feature.getGeometry(geomFieldName);
                            try {
                                gitem = (Geometry)toGeometry.coerce((Object)x);
                            }
                            catch (CoercionException ex) {
                                gitem = null;
                            }
                            if (checkType) {
                                extracted = this.getGeometriesFrom(gitem, geometryType);
                                if (extracted.isEmpty()) continue;
                                if (geometryType != 1) {
                                    try {
                                        gitem = this.union(extracted);
                                        extracted = new ArrayList();
                                        extracted.add(gitem);
                                    }
                                    catch (Exception ex) {
                                        there_was_error = true;
                                        LOG.info("Error in union.", (Throwable)ex);
                                    }
                                }
                                break block27;
                            } else {
                                extracted = new ArrayList();
                                extracted.add(gitem);
                            }
                            break block27;
                        }
                        target.finishEditing();
                        target.dispose();
                        this.targetOpenStoreParameters.add(this.createTargetOpenStoreParameters());
                        LOG.info("End Export to shape file '" + filenameForLog + "'");
                        DisposeUtils.dispose((Disposable)it);
                        if (!there_was_error) {
                            return;
                        }
                        Exception cause = new Exception("_Issues_with_attributes_or_geometries");
                        throw new ExportException((Throwable)cause);
                    }
                    block17: for (int i = 0; i < extracted.size(); ++i) {
                        gitem = (Geometry)extracted.get(i);
                        gitem = gsubtype == 0 ? this.force2D(gitem, geometryType) : this.force3D(gitem, geometryType);
                        edit_feat = target.createNewFeature(true);
                        there_was_error |= this.setNonNulls(this.getParameters().getSourceFeatureType(), targetType, feature, edit_feat);
                        edit_feat.setDefaultGeometry(gitem);
                        if (coord_trans == null || gitem == null) continue;
                        Geometry geometry = edit_feat.getDefaultGeometry();
                        ExportServiceManager.FixGeometryStatus check = serviceManager.fixGeometry((ExportParametersGeometry)this.getParameters(), coord_trans, geometry);
                        switch (check.getState()) {
                            case 0: {
                                edit_feat.setDefaultGeometry(check.getGeometry());
                                continue block17;
                            }
                            case 1: {
                                continue block17;
                            }
                            case 2: {
                                throw new AbstractExportService.InvalidGeometryException((Feature)edit_feat, check.getMessage());
                            }
                        }
                    }
                    target.insert(edit_feat);
                }
                this.getTaskStatus().setCurValue((long)(++featureCount));
                if (this.getTaskStatus().isCancellationRequested()) break;
            }
            DisposeUtils.dispose((Disposable)it);
            return;
        }
        catch (Exception e) {
            try {
                LOG.warn("Can't export shape file '" + filenameForLog + "'", (Throwable)e);
                throw new ExportException((Throwable)e);
            }
            catch (Throwable throwable) {
                DisposeUtils.dispose(it);
                throw throwable;
            }
        }
    }

    private void fixNames(EditableFeatureType eft) {
        FeatureAttributeDescriptor[] atts = eft.getAttributeDescriptors();
        String defaultGeometryField = eft.getDefaultGeometryAttributeName();
        for (FeatureAttributeDescriptor att : atts) {
            String new_name = this.getParameters().getExportAttributes().getTargetName(att.getName());
            if (new_name == null) continue;
            EditableFeatureAttributeDescriptor efad = eft.getEditableAttributeDescriptor(att.getName());
            efad.setName(new_name);
            efad.setType(att.getDataType());
            efad.setSize(att.getSize());
            efad.setPrecision(att.getPrecision());
            efad.setScale(att.getScale());
            if (att.getDataType().getType() != 66) continue;
            efad.setGeometryType(att.getGeomType());
            if (!StringUtils.equals((CharSequence)defaultGeometryField, (CharSequence)att.getName())) continue;
            eft.setDefaultGeometryAttributeName(new_name);
        }
    }

    private Geometry force2D(Geometry ge, int gt) throws CreateGeometryException {
        if (ge == null) {
            return null;
        }
        if (ge.getGeometryType().getSubType() == 0) {
            return ge;
        }
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        switch (gt) {
            case 1: {
                Point p = (Point)ge;
                Point point = geoManager.createPoint(p.getX(), p.getY(), 0);
                return point;
            }
            case 2: {
                return geoManager.createCurve(ge.getGeneralPath(), 0);
            }
            case 3: {
                return geoManager.createSurface(ge.getGeneralPath(), 0);
            }
        }
        return ge;
    }

    private Geometry force3D(Geometry ge, int gt) throws CreateGeometryException {
        if (ge == null) {
            return null;
        }
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        switch (gt) {
            case 1: {
                Point p = (Point)ge;
                Point point = geoManager.createPoint(p.getX(), p.getY(), 1);
                try {
                    point.setCoordinateAt(2, p.getCoordinateAt(2));
                }
                catch (Exception e) {
                    point.setCoordinateAt(2, 0.0);
                }
                return point;
            }
            case 2: 
            case 18: {
                Line line = geoManager.createLine(1);
                for (int i = 0; i < ((OrientablePrimitive)ge).getNumVertices(); ++i) {
                    Point vertex = ((OrientablePrimitive)ge).getVertex(i);
                    Point point = geoManager.createPoint(vertex.getX(), vertex.getY(), 1);
                    try {
                        point.setCoordinateAt(2, vertex.getCoordinateAt(2));
                    }
                    catch (Exception e) {
                        point.setCoordinateAt(2, 0.0);
                    }
                    line.addVertex(point);
                }
                return line;
            }
            case 3: 
            case 19: {
                Polygon polygon = geoManager.createPolygon(1);
                for (int i = 0; i < ((OrientablePrimitive)ge).getNumVertices(); ++i) {
                    Point vertex = ((OrientablePrimitive)ge).getVertex(i);
                    Point point = geoManager.createPoint(vertex.getX(), vertex.getY(), 1);
                    try {
                        point.setCoordinateAt(2, vertex.getCoordinateAt(2));
                    }
                    catch (Exception e) {
                        point.setCoordinateAt(2, 0.0);
                    }
                    polygon.addVertex(point);
                }
                return polygon;
            }
        }
        return ge;
    }

    private boolean setNonNulls(FeatureType src_ft, FeatureType target_ft, Feature feat, EditableFeature edit_f) {
        FeatureAttributeDescriptor[] atts;
        boolean error = false;
        for (FeatureAttributeDescriptor att : atts = src_ft.getAttributeDescriptors()) {
            if (att.getType() == 66 || att.isComputed()) continue;
            try {
                Object val;
                String orig_name = att.getName();
                String dbf_name = this.getParameters().getExportAttributes().getTargetName(orig_name);
                if (dbf_name == null) {
                    dbf_name = orig_name;
                }
                if ((val = feat.get(orig_name)) == null || target_ft.getAttributeDescriptor(dbf_name) == null) continue;
                edit_f.set(dbf_name, val);
            }
            catch (Exception ex) {
                LOG.info("Error while getting/setting value", (Throwable)ex);
                error = true;
            }
        }
        return error;
    }

    private Geometry union(List<Geometry> geoms) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (geoms == null || geoms.isEmpty()) {
            return null;
        }
        if (geoms.size() == 1) {
            return geoms.get(0);
        }
        Geometry resp = geoms.get(0);
        for (int i = 1; i < geoms.size(); ++i) {
            resp = resp.union(geoms.get(i));
        }
        return resp;
    }

    private List<Geometry> getGeometriesFrom(Geometry in_geom, int type) {
        ArrayList<Geometry> resp = new ArrayList<Geometry>();
        if (in_geom instanceof Aggregate) {
            Aggregate agg = (Aggregate)in_geom;
            for (int i = 0; i < agg.getPrimitivesNumber(); ++i) {
                Primitive item = agg.getPrimitiveAt(i);
                List<Geometry> add_parts = this.getGeometriesFrom((Geometry)item, type);
                resp.addAll(add_parts);
            }
            return resp;
        }
        if (GeometryUtils.isSubtype((int)1, (int)type)) {
            if (in_geom instanceof Point) {
                resp.add(in_geom);
            }
        } else if (GeometryUtils.isSubtype((int)7, (int)type)) {
            if (in_geom instanceof Point) {
                resp.add(in_geom);
            }
        } else if (GeometryUtils.isSubtype((int)2, (int)type)) {
            if (in_geom instanceof Curve) {
                resp.add(in_geom);
            }
        } else if (GeometryUtils.isSubtype((int)8, (int)type)) {
            if (in_geom instanceof Curve) {
                resp.add(in_geom);
            }
        } else if (GeometryUtils.isSubtype((int)3, (int)type)) {
            if (in_geom instanceof Surface) {
                resp.add(in_geom);
            }
        } else if (GeometryUtils.isSubtype((int)9, (int)type) && in_geom instanceof Surface) {
            resp.add(in_geom);
        }
        return resp;
    }
}

