/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.explode;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class ExplodeEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selectionParameter;
    private final FeatureStore featureStore;
    private FeatureSelection value;

    public ExplodeEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
    }

    public EditingServiceParameter next() {
        if (this.value == null) {
            return this.selectionParameter;
        }
        return null;
    }

    public boolean mustRestartAtFinish() {
        return false;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        this.value = null;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selectionParameter);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object object) throws InvalidEntryException {
        if (parameter == this.selectionParameter && object instanceof FeatureSelection) {
            FeatureSelection selection = (FeatureSelection)object;
            try {
                selection.accept(obj -> {
                    MultiPrimitive multiPrimitive;
                    Feature feature = (Feature)obj;
                    Geometry defaultGeometry = feature.getDefaultGeometry();
                    if (defaultGeometry instanceof MultiPrimitive && (multiPrimitive = (MultiPrimitive)defaultGeometry).getPrimitivesNumber() > 1) {
                        this.value = selection;
                        DisposeUtils.bind((Disposable)this.value);
                        return;
                    }
                    throw new InvalidEntryException(null);
                });
            }
            catch (BaseException e) {
                throw new InvalidEntryException((Throwable)e);
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        if (this.value != null) {
            try {
                EditingProviderServices editingProviderServices = this.getProviderServices();
                this.value.accept(obj -> {
                    Feature feature = (Feature)obj;
                    GeometryManager geometryManager = GeometryLocator.getGeometryManager();
                    MultiPrimitive defaultGeometry = (MultiPrimitive)feature.getDefaultGeometry();
                    GeometryType geomType = defaultGeometry.getGeometryType();
                    for (int i = 0; i < defaultGeometry.getPrimitivesNumber(); ++i) {
                        Primitive primitive = defaultGeometry.getPrimitiveAt(i);
                        int subtype = editingProviderServices.getSubType(this.featureStore);
                        MultiPoint geometry = null;
                        if (geomType.isTypeOf(7)) {
                            MultiPoint multiPoint = geometryManager.createMultiPoint(subtype);
                            multiPoint.addPoint((Point)primitive);
                            geometry = multiPoint;
                        } else if (geomType.isTypeOf(8)) {
                            MultiCurve multiCurve = geometryManager.createMultiCurve(subtype);
                            multiCurve.addCurve((Curve)primitive);
                            geometry = multiCurve;
                        } else if (geomType.isTypeOf(9)) {
                            MultiSurface multiSurface = geometryManager.createMultiSurface(subtype);
                            multiSurface.addSurface((Surface)primitive);
                            geometry = multiSurface;
                        }
                        if (geometry == null) continue;
                        EditableFeature newFeature = editingProviderServices.getFeatureCopyWithoutUniqueIndex(this.featureStore, feature);
                        newFeature.setDefaultGeometry((Geometry)geometry);
                        editingProviderServices.insertFeatureIntoFeatureStore((Feature)newFeature, this.featureStore);
                    }
                    editingProviderServices.deleteFeatureFromFeatureStore(feature, this.featureStore);
                });
                this.featureStore.getFeatureSelection().deselectAll();
                DisposeUtils.disposeQuietly((Disposable)this.value);
                this.value = null;
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    public void start() throws StartServiceException, InvalidEntryException {
        DisposeUtils.disposeQuietly((Disposable)this.value);
        this.value = null;
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            try {
                this.setValue(selected);
            }
            catch (InvalidEntryException e) {
                throw new InvalidEntryException((Throwable)e);
            }
        }
    }

    public String getName() {
        return "modify-explode-geometry";
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.selectionParameter) {
            return this.value;
        }
        return null;
    }
}

