/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.urbanhorizontalsignage.lib.impl;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureRule;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.ValidateFeaturesException;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.UrbanHorizontalSignageLocator;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.UrbanHorizontalSignageManager;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageConfig;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageData;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageLegend;
import org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend.DefaultUrbanHorizontalSignageData;
import org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend.DefaultUrbanHorizontalSignageLegend;
import org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend.SplittedLine;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.HasAFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUrbanHorizontalSignageManager
implements UrbanHorizontalSignageManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUrbanHorizontalSignageManager.class);

    public UrbanHorizontalSignageLegend createUrbanHorizontalSignageLegend() {
        return new DefaultUrbanHorizontalSignageLegend();
    }

    public Class<? extends UrbanHorizontalSignageLegend> getUrbanHorizontalSignageLegendClass() {
        return DefaultUrbanHorizontalSignageLegend.class;
    }

    public UrbanHorizontalSignageData createUrbanHorizontalSignageData() {
        return new DefaultUrbanHorizontalSignageData();
    }

    public void calculateGeometries(Geometry originalGeometry, UrbanHorizontalSignageData data) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            MultiPolygon segments = geomManager.createMultiPolygon(originalGeometry.getGeometryType().getSubType());
            MultiPolygon holes = geomManager.createMultiPolygon(originalGeometry.getGeometryType().getSubType());
            MultiLine lineSegments = geomManager.createMultiLine(originalGeometry.getGeometryType().getSubType());
            MultiLine lineHoles = geomManager.createMultiLine(originalGeometry.getGeometryType().getSubType());
            MultiLine lines = originalGeometry.toLines();
            double offsetValueInMeters = Math.abs(data.getGapWidth() / 2.0 + data.getWidth() / 2.0);
            double bufferValueInMeters = Math.abs(data.getWidth() / 2.0);
            block9: for (Geometry geom : lines) {
                Line line = (Line)geom;
                switch (data.getContinuity()) {
                    default: {
                        Geometry buffer = line.buffer(bufferValueInMeters, data.isRoundVertex() ? 1 : 2, true);
                        if (buffer == null) continue block9;
                        segments.addPrimitives(buffer);
                        lineSegments.addPrimitives((Geometry)line);
                        break;
                    }
                    case 2: {
                        Geometry buffer;
                        SplittedLine splittedLine = this.splitLine(line, data.getSegmentsLength(), data.getHolesLength());
                        List<Line> splittedSegments = splittedLine.getSegments();
                        List<Line> splittedHoles = splittedLine.getHoles();
                        for (Line segment : splittedSegments) {
                            buffer = segment.buffer(bufferValueInMeters, data.isRoundVertex() ? 1 : 2, true);
                            if (buffer == null) continue;
                            segments.addPrimitives(buffer);
                            lineSegments.addPrimitives((Geometry)segment);
                        }
                        for (Line hole : splittedHoles) {
                            buffer = hole.buffer(bufferValueInMeters, data.isRoundVertex() ? 1 : 2, true);
                            if (buffer == null) continue;
                            holes.addPrimitives(buffer);
                            lineHoles.addPrimitives((Geometry)hole);
                        }
                        continue block9;
                    }
                    case 5: {
                        this.addOffsetedAndBufferedSegment(segments, lineSegments, line, offsetValueInMeters, bufferValueInMeters, data.isRoundVertex());
                        this.addOffsetedAndBufferedSegment(segments, lineSegments, line, -offsetValueInMeters, bufferValueInMeters, data.isRoundVertex());
                        break;
                    }
                    case 6: {
                        this.addOffsetedAndBufferedSegment(segments, lineSegments, line, offsetValueInMeters, bufferValueInMeters, data.isRoundVertex());
                        SplittedLine splittedLine = this.splitLine(line, data.getSegmentsLength(), data.getHolesLength());
                        List<Line> splittedSegments = splittedLine.getSegments();
                        List<Line> splittedHoles = splittedLine.getHoles();
                        for (Line segment : splittedSegments) {
                            this.addOffsetedAndBufferedSegment(segments, lineSegments, segment, -offsetValueInMeters, bufferValueInMeters, true);
                        }
                        for (Line hole : splittedHoles) {
                            this.addOffsetedAndBufferedSegment(holes, lineHoles, hole, -offsetValueInMeters, bufferValueInMeters, true);
                        }
                        continue block9;
                    }
                    case 9: {
                        SplittedLine splittedLine = this.splitLine(line, data.getSegmentsLength(), data.getHolesLength());
                        List<Line> splittedSegments = splittedLine.getSegments();
                        List<Line> splittedHoles = splittedLine.getHoles();
                        for (Line segment : splittedSegments) {
                            this.addOffsetedAndBufferedSegment(segments, lineSegments, segment, offsetValueInMeters, bufferValueInMeters, true);
                        }
                        for (Line hole : splittedHoles) {
                            this.addOffsetedAndBufferedSegment(holes, lineHoles, hole, offsetValueInMeters, bufferValueInMeters, true);
                        }
                        this.addOffsetedAndBufferedSegment(segments, lineSegments, line, -offsetValueInMeters, bufferValueInMeters, data.isRoundVertex());
                        break;
                    }
                    case 10: {
                        SplittedLine splittedLine = this.splitLine(line, data.getSegmentsLength(), data.getHolesLength());
                        List<Line> splittedSegments = splittedLine.getSegments();
                        List<Line> splittedHoles = splittedLine.getHoles();
                        for (Line segment : splittedSegments) {
                            this.addOffsetedAndBufferedSegment(segments, lineSegments, segment, offsetValueInMeters, bufferValueInMeters, true);
                        }
                        for (Line hole : splittedHoles) {
                            this.addOffsetedAndBufferedSegment(holes, lineHoles, hole, offsetValueInMeters, bufferValueInMeters, true);
                        }
                        for (Line segment : splittedSegments) {
                            this.addOffsetedAndBufferedSegment(segments, lineSegments, segment, -offsetValueInMeters, bufferValueInMeters, true);
                        }
                        for (Line hole : splittedHoles) {
                            this.addOffsetedAndBufferedSegment(holes, lineHoles, hole, -offsetValueInMeters, bufferValueInMeters, true);
                        }
                        continue block9;
                    }
                }
            }
            data.setSegmentsGeometry(segments);
            data.setHolesGeometry(holes);
            data.setLineSegmentsGeometry(lineSegments);
            data.setLineHolesGeometry(lineHoles);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't calculate geometries.", (Throwable)ex);
        }
    }

    protected void addOffsetedAndBufferedSegment(MultiPolygon segments, MultiLine lineSegments, Line segment, double offsetValueInMeters, double bufferValueInMeters, boolean roundVertex) throws GeometryOperationException, GeometryOperationNotSupportedException {
        Geometry segmentOffset;
        int joinStyle;
        int n = joinStyle = roundVertex ? 1 : 2;
        if (segment.isClosed() && segment.getNumVertices() > 2 && segment.isCCW()) {
            Line cloned = segment.cloneGeometry();
            cloned.flip();
            segmentOffset = cloned.offset(joinStyle, -offsetValueInMeters);
        } else {
            segmentOffset = segment.cloneGeometry().offset(joinStyle, offsetValueInMeters);
        }
        if (segmentOffset == null) {
            return;
        }
        Geometry buffer = segmentOffset.buffer(bufferValueInMeters, joinStyle, true);
        if (buffer != null) {
            segments.addPrimitives(buffer);
            lineSegments.addPrimitives(segmentOffset);
        }
    }

    SplittedLine splitLine(Line line, double segmentLength, double holesLength) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException, CloneNotSupportedException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        SplittedLine res = new SplittedLine();
        Point previousPoint = null;
        double previousLength = 0.0;
        Line currentSegment = geomManager.createLine(line.getGeometryType().getSubType());
        boolean isHole = false;
        boolean advanceToNext = true;
        Point currentPoint = null;
        Iterator it = line.iterator();
        while (it.hasNext() || !advanceToNext) {
            Point point;
            if (advanceToNext) {
                currentPoint = (Point)it.next();
            }
            if (previousPoint == null) {
                previousPoint = currentPoint.clone();
                currentSegment.addVertex(previousPoint);
                advanceToNext = true;
                continue;
            }
            double distance = previousPoint.distance((Geometry)currentPoint);
            if (!isHole) {
                if (previousLength + distance < segmentLength) {
                    previousLength += distance;
                    if (distance > 0.0) {
                        currentSegment.addVertex(currentPoint);
                    }
                    previousPoint = currentPoint.cloneGeometry();
                    advanceToNext = true;
                    continue;
                }
                point = this.calculateIntermediatePoint(previousPoint, currentPoint, (segmentLength - previousLength) / distance);
                currentSegment.addVertex(point);
                res.addSegment(currentSegment.cloneGeometry());
                currentSegment = geomManager.createLine(line.getGeometryType().getSubType());
                currentSegment.addVertex(point);
                isHole = !isHole;
                previousPoint = point.clone();
                previousLength = 0.0;
                advanceToNext = false;
                continue;
            }
            if (previousLength + distance < holesLength) {
                previousLength += distance;
                if (distance > 0.0) {
                    currentSegment.addVertex(currentPoint);
                }
                previousPoint = currentPoint.cloneGeometry();
                advanceToNext = true;
                continue;
            }
            point = this.calculateIntermediatePoint(previousPoint, currentPoint, (holesLength - previousLength) / distance);
            currentSegment.addVertex(point);
            res.addHole(currentSegment.cloneGeometry());
            currentSegment = geomManager.createLine(line.getGeometryType().getSubType());
            currentSegment.addVertex(point);
            isHole = !isHole;
            previousPoint = point.clone();
            previousLength = 0.0;
            advanceToNext = false;
        }
        if (currentSegment.getNumVertices() > 1) {
            if (isHole) {
                res.addHole(currentSegment.cloneGeometry());
            } else {
                res.addSegment(currentSegment.cloneGeometry());
            }
        }
        return res;
    }

    @Deprecated
    Point calculateIntermediatePoint(Point p1, Point p2, double lambda) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        GeometryType geomType = p1.getGeometryType();
        int subtype = geomType.getSubType();
        int dimension = geomType.getDimension();
        double[] coords = new double[dimension];
        Point p = geomManager.createPoint(0.0, 0.0, subtype);
        double distance = p1.distance((Geometry)p2);
        for (int d = 0; d < dimension; ++d) {
            p.setCoordinateAt(d, p1.getCoordinateAt(d) + (p2.getCoordinateAt(d) - p1.getCoordinateAt(d)) * lambda);
        }
        return p;
    }

    public FeatureStore createTemporaryPolygonsFromLines(UrbanHorizontalSignageConfig config, FeatureSet lines, boolean useValidationRules, SimpleTaskStatus status) {
        UrbanHorizontalSignageManager uhsManager = UrbanHorizontalSignageLocator.getUrbanHorizontalSignageManager();
        EditableFeatureType targetFeatureType = this.createTargetFeatureType(lines.getFeatureStore());
        FeatureStore targetStore = this.createTemporalStore(targetFeatureType);
        try {
            targetStore.edit(2);
            for (Feature feature : lines) {
                Geometry originalGeometry = feature.getDefaultGeometry();
                UrbanHorizontalSignageData data = config.getValues(feature);
                uhsManager.calculateGeometries(originalGeometry, data);
                MultiPolygon multiGeom = data.getSegmentsGeometry();
                MultiLine multiLine = data.getLineSegmentsGeometry();
                this.insertPolygonsOfLine(multiGeom, multiLine, targetStore, feature, config, config.getSegmentsColorFieldName(), useValidationRules);
                switch (data.getContinuity()) {
                    case 2: 
                    case 6: 
                    case 9: 
                    case 10: {
                        if (!data.isPaintHoles()) break;
                        multiGeom = data.getHolesGeometry();
                        multiLine = data.getLineHolesGeometry();
                        this.insertPolygonsOfLine(multiGeom, multiLine, targetStore, feature, config, config.getHolesColorFieldName(), useValidationRules);
                    }
                }
            }
            targetStore.finishEditing();
            return targetStore;
        }
        catch (Exception e) {
            LOGGER.debug("Can't create temporary polygons store.", (Throwable)e);
            return null;
        }
    }

    private void insertPolygonsOfLine(MultiPolygon multiGeom, MultiLine multiLine, FeatureStore targetStore, Feature feature, UrbanHorizontalSignageConfig config, String colorFieldName, boolean useValidationRules) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException {
        if (multiGeom != null && multiGeom.getPrimitivesNumber() > 0) {
            FeatureType featureType = targetStore.getDefaultFeatureTypeQuietly();
            for (int i = 0; i < multiGeom.getPrimitivesNumber(); ++i) {
                Polygon polygon = (Polygon)multiGeom.getPrimitiveAt(i);
                Line line = (Line)multiLine.getPrimitiveAt(i);
                EditableFeature targetFeature = targetStore.createNewFeature();
                targetFeature.copyFrom(feature, t -> !t.isPrimaryKey() && (!t.isIndexed() || t.allowIndexDuplicateds()) && t.getType() != 66);
                if (StringUtils.isNotBlank((CharSequence)config.getTargetColorFieldName())) {
                    targetFeature.set(config.getTargetColorFieldName(), feature.get(colorFieldName));
                }
                if (StringUtils.isNotBlank((CharSequence)config.getTargetLenghtFieldName())) {
                    targetFeature.set(config.getTargetLenghtFieldName(), (Object)line.perimeter());
                }
                if (StringUtils.isNotBlank((CharSequence)config.getTargetAreaFieldName())) {
                    targetFeature.set(config.getTargetAreaFieldName(), (Object)polygon.area());
                }
                targetFeature.setDefaultGeometry((Geometry)polygon);
                if (useValidationRules) {
                    this.validateFeature(featureType, (Feature)targetFeature);
                }
                targetStore.insert(targetFeature);
            }
        }
    }

    private void validateFeature(FeatureType featureType, Feature feature) {
        try {
            for (FeatureRule rule : featureType.getRules()) {
                FeatureReference ref;
                if (rule == null || !rule.checkWhen(4)) continue;
                try {
                    rule.validate((EditableFeature)feature, feature.getStore());
                }
                catch (ValidateFeaturesException ex) {
                    ref = feature.getReference();
                    throw new RuntimeException("Can't validate rule '" + rule.getName() + "' on feature '" + Objects.toString(ref) + "'.", ex);
                }
                catch (Exception ex) {
                    ref = feature.getReference();
                    LOGGER.warn("Can't run validate rule '" + rule.getName() + "' on feature '" + Objects.toString(ref) + "'.", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            FeatureReference ref = feature.getReference();
            LOGGER.warn("Can't run validate feature '" + Objects.toString(ref) + "'.");
        }
    }

    private EditableFeatureType createTargetFeatureType(FeatureStore store) {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType featureType = dataManager.createFeatureType();
        featureType.addAll(store.getDefaultFeatureTypeQuietly());
        for (FeatureAttributeDescriptor attr : featureType) {
            EditableFeatureAttributeDescriptor eattr = (EditableFeatureAttributeDescriptor)attr;
            eattr.setIsPrimaryKey(false);
            eattr.setIsIndexed(false);
            eattr.setAllowNull(true);
        }
        EditableFeatureAttributeDescriptor attr = (EditableFeatureAttributeDescriptor)featureType.getDefaultGeometryAttribute();
        attr.setGeometryType(19, 0);
        return featureType;
    }

    private FeatureStore createTemporalStore(EditableFeatureType featType) {
        if (featType.getStore() != null) {
            throw new IllegalArgumentException("Can't create temporal store from a feature type of a already existent store.");
        }
        try {
            FoldersManager foldersManager = ToolsLocator.getFoldersManager();
            File tempFile = foldersManager.getUniqueTemporaryFile(new String[]{"urbanHorizontalSignage_temporal_store_" + UUID.randomUUID().toString()});
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorerParameters serverParameters = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters("H2Spatial");
            ((HasAFile)serverParameters).setFile(tempFile);
            JDBCServerExplorer serverExplorer = (JDBCServerExplorer)dataManager.openServerExplorer("H2Spatial", (DataServerExplorerParameters)serverParameters);
            JDBCNewStoreParameters parametersResults = serverExplorer.getAddParameters();
            parametersResults.setDynValue("Table", (Object)"results");
            parametersResults.setDefaultFeatureType((FeatureType)featType);
            serverExplorer.add("H2Spatial", (NewDataStoreParameters)parametersResults, true);
            DataStoreParameters storeParametersResults = dataManager.createStoreParameters("H2Spatial");
            storeParametersResults.setDynValue("database_file", (Object)tempFile);
            storeParametersResults.setDynValue("Table", (Object)"results");
            FeatureStore storeResults = (FeatureStore)dataManager.openStore("H2Spatial", storeParametersResults);
            return storeResults;
        }
        catch (Exception ex) {
            LOGGER.debug("Can't create temporal store.", (Throwable)ex);
            return null;
        }
    }

    public void convertLinesToPolygons(UrbanHorizontalSignageConfig config, FeatureSet source, FeatureStore targetStore, boolean deleteSourceAtFinish, boolean useValidationRules, SimpleTaskStatus status) {
        boolean needFinishEditing = !targetStore.isEditing() && !targetStore.isAppending();
        try {
            if (needFinishEditing) {
                targetStore.edit();
            }
            for (Feature feature : source) {
                Geometry geom = feature.getDefaultGeometry();
                UrbanHorizontalSignageData data = config.getValues(feature);
                this.calculateGeometries(geom, data);
                MultiPolygon multiGeom = data.getSegmentsGeometry();
                MultiLine multiLine = data.getLineSegmentsGeometry();
                this.insertPolygonsOfLine(multiGeom, multiLine, targetStore, feature, config, config.getSegmentsColorFieldName(), useValidationRules);
                switch (data.getContinuity()) {
                    case 2: 
                    case 6: 
                    case 9: 
                    case 10: {
                        if (!data.isPaintHoles()) break;
                        multiGeom = data.getHolesGeometry();
                        multiLine = data.getLineHolesGeometry();
                        this.insertPolygonsOfLine(multiGeom, multiLine, targetStore, feature, config, config.getHolesColorFieldName(), useValidationRules);
                    }
                }
            }
            if (needFinishEditing) {
                targetStore.finishEditing();
            }
        }
        catch (Exception ex) {
            FeatureStore.cancelEditingQuietly((FeatureStore)targetStore);
            throw new RuntimeException("Can't convert lines to polygons\n" + ex.getLocalizedMessage(), ex);
        }
        if (deleteSourceAtFinish) {
            FeatureStore sourceStore = null;
            try {
                sourceStore = source.getFeatureStore();
                boolean bl = needFinishEditing = !sourceStore.isEditing() && !sourceStore.isAppending();
                if (needFinishEditing) {
                    sourceStore.edit();
                }
                for (Feature feature : source) {
                    source.delete(feature);
                }
                if (needFinishEditing) {
                    sourceStore.finishEditing();
                }
            }
            catch (Exception ex) {
                FeatureStore.cancelEditingQuietly((FeatureStore)sourceStore);
                throw new RuntimeException("Can't delete source lines", ex);
            }
        }
    }
}

