/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend;

import java.awt.Image;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageConfig;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageData;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageLegend;
import org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend.DefaultUrbanHorizontalSignageConfig;
import org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend.DefaultUrbanHorizontalSignageData;
import org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend.UrbanHorizontalSignageSymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractVectorialLegend;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUrbanHorizontalSignageLegend
extends AbstractVectorialLegend
implements UrbanHorizontalSignageLegend {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUrbanHorizontalSignageLegend.class);
    private final UrbanHorizontalSignageSymbol defaultSymbol;
    private UrbanHorizontalSignageConfig config;
    private Image imageLegend;

    public DefaultUrbanHorizontalSignageLegend() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        this.defaultSymbol = new UrbanHorizontalSignageSymbol();
        DefaultUrbanHorizontalSignageData data = new DefaultUrbanHorizontalSignageData();
        data.setContinuity(9);
        this.defaultSymbol.setData(new DefaultUrbanHorizontalSignageData());
        this.config = new DefaultUrbanHorizontalSignageConfig();
    }

    public ISymbol getDefaultSymbol() {
        return this.defaultSymbol;
    }

    public void setDefaultSymbol(ISymbol is) {
    }

    public ISymbol getSymbolByFeature(Feature ftr) throws MapContextException {
        UrbanHorizontalSignageData values = this.getConfig().getValues(ftr);
        UrbanHorizontalSignageSymbol symbol = new UrbanHorizontalSignageSymbol();
        symbol.setData(values);
        return symbol;
    }

    public int getShapeType() {
        return 2;
    }

    public void setShapeType(int i) {
    }

    public boolean isUseDefaultSymbol() {
        return true;
    }

    public void useDefaultSymbol(boolean bln) {
    }

    public boolean isSuitableForShapeType(int shapeType) {
        return GeometryUtils.isSubtype((int)2, (int)shapeType) || GeometryUtils.isSubtype((int)8, (int)shapeType);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.imageLegend = null;
        super.loadFromState(state);
        this.config = (UrbanHorizontalSignageConfig)state.get("config");
        if (this.config == null) {
            this.config = new DefaultUrbanHorizontalSignageConfig();
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("config", (Persistent)this.getConfig());
    }

    protected String[] getRequiredFeatureAttributeNames(FeatureStore fs) throws DataException {
        ArrayList<String> names = new ArrayList<String>(10);
        UrbanHorizontalSignageConfig theConfig = this.getConfig();
        String name = theConfig.getWidthFieldName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            names.add(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = theConfig.getContinuityFieldName()))) {
            names.add(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = theConfig.getHolesLengthFieldName()))) {
            names.add(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = theConfig.getHolesColorFieldName()))) {
            names.add(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = theConfig.getPaintHolesFieldName()))) {
            names.add(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = theConfig.getPaintHolesFieldName()))) {
            names.add(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = theConfig.getSegmentsLengthFieldName()))) {
            names.add(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = theConfig.getSegmentsColorFieldName()))) {
            names.add(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = theConfig.getRoundVertexFieldName()))) {
            names.add(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = fs.getDefaultFeatureType().getDefaultGeometryAttributeName()))) {
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    public UrbanHorizontalSignageConfig getConfig() {
        return this.config;
    }
}

