/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.base;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.raster.wmts.ogc.WMTSStatus;
import org.gvsig.raster.wmts.ogc.exception.DownloadException;
import org.gvsig.raster.wmts.ogc.exception.ServerErrorException;
import org.gvsig.raster.wmts.ogc.exception.WMTSException;
import org.gvsig.raster.wmts.ogc.impl.Utilities;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSServerDescription;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSStatusImpl;
import org.gvsig.raster.wmts.ogc.impl.request.WMTSGetCapabilitiesRequest;
import org.gvsig.raster.wmts.ogc.impl.request.WMTSGetFeatureInfoRequest;
import org.gvsig.raster.wmts.ogc.impl.request.WMTSGetTileRequest;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSOperationsMetadataImpl;
import org.gvsig.raster.wmts.ogc.struct.WMTSLayer;
import org.gvsig.raster.wmts.ogc.struct.WMTSStyle;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public abstract class WMTSProtocolHandler {
    private static final Logger logger = LoggerFactory.getLogger(WMTSProtocolHandler.class);
    protected String encoding = "UTF-8";
    private static int count = 0;
    final String tempDirectoryPath = System.getProperty("java.io.tmpdir") + "/tmp-andami";
    protected boolean forceChangeAxisOrder = false;
    protected String name;
    protected String version;
    protected String host;
    protected String port;
    private WMTSServerDescription serverDescription = null;

    protected abstract WMTSGetFeatureInfoRequest createGetFeatureInfoRequest(WMTSStatusImpl var1, int var2, int var3);

    protected abstract WMTSGetTileRequest createGetTileRequest(WMTSStatusImpl var1);

    protected abstract WMTSGetCapabilitiesRequest createGetCapabilitiesRequest();

    public abstract boolean parseCapabilities(File var1);

    public WMTSServerDescription getServerDescription() {
        if (this.serverDescription == null) {
            this.serverDescription = new WMTSServerDescription(this.getVersion());
        }
        return this.serverDescription;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSymbol(String h) {
        String symbol = h.indexOf("?") == -1 ? "?" : (h.indexOf("?") != h.length() - 1 ? "&" : "");
        return symbol;
    }

    protected byte[] fileToBytes(File file) throws IOException {
        byte[] bytes = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            bytes = new byte[(int)file.length()];
            int numRead = 0;
            for (int offset = 0; offset < bytes.length && (numRead = fis.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
        }
        return bytes;
    }

    public void setForceChangeAxisOrder(boolean force) {
        this.forceChangeAxisOrder = force;
    }

    public synchronized File getTile(WMTSStatusImpl status, ICancellable cancel, File file) throws ServerErrorException, WMTSException {
        try {
            WMTSGetTileRequest request = this.createGetTileRequest(status);
            request.sendRequest(cancel, file);
            try {
                this.checkFileError(file);
            }
            catch (WMTSException e) {
                file.delete();
                throw new WMTSException("This tile is not available:" + file.getAbsoluteFile().toString(), (Throwable)e);
            }
            catch (IOException e) {
                file.delete();
                throw new WMTSException("This tile is not available:" + file.getAbsoluteFile().toString(), (Throwable)e);
            }
            return file;
        }
        catch (IOException e) {
            throw new WMTSException((Throwable)e);
        }
    }

    public synchronized File getTile(WMTSStatus status, ICancellable cancel) throws ServerErrorException, WMTSException {
        try {
            WMTSGetTileRequest request = this.createGetTileRequest((WMTSStatusImpl)status);
            File f = request.sendRequest(cancel);
            try {
                this.checkFileError(f);
            }
            catch (WMTSException e) {
                DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
                downloader.removeURL((Object)request);
                throw new ServerErrorException();
            }
            return f;
        }
        catch (IOException e) {
            logger.warn("Can't get tile", (Throwable)e);
            throw new ServerErrorException();
        }
    }

    public synchronized File getTile(String url, ICancellable cancel, File file) throws ServerErrorException, WMTSException {
        try {
            this.downloadFile(new URL(url), cancel, file);
            try {
                this.checkFileError(file);
            }
            catch (WMTSException e) {
                file.delete();
                throw new WMTSException("This tile is not available:" + file.getAbsoluteFile().toString(), (Throwable)e);
            }
            catch (IOException e) {
                file.delete();
                throw new WMTSException("This tile is not available:" + file.getAbsoluteFile().toString(), (Throwable)e);
            }
            return file;
        }
        catch (IOException e) {
            throw new WMTSException((Throwable)e);
        }
        catch (DownloadException e1) {
            throw new WMTSException((Throwable)e1);
        }
    }

    private void checkFileError(File f) throws WMTSException, IOException {
        if (f == null) {
            return;
        }
        if (Utilities.isTextFile(f)) {
            byte[] data = this.fileToBytes(f);
            String exceptionMessage = this.parseException(data);
            if (exceptionMessage == null) {
                String error = new String(data);
                int pos = error.indexOf("<?xml");
                if (pos != -1) {
                    String xml = error.substring(pos, error.length());
                    exceptionMessage = this.parseException(xml.getBytes());
                }
                if (exceptionMessage == null) {
                    exceptionMessage = new String(data);
                }
            }
            throw new WMTSException(exceptionMessage);
        }
    }

    public synchronized URL getTileURL(WMTSStatusImpl status) throws MalformedURLException {
        String onlineResource = this.getBaseURL("GetTile");
        StringBuffer req = new StringBuffer();
        req.append(onlineResource).append("REQUEST=GetTile&SERVICE=WMTS&VERSION=").append(this.getVersion()).append("&").append("Layer=" + status.getLayer()).append("&Style=" + status.getStyle()).append("&Format=" + status.getFormat()).append("&TileMatrixSet=" + status.getTileMatrixSet()).append("&TileMatrix=" + status.getTileMatrix()).append("&TileRow=" + status.getTileRow()).append("&TileCol=" + status.getTileCol());
        return new URL(req.toString());
    }

    public String getBaseURL(String operation) {
        WMTSOperationsMetadataImpl opMetadata;
        String onlineResource = null;
        WMTSServerDescription svDescription = this.getServerDescription();
        if (svDescription != null && (opMetadata = svDescription.getOperationsMetadata()) != null) {
            onlineResource = opMetadata.getOnlineResource(operation);
        }
        if (onlineResource == null) {
            onlineResource = this.getHost();
        }
        String symbol = this.getSymbol(onlineResource);
        onlineResource = onlineResource + symbol;
        return onlineResource;
    }

    public String getBaseURL(String operation, int protocol) {
        WMTSOperationsMetadataImpl opMetadata;
        String onlineResource = null;
        WMTSServerDescription svDescription = this.getServerDescription();
        if (svDescription != null && (opMetadata = svDescription.getOperationsMetadata()) != null && (onlineResource = opMetadata.getOnlineResource(operation, protocol)) != null) {
            String symbol = this.getSymbol(onlineResource);
            return onlineResource + symbol;
        }
        return null;
    }

    private File getFile() {
        ++count;
        int index = this.name.lastIndexOf(".");
        if (index > 0) {
            return new File(this.tempDirectoryPath + "/" + this.name.substring(0, index) + System.currentTimeMillis() + count + this.name.substring(index, this.name.length()));
        }
        return new File(this.tempDirectoryPath + "/" + this.name + System.currentTimeMillis() + count);
    }

    public synchronized File downloadFile(URL url, ICancellable cancel, File forceFile) throws DownloadException {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        try {
            if (forceFile == null) {
                File dstFile = this.getFile();
                return downloader.downloadFile(url, "GET", null, null, dstFile.getAbsolutePath(), cancel, -1, true);
            }
            return downloader.downloadFile(url, "GET", null, null, forceFile.getAbsolutePath(), cancel, -1, false);
        }
        catch (Exception e) {
            logger.error("Can't download file" + e);
            throw new DownloadException((Throwable)e);
        }
    }

    private void disableHttsValidation() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public File getLegendGraphic(WMTSLayer layer, WMTSStyle style, ICancellable cancel) throws ServerErrorException, WMTSException, DownloadException {
        URL request = null;
        try {
            String requestStr = style.getLegendURL().getHref();
            if (requestStr == null || requestStr.equals("")) {
                return null;
            }
            request = new URL(requestStr);
            System.out.println(requestStr);
            File f = this.downloadFile(request, cancel, null);
            if (f == null) {
                return null;
            }
            if (Utilities.isTextFile(f)) {
                FileInputStream fis = new FileInputStream(f);
                FileChannel fc = fis.getChannel();
                byte[] data = new byte[(int)fc.size()];
                ByteBuffer bb = ByteBuffer.wrap(data);
                fc.read(bb);
                WMTSException wmsEx = null;
                String exceptionMessage = this.parseException(data);
                if (exceptionMessage == null) {
                    String error = new String(data);
                    int pos = error.indexOf("<?xml");
                    if (pos != -1) {
                        String xml = error.substring(pos, error.length());
                        exceptionMessage = this.parseException(xml.getBytes());
                    }
                    if (exceptionMessage == null) {
                        exceptionMessage = new String(data);
                    }
                }
                DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
                downloader.removeURL(request);
                wmsEx = new WMTSException(exceptionMessage);
                wmsEx.setWMTSMessage(new String(data));
                IOUtils.closeQuietly((InputStream)fis);
                throw wmsEx;
            }
            return f;
        }
        catch (IOException e) {
            logger.warn("Can't get legend graphics", (Throwable)e);
            throw new ServerErrorException();
        }
    }

    public String getFeatureInfo(WMTSStatusImpl status, int x, int y, ICancellable cancel) {
        StringBuffer output = new StringBuffer();
        String outputFormat = new String();
        String ServiceException = "ServiceExceptionReport";
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        try {
            WMTSGetFeatureInfoRequest request = this.createGetFeatureInfoRequest(status, x, y);
            URL url = request.getURL();
            outputFormat = url.openConnection().getContentType();
            File f = request.sendRequest(cancel);
            if (f == null) {
                return "";
            }
            FileReader fReader = new FileReader(f);
            char[] buffer = new char[262144];
            int i = fReader.read(buffer);
            while (i > 0) {
                String str = new String(buffer, 0, i);
                output.append(str);
                i = fReader.read(buffer);
            }
            fReader.close();
            if (outputFormat == null || outputFormat.indexOf("xml") != -1 || output.toString().toLowerCase().startsWith("<?xml") || outputFormat.indexOf("gml") != -1) {
                KXmlParser kxmlParser = null;
                kxmlParser = new KXmlParser();
                kxmlParser.setInput((Reader)new FileReader(f));
                kxmlParser.nextTag();
                if (kxmlParser.getName().compareTo(ServiceException) == 0) {
                    sb.append("<INFO>").append(this.parseException(output.toString().getBytes())).append("</INFO>");
                    return sb.toString();
                }
                if (kxmlParser.getName().compareToIgnoreCase("ERROR") == 0) {
                    return output.toString();
                }
                return output.toString();
            }
            return output.toString();
        }
        catch (XmlPullParserException parserEx) {
            if (output.toString().toLowerCase().indexOf("xml") != -1) {
                return output.toString().trim();
            }
            sb.append("<INFO>").append("Info format not supported").append("</INFO>");
            return sb.toString();
        }
        catch (Exception e) {
            logger.warn("Can't get FeatureInfo", (Throwable)e);
            sb.append("<INFO>").append("Info format not supported").append("</INFO>");
            return sb.toString();
        }
    }

    public void getCapabilities(WMTSServerDescription status, boolean override, ICancellable cancel) {
        try {
            this.serverDescription = status;
            WMTSGetCapabilitiesRequest request = this.createGetCapabilitiesRequest();
            File f = request.sendRequest(cancel);
            if (f == null) {
                return;
            }
            this.parseCapabilities(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String buildCapabilitiesSuitableVersionRequest(String _host, String _version) {
        int index = _host.indexOf(63);
        if (index > -1) {
            String host = _host.substring(0, index + 1);
            String query = _host.substring(index + 1, _host.length());
            StringTokenizer tokens = new StringTokenizer(query, "&");
            String newQuery = "";
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.toUpperCase().compareTo("REQUEST=GETCAPABILITIES") == 0 || token.toUpperCase().compareTo("SERVICE=WMTS") == 0 || _version != null && _version.length() > 0 && token.toUpperCase().compareTo("VERSION=" + _version) == 0 || token.toUpperCase().compareTo("EXCEPTIONS=XML") == 0) continue;
                newQuery = newQuery + token + "&";
            }
            _host = host + newQuery;
        } else {
            _host = _host + "?";
        }
        _host = _version != null && _version.compareTo("") != 0 ? _host + "REQUEST=GetCapabilities&SERVICE=WMTS&VERSION=" + _version : _host + "REQUEST=GetCapabilities&SERVICE=WMTS";
        return _host;
    }

    protected String parseException(byte[] data) throws IOException {
        try {
            ArrayList<String> errors = new ArrayList<String>();
            KXmlParser kxmlParser = new KXmlParser();
            try {
                kxmlParser.setInput((InputStream)new ByteArrayInputStream(data), this.encoding);
                kxmlParser.nextTag();
                if (kxmlParser.getEventType() != 1) {
                    kxmlParser.require(2, null, "ServiceExceptionReport");
                    int tag = kxmlParser.nextTag();
                    while (tag != 1) {
                        switch (tag) {
                            case 2: {
                                if (kxmlParser.getName().compareTo("ServiceException") != 0) break;
                                String errorCode = kxmlParser.getAttributeValue("", "code");
                                errorCode = errorCode != null ? "[" + errorCode + "] " : "";
                                String errorMessage = kxmlParser.nextText();
                                errors.add(errorCode + errorMessage);
                                break;
                            }
                        }
                        tag = kxmlParser.nextTag();
                    }
                }
            }
            catch (XmlPullParserException parser_ex) {
                throw new IOException(parser_ex.getMessage());
            }
            String message = errors.size() > 0 ? "" : null;
            for (int i = 0; i < errors.size(); ++i) {
                message = message + (String)errors.get(i) + "\n";
            }
            return message;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

