/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.request;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSProtocolHandler;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSStatusImpl;

public abstract class WMTSRequest {
    protected static final StringUtils stringUtils = CompatLocator.getStringUtils();
    protected WMTSStatusImpl status = null;
    protected WMTSProtocolHandler protocolHandler = null;
    protected boolean isDeleted = false;
    protected static final String XMLTAG_STARTCHARACTER = "<";
    protected static final String XMLTAG_FINISHCHARACTER = "</";
    protected static final String XMLTAG_ENDCHARACTER = ">";
    HttpURLConnection connection = null;
    DataOutputStream dos = null;
    DataInputStream is = null;

    public WMTSRequest(WMTSStatusImpl status, WMTSProtocolHandler protocolHandler) {
        this.status = status;
        this.protocolHandler = protocolHandler;
    }

    protected abstract String getHttpGetRequest(String var1);

    protected abstract String getHttpPostRequest(String var1);

    protected abstract String getTempFilePrefix();

    protected abstract String getOperationName();

    public URL getURL() throws MalformedURLException {
        String onlineResource = this.protocolHandler.getBaseURL(this.getOperationName());
        return new URL(this.getHttpGetRequest(onlineResource));
    }

    protected String getSchemaLocation() {
        return null;
    }

    protected String getPartialQuery(WMTSStatusImpl status) {
        String parametersForDimension = this.getParametersForDimension();
        StringBuffer req = new StringBuffer();
        req.append("Layer=" + status.getLayer()).append("&Style=" + status.getStyle()).append("&Format=" + status.getFormat()).append(parametersForDimension != null ? parametersForDimension : "").append("&TileMatrixSet=" + status.getTileMatrixSet()).append("&TileMatrix=" + status.getTileMatrix()).append("&TileRow=" + status.getTileRow()).append("&TileCol=" + status.getTileCol());
        return req.toString();
    }

    private String getParametersForDimension() {
        String dimension = this.status.getDimension();
        String valueForDimension = this.status.getValueForDimension();
        if (dimension != null && valueForDimension != null) {
            return "&" + dimension + "=" + valueForDimension;
        }
        return null;
    }

    public void sendRequest(ICancellable cancel, File file) throws ConnectException, UnknownHostException, IOException {
        String onlineResource = this.protocolHandler.getBaseURL(this.getOperationName());
        URL url = new URL(stringUtils.replaceAll(this.getHttpGetRequest(onlineResource), " ", "%20"));
        this.downloadFile(url, file, cancel);
    }

    public File sendRequest(ICancellable cancel) throws ConnectException, UnknownHostException, IOException {
        if (this.status != null && this.status.getProtocol() != -1) {
            if (this.status.getProtocol() == 0) {
                String onlineResource = this.protocolHandler.getHost();
                String symbol = this.protocolHandler.getSymbol(onlineResource);
                onlineResource = onlineResource + symbol;
                return this.sendHttpGetRequest(onlineResource, cancel);
            }
            String onlineResource = this.protocolHandler.getHost();
            return this.sendHttpPostRequest(onlineResource);
        }
        String onlineResource = this.protocolHandler.getBaseURL(this.getOperationName(), 0);
        if (onlineResource != null) {
            return this.sendHttpGetRequest(onlineResource, cancel);
        }
        onlineResource = this.protocolHandler.getBaseURL(this.getOperationName(), 1);
        if (onlineResource != null) {
            return this.sendHttpPostRequest(onlineResource);
        }
        return this.sendHttpGetRequest(this.protocolHandler.getBaseURL(this.getOperationName()), cancel);
    }

    private File sendHttpGetRequest(String onlineResource, ICancellable cancel) throws ConnectException, UnknownHostException, IOException {
        URL url = new URL(stringUtils.replaceAll(this.getHttpGetRequest(onlineResource), " ", "%20"));
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        if (this.isDeleted()) {
            downloader.removeURL(url);
        }
        return downloader.downloadFile(url, this.getTempFilePrefix(), cancel);
    }

    private File sendHttpPostRequest(String onlineResource) throws ConnectException, UnknownHostException, IOException {
        URL url = new URL(onlineResource);
        String data = this.getHttpPostRequest(onlineResource);
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        if (this.isDeleted()) {
            downloader.removeURL((Object)(url + data));
        }
        return downloader.downloadFile(url, data, this.getTempFilePrefix(), null);
    }

    public void cancelDownload() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.dos != null) {
            try {
                this.dos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void downloadFile(URL url, File dstFile, ICancellable cancel) throws IOException {
        if (cancel != null && cancel.isCanceled()) {
            throw new IOException();
        }
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        downloader.downloadFile(url, "GET", null, null, dstFile.getAbsolutePath(), cancel, -1);
    }

    private void disableHttsValidation() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    protected String createXMLStartTag(String tagName) {
        return XMLTAG_STARTCHARACTER + tagName + XMLTAG_ENDCHARACTER;
    }

    protected String createXMLEndtTag(String tagName) {
        return XMLTAG_FINISHCHARACTER + tagName + XMLTAG_ENDCHARACTER;
    }
}

