/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.struct;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSServerDescription;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSLayerImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSThemeImpl;
import org.gvsig.raster.wmts.ogc.struct.WMTSLayer;
import org.gvsig.raster.wmts.ogc.struct.WMTSTheme;
import org.gvsig.raster.wmts.ogc.struct.WMTSThemes;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class WMTSThemesImpl
extends ArrayList<WMTSThemeImpl>
implements WMTSThemes {
    private static final long serialVersionUID = 1L;

    public abstract void parse(KXmlParser var1) throws IOException, XmlPullParserException;

    public boolean hasThemes() {
        return this.size() > 0;
    }

    public void calculateLayers(List<WMTSLayer> layers) {
        for (int i = 0; i < this.size(); ++i) {
            ((WMTSThemeImpl)this.get(i)).calculateLayers(layers);
        }
    }

    public void loadThemesWithLayerInfo(List<WMTSLayer> layers, WMTSServerDescription status) {
        if (this.size() == 0) {
            for (int i = 0; i < layers.size(); ++i) {
                WMTSThemeImpl theme = (WMTSThemeImpl)status.createVersionObject("WMTSTheme");
                WMTSLayerImpl layer = (WMTSLayerImpl)layers.get(i);
                theme.setTitle(layer.getTitle());
                theme.setLayer(layer);
                theme.setAbstract(layer.getAbstract());
                this.add(theme);
            }
        }
    }

    public WMTSTheme getNodeByName(String name) {
        WMTSTheme result = null;
        for (int i = 0; i < this.size(); ++i) {
            WMTSThemeImpl theme = (WMTSThemeImpl)this.get(i);
            String title = theme.getTitle();
            result = title.compareTo(name) == 0 ? (WMTSThemeImpl)this.get(i) : theme.getNodeByName(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int getChildCount() {
        return this.size();
    }

    public WMTSThemeImpl getChildren(int index) {
        return (WMTSThemeImpl)this.get(index);
    }

    public int getIndexOfChild(WMTSTheme child) {
        for (int i = 0; i < this.size(); ++i) {
            if (child != this.getChildren(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        return "Base";
    }

    public void sort() {
        Collections.sort(this, new Comparator<WMTSTheme>(){

            @Override
            public int compare(WMTSTheme o1, WMTSTheme o2) {
                return StringUtils.compare((String)o1.getTitle(), (String)o2.getTitle(), (boolean)true);
            }
        });
        for (WMTSThemeImpl theTheme : this) {
            theTheme.sort();
        }
    }
}

