/*
 * Decompiled with CFR 0.152.
 */
package com.notification;

import com.notification.NotificationListener;
import com.notification.NotificationManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Notification {
    private NotificationManager m_manager;
    private List<NotificationListener> m_listeners = new CopyOnWriteArrayList<NotificationListener>();

    public void addNotificationListener(NotificationListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.m_listeners.remove(listener);
    }

    public boolean isManaged() {
        return this.m_manager != null;
    }

    public NotificationManager getNotificationManager() {
        return this.m_manager;
    }

    protected void setNotificationManager(NotificationManager manager) {
        this.m_manager = manager;
    }

    public void removeFromManager() {
        this.m_manager.removeNotification(this);
    }

    protected void fireListeners(String action) {
        for (NotificationListener nl : this.m_listeners) {
            nl.actionCompleted(this, action);
        }
    }

    public abstract int getX();

    public abstract int getY();

    public abstract void setLocation(int var1, int var2);

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract void setSize(int var1, int var2);

    public abstract double getOpacity();

    public abstract void setOpacity(double var1);

    public abstract void show();

    public abstract void hide();

    public abstract boolean isShown();
}

