/*
 * Decompiled with CFR 0.152.
 */
package es.gva.cit.jmrsid;

import es.gva.cit.jmrsid.JNIBase;
import es.gva.cit.jmrsid.MrSIDException;
import es.gva.cit.jmrsid.StringArray;

public class LTIMetadataRecord
extends JNIBase {
    public static final int LTI_METADATA_DATATYPE_INT = 0;
    public static final int LTI_METADATA_DATATYPE_FLOAT = 1;
    public static final int LTI_METADATA_DATATYPE_STRING = 2;

    private native String getTagNameNat(long var1);

    private native int isScalarNat(long var1);

    private native int isVectorNat(long var1);

    private native int isArrayNat(long var1);

    private native int getDataTypeNat(long var1);

    private native String getScalarDataNat(long var1);

    private native StringArray getVectorDataNat(long var1);

    private native StringArray getArrayDataNat(long var1);

    private native int getNumDimsNat(long var1);

    private native int[] getDimsNat(long var1);

    private native void FreeLTIMetadataRecordNat(long var1);

    protected void finalize() {
        if (this.cPtr != 0L) {
            this.FreeLTIMetadataRecordNat(this.cPtr);
        }
    }

    public LTIMetadataRecord() {
    }

    public LTIMetadataRecord(long cPtr) {
        this.cPtr = cPtr;
    }

    public String getTagName() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getTagName. La referencia al objeto no es valida.");
        }
        String tagname = this.getTagNameNat(this.cPtr);
        if (tagname == null) {
            throw new MrSIDException("No se ha devuelto un nombre de tag valido");
        }
        return tagname;
    }

    public boolean isScalar() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getTagName. La referencia al objeto no es valida.");
        }
        int res = this.isScalarNat(this.cPtr);
        return res == 1;
    }

    public boolean isVector() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en isVector. La referencia al objeto no es valida.");
        }
        int res = this.isVectorNat(this.cPtr);
        return res == 1;
    }

    public boolean isArray() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getTagName. La referencia al objeto no es valida.");
        }
        int res = this.isArrayNat(this.cPtr);
        return res == 1;
    }

    public int getDataType() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getDataType. La referencia al objeto no es valida.");
        }
        int res = this.getDataTypeNat(this.cPtr);
        if (res < 0) {
            throw new MrSIDException("Error en getDataType. No se ha obtenido un tipo de datos valido");
        }
        return res;
    }

    public String getScalarData() throws MrSIDException {
        String datos = null;
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getScalarData. La referencia al objeto no es valida.");
        }
        datos = this.getScalarDataNat(this.cPtr);
        return datos;
    }

    public String[] getVectorData() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getVectorData. La referencia al objeto no es valida.");
        }
        StringArray res = this.getVectorDataNat(this.cPtr);
        if (res != null) {
            return res.array;
        }
        return null;
    }

    public String[] getArrayData() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getArrayData. La referencia al objeto no es valida.");
        }
        StringArray res = this.getArrayDataNat(this.cPtr);
        if (res != null) {
            return res.array;
        }
        return null;
    }

    public int getNumDims() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getNumDims. La referencia al objeto no es valida.");
        }
        int res = this.getNumDimsNat(this.cPtr);
        if (res < 0) {
            throw new MrSIDException("Error en getNumDims. El n\u00famero de dimensiones obtenido no es valido.");
        }
        return res;
    }

    public int[] getDims() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getDims. La referencia al objeto no es valida.");
        }
        int[] res = this.getDimsNat(this.cPtr);
        if (res == null || res.length == 0) {
            throw new MrSIDException("Error en getDims. No se ha podido obtener la longitud de las dimensiones.");
        }
        return res;
    }
}

