/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.propertypage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.propertypage.BasePropertiesPagePanelLayout;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.propertypage.PropertiesPageManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.util.Invocable;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.gvsig.tools.util.ToolsUtilLocator;

public class BasePropertiesPageDialog
extends BasePropertiesPagePanelLayout
implements org.gvsig.tools.swing.api.Component,
PropertiesSupport {
    public static final int ACTION_CANCEL = 0;
    public static final int ACTION_ACCEPT = 1;
    public static final int ACTION_APPLY = 2;
    private Object obj;
    private String groupID;
    private List<PropertiesPage> pages = null;
    protected int userAction = 1;
    private JTabbedPane tabbedPane = null;
    private PropertiesSupportHelper propertiesHelper = new PropertiesSupportHelper();

    public BasePropertiesPageDialog() {
    }

    public BasePropertiesPageDialog(Object obj, String groupID) {
        this();
        this.init(groupID, obj);
    }

    protected void init(String groupID, Object obj) {
        this.obj = obj;
        this.groupID = groupID;
        PropertiesPageManager manager = ToolsUtilLocator.getPropertiesPageManager();
        this.pages = manager.getPages(this.groupID, this, this.obj);
        this.initComponents();
    }

    protected void initComponents() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.content.setLayout(new BorderLayout());
        Component contents = this.createPropertiesPagesPanel();
        if (contents instanceof JTabbedPane) {
            this.tabbedPane = (JTabbedPane)contents;
        }
        this.content.add(contents, "Center");
        this.titleLabel.setText("");
        this.acceptButton.setText(i18nManager.getTranslation("accept"));
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BasePropertiesPageDialog.this.whenAccept();
            }
        });
        this.applyButton.setText(i18nManager.getTranslation("apply"));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BasePropertiesPageDialog.this.whenApply();
            }
        });
        this.cancelButton.setText(i18nManager.getTranslation("cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BasePropertiesPageDialog.this.whenCancel();
            }
        });
    }

    public List<PropertiesPage> getPages() {
        return this.pages;
    }

    public PropertiesPage getPage(String theClass) {
        boolean useSimpleName = !theClass.contains(".");
        for (PropertiesPage page : this.pages) {
            if (!(useSimpleName ? StringUtils.equals((CharSequence)theClass, (CharSequence)page.getClass().getSimpleName()) : StringUtils.equals((CharSequence)theClass, (CharSequence)page.getClass().getName()))) continue;
            return page;
        }
        return null;
    }

    protected PropertiesPage getPage(Class<? extends PropertiesPage> theClass) {
        for (PropertiesPage page : this.pages) {
            if (!theClass.isInstance(page)) continue;
            return page;
        }
        return null;
    }

    protected boolean isButtonVisible(int button) {
        switch (button) {
            case 4: {
                return this.applyButton.isVisible();
            }
            case 1: {
                return this.acceptButton.isVisible();
            }
            case 2: {
                return this.cancelButton.isVisible();
            }
        }
        return false;
    }

    protected void setButtonVisible(int button, boolean visible) {
        switch (button) {
            case 4: {
                this.applyButton.setVisible(visible);
                break;
            }
            case 1: {
                this.acceptButton.setVisible(visible);
                break;
            }
            case 2: {
                this.cancelButton.setVisible(visible);
            }
        }
    }

    protected void setButtonLabel(int button, String label) {
        switch (button) {
            case 4: {
                this.applyButton.setText(label);
                break;
            }
            case 1: {
                this.acceptButton.setText(label);
                break;
            }
            case 2: {
                this.cancelButton.setText(label);
            }
        }
    }

    protected boolean isButtonEnabled(int button) {
        switch (button) {
            case 4: {
                return this.applyButton.isEnabled();
            }
            case 1: {
                return this.acceptButton.isEnabled();
            }
            case 2: {
                return this.cancelButton.isEnabled();
            }
        }
        return false;
    }

    protected void setButtonEnabled(int button, boolean visible) {
        switch (button) {
            case 4: {
                this.applyButton.setEnabled(visible);
                break;
            }
            case 1: {
                this.acceptButton.setEnabled(visible);
                break;
            }
            case 2: {
                this.cancelButton.setEnabled(visible);
            }
        }
    }

    protected Component createPropertiesPagesPanel() {
        if (this.pages.size() == 1 && !this.useTabsAlwais()) {
            PropertiesPage page = this.pages.get(0);
            return page.asJComponent();
        }
        JTabbedPane theTabbedPane = new JTabbedPane();
        for (int i = 0; i < this.pages.size(); ++i) {
            PropertiesPage page = this.pages.get(i);
            if (page instanceof ActionListenerSupport) {
                ((ActionListenerSupport)page).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (e instanceof PropertiesPage.SetPageEnabledEvent) {
                            PropertiesPage.SetPageEnabledEvent ee = (PropertiesPage.SetPageEnabledEvent)((Object)e);
                            BasePropertiesPageDialog.this.setEnabledAt(ee.getFilter(), ee.isEnabled());
                        }
                    }
                });
            }
            theTabbedPane.addTab(page.getTitle(), page.asJComponent());
        }
        return theTabbedPane;
    }

    protected boolean useTabsAlwais() {
        return false;
    }

    public void whenAccept() {
        PropertiesPage activePage = null;
        for (int i = 0; i < this.pages.size(); ++i) {
            PropertiesPage page = this.pages.get(i);
            if (this.tabbedPane == null || this.tabbedPane.getSelectedIndex() == i) {
                activePage = page;
                continue;
            }
            if (page.whenAccept()) continue;
            return;
        }
        if (activePage != null && !activePage.whenAccept()) {
            return;
        }
        this.userAction = 1;
        this.closeDialog();
    }

    public void whenApply() {
        PropertiesPage activePage = null;
        for (int i = 0; i < this.pages.size(); ++i) {
            PropertiesPage page = this.pages.get(i);
            if (this.tabbedPane == null || this.tabbedPane.getSelectedIndex() == i) {
                activePage = page;
                continue;
            }
            if (page.whenApply()) continue;
            return;
        }
        if (activePage != null && !activePage.whenApply()) {
            return;
        }
        this.userAction = 2;
    }

    public void whenCancel() {
        PropertiesPage activePage = null;
        for (int i = 0; i < this.pages.size(); ++i) {
            PropertiesPage page = this.pages.get(i);
            if (this.tabbedPane == null || this.tabbedPane.getSelectedIndex() == i) {
                activePage = page;
                continue;
            }
            if (page.whenCancel()) continue;
            return;
        }
        if (activePage != null && !activePage.whenCancel()) {
            return;
        }
        this.userAction = 0;
        this.closeDialog();
    }

    public int getUserAction() {
        return this.userAction;
    }

    protected void closeDialog() {
        this.setVisible(false);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setEnabledAt(Invocable filter, boolean enabled) {
        if (this.tabbedPane == null) {
            return;
        }
        for (int i = 0; i < this.pages.size(); ++i) {
            PropertiesPage page = this.pages.get(i);
            if (!((Boolean)filter.call(new Object[]{page})).booleanValue()) continue;
            this.tabbedPane.setEnabledAt(i, enabled);
        }
    }

    public PropertiesPage getActivePage() {
        for (int i = 0; i < this.pages.size(); ++i) {
            PropertiesPage page = this.pages.get(i);
            if (this.tabbedPane == null || this.tabbedPane.getSelectedIndex() != i) continue;
            return page;
        }
        return null;
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }
}

