/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.io;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.DatasetBand;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.BandNotFoundInListException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InfoByPointException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.parameter.MultiDimensionalStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RemoteStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.TileCache;
import org.gvsig.raster.cache.tile.TileCacheLibrary;
import org.gvsig.raster.cache.tile.TileCacheLocator;
import org.gvsig.raster.cache.tile.TileCacheManager;
import org.gvsig.raster.cache.tile.exception.TileBuildException;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.cache.tile.layer.TiledLayer;
import org.gvsig.raster.cache.tile.provider.CacheStruct;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.BandListImpl;
import org.gvsig.raster.impl.datastruct.DatasetBandImpl;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.MemoryTileMatrixBuffer;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.RemoteRasterProvider;
import org.gvsig.raster.impl.provider.TiledRasterProvider;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.raster.impl.store.properties.RemoteDataStoreStatistics;
import org.gvsig.raster.tilecache.io.TileDataParametersImpl;
import org.gvsig.raster.tilecache.io.TileProviderFactory;
import org.gvsig.raster.tilecache.io.TileServerExplorer;
import org.gvsig.raster.tilecache.io.TileServerExplorerParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.locator.LocatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileProvider
extends AbstractRasterProvider
implements TiledRasterProvider {
    public static String NAME = "Tile Store";
    public static String DESCRIPTION = "Raster Tiled Source";
    public static final String METADATA_DEFINITION_NAME = "TileStore";
    private static final Logger logger = LoggerFactory.getLogger(TileProvider.class);
    private RasterProvider provider = null;
    private boolean open = false;
    private Extent viewRequest = null;
    private TiledLayer tiledLayer = null;
    private MathUtils math = RasterLocator.getManager().getMathUtils();
    private TileServer secondLevelTileServer = null;

    public static void register() {
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (dataman != null && !dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProviderFactory((DataStoreProviderFactory)new TileProviderFactory(NAME, DESCRIPTION));
        }
        if (!dataman.getExplorerProviders().contains("TileServerExplorer")) {
            dataman.registerExplorerProvider("TileServerExplorer", TileServerExplorer.class, TileServerExplorerParameters.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    private RasterProvider loadProvider(TileDataParametersImpl params, DataStoreProviderServices storeServices) throws ProviderNotRegisteredException, InitializeException {
        DataParameters obj = params.getDataParameters();
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        DataStoreProvider prov = null;
        if (obj != null && obj instanceof DataStoreParameters) {
            prov = dataManager.createProvider(storeServices, (DataStoreParameters)obj);
        } else if (params.getFile() != null) {
            FilesystemServerExplorerParameters paramsExplorer = (FilesystemServerExplorerParameters)dataManager.createServerExplorerParameters("FilesystemExplorer");
            FilesystemServerExplorer serverExplorer = null;
            try {
                paramsExplorer.setRoot(File.separator);
                serverExplorer = (FilesystemServerExplorer)dataManager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)paramsExplorer);
            }
            catch (ValidateDataParametersException e) {
                throw new InitializeException((Throwable)e);
            }
            List provName = serverExplorer.getProviderNameList(params.getFile());
            if (provName.size() > 0) {
                for (int i = 0; i < provName.size(); ++i) {
                    if (((String)provName.get(i)).compareTo(NAME) == 0) continue;
                    DataStoreParameters newparams = dataManager.createStoreParameters((String)provName.get(i));
                    ((FilesystemStoreParameters)newparams).setFile(params.getFile());
                    prov = dataManager.createProvider(storeServices, newparams);
                }
            }
        }
        if (prov != null && prov instanceof RasterProvider) {
            if (((RasterProvider)prov).isRotated()) {
                throw new InitializeException("Rotation not supported tiling files", new Throwable());
            }
            return (RasterProvider)prov;
        }
        return null;
    }

    public RasterProvider getInternalProvider() {
        return this.provider;
    }

    public Image getImageLegend() {
        return this.provider.getImageLegend();
    }

    public ColorInterpretation getColorInterpretation() {
        return this.provider.getColorInterpretation();
    }

    public String getFileSuffix() {
        try {
            return this.provider.getFileSuffix();
        }
        catch (Throwable e) {
            return "tif";
        }
    }

    public File getRMFFile() {
        TileCacheManager manager = TileCacheLocator.getManager();
        TileCache tileCache = manager.getTileCache(RasterLibrary.pathTileCache);
        String metadataDir = this.tiledLayer.getBaseLayerDirectory().substring(0, this.tiledLayer.getBaseLayerDirectory().lastIndexOf(File.separator) + 1) + tileCache.getConfigurationDirectory();
        File metadaDirFile = new File(metadataDir);
        if (!metadaDirFile.exists()) {
            metadaDirFile.mkdir();
        }
        String path = metadataDir + File.separator + this.tiledLayer.getID() + ".rmf";
        try {
            if (!new File(path).exists() && this.provider != null && this.provider.getRMFFile() != null && this.provider.getRMFFile().exists()) {
                RasterLocator.getManager().getFileUtils().copyFile(this.provider.getRMFFile().getAbsolutePath(), path);
            }
            if (this.provider != null && this.provider.getColorTable() != null) {
                ColorTable colorTable = this.provider.getColorTable();
                RasterLocator.getManager().getProviderServices().saveObjectToRmfFile(path, ColorTable.class, (Object)colorTable);
            }
        }
        catch (LocatorException e) {
            logger.info("No se ha podido copiar el fichero RMF a la capa tileada", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.info("No se ha podido copiar el fichero RMF a la capa tileada", (Throwable)e);
        }
        catch (IOException e) {
            logger.info("No se ha podido copiar el fichero RMF a la capa tileada", (Throwable)e);
        }
        catch (RmfSerializerException e) {
            logger.info("No se ha podido copiar la tabla de color a la capa tileada", (Throwable)e);
        }
        return new File(path);
    }

    public TileProvider() throws NotSupportedExtensionException {
    }

    public void registerTileProviderFormats(Class<RasterProvider> c) {
    }

    public void setProvider(RasterProvider prov) throws InitializeException {
        this.provider = prov;
        this.init(this.getDataStoreParameters(), (DataStoreProviderServices)this.getStoreServices());
    }

    public TileProvider(TileDataParametersImpl params, DataStoreProviderServices storeServices) throws InitializeException {
        super((AbstractRasterDataParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        if (!params.isSecondLevelCache()) {
            try {
                this.provider = this.loadProvider(params, storeServices);
            }
            catch (ProviderNotRegisteredException e) {
                throw new InitializeException("Provider not registered", (Throwable)e);
            }
            this.init((DataStoreParameters)params, storeServices);
            if (this.provider.getFileSizeByProvider() != null && this.provider.getFileSizeByProvider().length > 0) {
                this.fileSize = this.provider.getFileSizeByProvider()[0];
            }
        }
    }

    public void init(DataStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        this.setParam(storeServices, params);
        this.open = true;
        this.calculateDataType();
        this.calculateBandCount();
        this.calculateColorInterpretation();
        this.calculateTransparency();
        this.setColorTable(this.provider.getColorTable());
        this.noData = this.provider.getNoDataValue();
        this.uri = this.provider.getURIOfFirstProvider();
        this.proj = this.provider.getProjection();
        this.ownTransformation = this.provider.getAffineTransform();
        this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
        this.createTiledLayer();
        if (this.tiledLayer != null && this.param instanceof TileDataParameters && ((TileDataParameters)this.param).isDeletingCache()) {
            TileCacheManager manager = TileCacheLocator.getManager();
            TileCache tileCache = manager.getTileCache(RasterLibrary.pathTileCache);
            tileCache.removeLayer(this.tiledLayer);
            ((TileDataParameters)this.param).deleteCache(false);
        }
        if (this.provider instanceof RemoteRasterProvider) {
            this.stats = new RemoteDataStoreStatistics(this.provider);
        }
    }

    public void calculateDataType() {
        int[] datatype = null;
        datatype = this.provider.getDataType()[0] == 0 && this.provider.getBandCount() == 3 ? new int[this.provider.getBandCount() + 1] : new int[this.provider.getBandCount()];
        for (int i = 0; i < this.provider.getDataType().length; ++i) {
            datatype[i] = this.provider.getDataType()[i];
        }
        if (this.provider.getDataType()[0] == 0 && this.provider.getBandCount() == 3) {
            datatype[datatype.length - 1] = 0;
        }
        this.setDataType(datatype);
    }

    public void calculateBandCount() {
        this.bandCount = this.provider.getBandCount();
        if (this.provider.getDataType()[0] == 0 && this.provider.getBandCount() == 3) {
            ++this.bandCount;
        }
    }

    public void calculateColorInterpretation() {
        Object ci = this.provider.getColorInterpretation();
        ci = ci != null ? (ci.isRGB() || ci.isBGR() ? DataStoreColorInterpretation.createRGBAInterpretation() : ci.cloneColorInterpretation()) : (this.provider.getDataType()[0] == 0 ? (this.provider.getBandCount() == 3 ? DataStoreColorInterpretation.createRGBAInterpretation() : DataStoreColorInterpretation.createDefaultInterpretation((int)this.getBandCount())) : (this.getBandCount() == 1 ? DataStoreColorInterpretation.createGrayInterpretation() : DataStoreColorInterpretation.createDefaultInterpretation((int)this.getBandCount())));
        super.setColorInterpretation(ci);
    }

    public void calculateTransparency() {
        this.transparency = this.provider.getTransparency() != null ? this.provider.getTransparency().cloneTransparency() : new DataStoreTransparency(this.getColorInterpretation());
        if (this.getColorInterpretation() != null) {
            this.transparency.setColorInterpretation(this.getColorInterpretation());
            this.transparency.setTransparencyBand(this.getColorInterpretation().getAlphaBand());
            this.transparency.activeTransparency();
        }
    }

    private void createTiledLayer() {
        TileCacheManager manager = TileCacheLocator.getManager();
        TileCache tileCache = manager.getTileCache(RasterLibrary.pathTileCache);
        TiledLayer newLayer = tileCache.createLayer(this.provider.getTileServer(), TileCacheLibrary.DEFAULT_STRUCTURE);
        if (this.tiledLayer == null || newLayer.getID().compareTo(this.tiledLayer.getID()) != 0) {
            this.tiledLayer = newLayer;
        }
    }

    public void reload() {
        try {
            this.loadFromRmf(this.getRmfBlocksManager());
            this.calculateColorInterpretation();
            this.calculateTransparency();
        }
        catch (ParsingException e) {
            logger.debug("No se ha podido leer el RMF", (Throwable)e);
        }
    }

    public int getZoomLevels() {
        if (this.provider.getTileServer() != null) {
            return this.provider.getTileServer().getStruct().getNumberOfLevels();
        }
        return 0;
    }

    public int getNearestLevel(double pixelSize) {
        double[] pixelSizes = this.getPixelSizeByLevel();
        for (int i = 0; i < pixelSizes.length - 1; ++i) {
            if (!(pixelSize <= pixelSizes[i]) || !(pixelSize > pixelSizes[i + 1])) continue;
            return i;
        }
        if (pixelSize < pixelSizes[this.getZoomLevels() - 1]) {
            return this.getZoomLevels() - 1;
        }
        return 0;
    }

    public double[] getPixelSizeByLevel() {
        double[] list = new double[this.getZoomLevels()];
        CacheStruct struct = this.provider.getTileServer().getStruct();
        for (int i = 0; i < struct.getNumberOfLevels(); ++i) {
            list[i] = this.math.adjustDouble(struct.getPixelSizeByLevel(i));
        }
        return list;
    }

    public Extent getCoordsInTheNearestLevel(Extent extent, int w, int h) {
        double[] pixelSizes = this.getPixelSizeByLevel();
        double currentPixelSize = extent.width() / (double)w;
        int level = 0;
        for (int i = 0; i < pixelSizes.length - 1; ++i) {
            if (!(currentPixelSize < pixelSizes[i]) || !(currentPixelSize >= pixelSizes[i + 1])) continue;
            level = i + 1;
            break;
        }
        return this.getZoomLevelCoordinates(level, extent, w, h);
    }

    public Extent getCoordsInLevel(Point2D viewCenter, int level, int w, int h) {
        level = this.adjustLevel(level);
        double pixelSize = this.provider.getTileServer().getStruct().getPixelSizeByLevel(level);
        double ulx = viewCenter.getX() - (double)(w / 2) * pixelSize;
        double uly = viewCenter.getY() - (double)(h / 2) * pixelSize;
        double lrx = ulx + (double)w * pixelSize;
        double lry = uly + (double)h * pixelSize;
        return new ExtentImpl(ulx, uly, lrx, lry);
    }

    private int adjustLevel(int level) {
        if (level < 0) {
            level = 0;
        }
        if (level > this.getZoomLevels()) {
            level = this.getZoomLevels();
        }
        return level;
    }

    public AffineTransform getAffineTransform() {
        return this.provider.getAffineTransform();
    }

    public Extent getExtent() {
        return this.provider.getExtent();
    }

    public RasterProvider load() {
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isTiled() {
        return true;
    }

    public void close() {
        this.open = false;
        if (this.provider != null) {
            this.provider.close();
        }
    }

    public URI translateURI(URI uri) {
        return uri;
    }

    public void setView(Extent e) {
        this.viewRequest = e;
    }

    public Extent getView() {
        return this.viewRequest;
    }

    public double getWidth() {
        return this.provider.getWidth();
    }

    public double getHeight() {
        return this.provider.getHeight();
    }

    public Object readCompleteLine(int line, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        return null;
    }

    public File getFileLayer() throws RasterDriverException {
        return null;
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        if (this.provider.getBandCount() < this.getBandCount()) {
            switch (this.getDataType()[0]) {
                case 0: {
                    byte[][][] buf1 = (byte[][][])this.provider.readBlock(pos, blockHeight, scale);
                    byte[][][] b1 = new byte[buf1.length + 1][][];
                    for (int i = 0; i < buf1.length; ++i) {
                        b1[i] = buf1[i];
                    }
                    b1[b1.length - 1] = new byte[buf1[0].length][buf1[0][0].length];
                    return b1;
                }
                case 2: {
                    short[][][] buf2 = (short[][][])this.provider.readBlock(pos, blockHeight, scale);
                    short[][][] b2 = new short[buf2.length + 1][][];
                    for (int i = 0; i < buf2.length; ++i) {
                        b2[i] = buf2[i];
                    }
                    b2[b2.length - 1] = new short[buf2[0].length][buf2[0][0].length];
                    return b2;
                }
                case 4: {
                    float[][][] buf3 = (float[][][])this.provider.readBlock(pos, blockHeight, scale);
                    float[][][] b3 = new float[buf3.length + 1][][];
                    for (int i = 0; i < buf3.length; ++i) {
                        b3[i] = buf3[i];
                    }
                    b3[b3.length - 1] = new float[buf3[0].length][buf3[0][0].length];
                    return b3;
                }
                case 5: {
                    double[][][] buf4 = (double[][][])this.provider.readBlock(pos, blockHeight, scale);
                    double[][][] b4 = new double[buf4.length + 1][][];
                    for (int i = 0; i < buf4.length; ++i) {
                        b4[i] = buf4[i];
                    }
                    b4[b4.length - 1] = new double[buf4[0].length][buf4[0][0].length];
                    return b4;
                }
                case 3: {
                    int[][][] buf5 = (int[][][])this.provider.readBlock(pos, blockHeight, scale);
                    int[][][] b5 = new int[buf5.length + 1][][];
                    for (int i = 0; i < buf5.length; ++i) {
                        b5[i] = buf5[i];
                    }
                    b5[b5.length - 1] = new int[buf5[0].length][buf5[0][0].length];
                    return b5;
                }
            }
        }
        return this.provider.readBlock(pos, blockHeight, scale);
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        return this.provider.getData(x, y, band);
    }

    public Buffer getBuffer(Buffer rasterBuf, BandList bandList, File lastFile, double ulx, double uly, double lrx, double lry) throws RasterDriverException, ProcessInterruptedException {
        return null;
    }

    public Extent getZoomLevelCoordinates(int level, Extent extent, int w, int h) {
        double centerX = extent.getCenterX();
        double centerY = extent.getCenterY();
        return this.getCoordsInLevel(new Point2D.Double(centerX, centerY), level, w, h);
    }

    public boolean isRasterEnclosed() {
        if (this.provider != null) {
            return this.provider.isRasterEnclosed();
        }
        return super.isRasterEnclosed();
    }

    private List<Tile> getTileList(SpiRasterQuery q) throws TileBuildException {
        int i;
        TileServer tileServer = this.provider.getTileServer();
        CacheStruct struct = tileServer.getStruct();
        this.createTiledLayer();
        double pixelSizeRequest = q.getRequestBoundingBox().width() / (double)q.getBufWidth();
        List tileList = struct.getTileList(q.getAdjustedRequestBoundingBox().getUL(), q.getAdjustedRequestBoundingBox().getLR(), pixelSizeRequest);
        for (i = 0; i < tileList.size(); ++i) {
            this.loadTileTimeParameters((Tile)tileList.get(i));
        }
        for (i = 0; i < tileList.size(); ++i) {
            ((Tile)tileList.get(i)).setDownloaderParams("BandList", q.getBandList().clone());
        }
        return tileList;
    }

    private void loadTileTimeParameters(Tile tile) {
        if (this.provider.getDataParameters() instanceof MultiDimensionalStoreParameters) {
            MultiDimensionalStoreParameters par = (MultiDimensionalStoreParameters)this.provider.getDataParameters();
            tile.setVariable(par.getStringVariable());
            tile.setZ(par.getStringLevel());
            tile.setTimeInstant(par.getStringTime());
        }
    }

    public boolean needEnhanced() {
        return this.provider.needEnhanced();
    }

    public Tile getTile(SpiRasterQuery q) throws TileGettingException {
        if (q.getCacheStruct() == null) {
            q.setCacheStruct(this.provider.getTileServer().getStruct());
        } else {
            this.provider.getTileServer().setStruct(q.getCacheStruct());
        }
        Tile tile = null;
        try {
            tile = q.getCacheStruct().getTileStructure(q.getResolutionLevel(), q.getTileCol(), q.getTileRow(), q.getAdjustedRequestBoundingBox().getUL(), q.getAdjustedRequestBoundingBox().getLR());
        }
        catch (TileBuildException e1) {
            throw new TileGettingException((Throwable)e1);
        }
        this.loadTileTimeParameters(tile);
        BandListImpl bandList = new BandListImpl();
        for (int i = 0; i < this.provider.getBandCount(); ++i) {
            try {
                DatasetBandImpl band = new DatasetBandImpl(this.provider.getURIOfFirstProvider(), i, this.provider.getDataType()[i], this.provider.getBandCount());
                bandList.addBand((DatasetBand)band);
                continue;
            }
            catch (BandNotFoundInListException bandNotFoundInListException) {
                // empty catch block
            }
        }
        bandList.setDrawableBands(new int[]{0, 1, 2});
        tile.setDownloaderParams("BandList", (Object)bandList);
        this.createTiledLayer();
        return this.tiledLayer.getTile(tile);
    }

    public void loadBuffer(SpiRasterQuery q) throws ProcessInterruptedException, RasterDriverException {
        try {
            if (q.requestIsTiled()) {
                List<Tile> tileList = this.getTileList(q);
                this.tiledLayer.getTiles(tileList, q.getTileListener(), q.getTaskStatus());
            } else if (this.provider.isTiled()) {
                this.queryToInternalTiledProvider(q);
            } else {
                this.queryToInternalProvider(q);
            }
        }
        catch (TileGettingException e) {
            throw new RasterDriverException("Error getting the tile list", (Exception)((Object)e));
        }
        catch (TileBuildException e) {
            throw new RasterDriverException("Error building the tile list", (Exception)((Object)e));
        }
        catch (QueryException e) {
            throw new RasterDriverException("Error querying to the internal provider", (Exception)((Object)e));
        }
    }

    private void queryToInternalTiledProvider(SpiRasterQuery parentQuery) throws TileGettingException, TileBuildException {
        List<Tile> tileList = this.getTileList(parentQuery);
        for (int i = 0; i < tileList.size(); ++i) {
            this.tiledLayer.getTile(tileList.get(i));
        }
        MemoryTileMatrixBuffer matrixBuffer = new MemoryTileMatrixBuffer(tileList);
        Buffer buf = matrixBuffer.getWindow(parentQuery.getAdjustedRequestBoundingBox(), parentQuery.getBufWidth(), parentQuery.getBufHeight(), parentQuery.getBandList().getDrawableBandsCount());
        parentQuery.setBufferResult(buf);
    }

    private void queryToInternalProvider(SpiRasterQuery parentQuery) throws ProcessInterruptedException, QueryException {
        DefaultRasterStore store = new DefaultRasterStore();
        store.setProvider(this.provider);
        RasterQuery query = RasterLocator.getManager().createQuery();
        query.setAreaOfInterest(parentQuery.getAdjustedRequestBoundingBox(), parentQuery.getBufWidth(), parentQuery.getBufHeight());
        int[] dBands = null;
        if (parentQuery.getDrawableBands() != null) {
            dBands = (int[])parentQuery.getDrawableBands().clone();
            if (!((AbstractRasterProvider)this.provider).getTransparency().existAlphaBand() && this.getTransparency().existAlphaBand()) {
                dBands[this.getTransparency().getAlphaBandNumber()] = -1;
            }
        }
        query.setReadOnly(((RasterQuery)parentQuery).isReadOnly());
        if (((RasterQuery)parentQuery).isforcingARGBRequest()) {
            query.forceARGBRequest();
        }
        if (((RasterQuery)parentQuery).isforcingRGBRequest()) {
            query.forceRGBRequest();
        }
        if (dBands == null) {
            query.setAllDrawableBands();
        } else {
            query.setDrawableBands(dBands);
        }
        query.setAdjustToExtent(true);
        store.query(query);
        parentQuery.setBufferResult(((SpiRasterQuery)query).getBufferForProviders());
    }

    public int getBlockSize() {
        return 0;
    }

    public void setAffineTransform(AffineTransform t) {
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        return this.getZoomLevels();
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        return this.provider.getTileServer().getStruct().getLayerWidthOfTileMatrixByLevel(overview) * this.provider.getTileServer().getStruct().getTileSizeByLevel(overview)[0];
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        return this.provider.getTileServer().getStruct().getLayerHeightOfTileMatrixByLevel(overview) * this.provider.getTileServer().getStruct().getTileSizeByLevel(overview)[0];
    }

    public boolean isOverviewsSupported() {
        return false;
    }

    public String getProviderName() {
        return NAME;
    }

    public Point2D rasterToWorld(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        this.getAffineTransform().transform(pt, p);
        return p;
    }

    public Point2D worldToRaster(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        try {
            this.getAffineTransform().inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof TileProvider) {
            // empty if block
        }
    }

    public void setParam(DataStoreProviderServices storeServices, DataStoreParameters param) {
        if (param instanceof RemoteStoreParameters) {
            this.uri = ((RasterDataParameters)param).getURI();
        }
        this.param = param;
        this.storeServices = storeServices;
    }

    public String getInfoByPoint(double x, double y, ICancellable cancellable) throws InfoByPointException {
        if (this.provider != null) {
            return this.provider.getInfoByPoint(x, y, cancellable);
        }
        return "Not implemented";
    }

    public String getInfoByPoint(int x, int y, Extent bbox, int w, int h, ICancellable cancellable) throws InfoByPointException {
        if (this.provider != null) {
            return this.provider.getInfoByPoint(x, y, bbox, w, h, cancellable);
        }
        return "Not implemented";
    }

    public int[] getTileSize(int level) {
        return this.provider.getTileServer().getStruct().getTileSizeByLevel(level);
    }

    public void deleteLayerFromCache() {
        TileCacheManager manager = TileCacheLocator.getManager();
        TileCache tileCache = manager.getTileCache(RasterLibrary.pathTileCache);
        if (this.tiledLayer != null) {
            tileCache.removeLayer(this.tiledLayer);
        }
    }

    public TileServer getTileServer() {
        return this.secondLevelTileServer;
    }

    public void setSecondLevelTileServer(TileServer tileServer) {
        this.secondLevelTileServer = tileServer;
    }

    public void setTileServer(Class<?> tileServer) throws InitializeException {
        TileDataParametersImpl par = new TileDataParametersImpl();
        par.setDataParameters((DataParameters)this.getDataParameters());
        par.setSecondLevelCache(true);
        TileProvider newProvider = null;
        newProvider = new TileProvider(par, null);
        newProvider.setProvider(this.provider);
        TileServer tServer = null;
        try {
            Constructor<?> constructor = tileServer.getConstructor(AbstractRasterProvider.class);
            Object[] args2 = new Object[]{newProvider};
            tServer = (TileServer)constructor.newInstance(args2);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        newProvider.setSecondLevelTileServer(tServer);
        if (!this.provider.getTileServer().getStruct().compare(tServer.getStruct())) {
            this.setProvider((RasterProvider)newProvider);
            this.tiledLayer = null;
        }
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }

    public String getFullName() {
        return this.provider.getFullName();
    }
}

