/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.kml;

import java.io.File;
import java.io.IOException;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;
import org.gvsig.gdal.prov.kml.KMLStoreParameters;

public class KMLFilesystemServerProvider
extends AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider {
    protected FilesystemServerExplorerProviderServices serverExplorer;

    public String getDataStoreProviderName() {
        return "KML";
    }

    public String getDescription() {
        return "KML file";
    }

    private String getFileExtension() {
        return ".kml";
    }

    public DataStoreParameters getParameters(File file) throws DataException {
        DataManager manager = DALLocator.getDataManager();
        KMLStoreParameters params = (KMLStoreParameters)manager.createStoreParameters(this.getDataStoreProviderName());
        params.setFile(file);
        return params;
    }

    public int getMode() {
        return 3;
    }

    public boolean accept(File file) {
        String pathname = file.getName().toLowerCase();
        return pathname.endsWith(this.getFileExtension());
    }

    public boolean canCreate() {
        return false;
    }

    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
        this.serverExplorer = serverExplorer;
    }

    public void remove(DataStoreParameters parameters) throws RemoveException {
        SimpleReaderStoreParameters params = (SimpleReaderStoreParameters)parameters;
        File file = params.getFile();
        if (!file.exists()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new FileNotFoundException(params.getFile()));
        }
        if (!file.delete()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new IOException());
        }
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return !((Object)((Object)this)).equals(resource);
    }

    public void resourceChanged(ResourceProvider resource) {
    }
}

