/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportbuilder;

import java.awt.Color;
import java.lang.reflect.Field;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportBorderBuilderView;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportBuilderView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.ColorPickerController;
import org.gvsig.tools.util.LabeledValueImpl;

public class DefaultJReportBorderBuilder
extends DefaultJReportBorderBuilderView
implements Component {
    private ReportBuilder.BorderBuilder borderBuilder;
    private ColorPickerController pickerBorderColor;

    public DefaultJReportBorderBuilder() {
        this.initComponents();
    }

    public void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.cboLineStyle.addItem(new LabeledValueImpl(i18n.getTranslation("_Style_dashed"), (Object)2));
        this.cboLineStyle.addItem(new LabeledValueImpl(i18n.getTranslation("_Style_dotted"), (Object)3));
        this.cboLineStyle.addItem(new LabeledValueImpl(i18n.getTranslation("_Style_double"), (Object)4));
        this.cboLineStyle.addItem(new LabeledValueImpl(i18n.getTranslation("_Style_solid"), (Object)1));
        this.cboLineStyle.addItem(new LabeledValueImpl(i18n.getTranslation("_Width_1point"), (Object)1));
        this.cboLineStyle.addItem(new LabeledValueImpl(i18n.getTranslation("_Width_2point"), (Object)2));
        this.cboLineStyle.addItem(new LabeledValueImpl(i18n.getTranslation("_Width_4point"), (Object)3));
        this.cboLineStyle.addItem(new LabeledValueImpl(i18n.getTranslation("_Width_none"), (Object)0));
        this.cboLineStyle.addItem(new LabeledValueImpl(i18n.getTranslation("_Width_thin"), (Object)4));
        this.pickerBorderColor = ToolsSwingLocator.getToolsSwingManager().createColorPickerController((JTextComponent)this.txtColor, this.btnColor);
        this.translate();
        this.clean();
    }

    public void clean() {
        this.txtWidth.setText("");
        this.pickerBorderColor.set((Object)Color.BLACK);
        this.cboLineStyle.setSelectedIndex(0);
    }

    public void fetch(ReportBuilder.BorderBuilder borderBuilder) {
        this.borderBuilder.lineStyle(((Integer)((LabeledValueImpl)this.cboLineStyle.getSelectedItem()).getValue()).intValue());
        this.borderBuilder.color((Color)this.pickerBorderColor.get());
        this.borderBuilder.width(Integer.parseInt(this.txtWidth.getText()));
        borderBuilder.copyFrom(this.borderBuilder);
    }

    public void put(ReportBuilder.BorderBuilder borderBuilder) {
        this.borderBuilder = borderBuilder;
        int rotation = this.borderBuilder.getLineStyle();
        ComboBoxModel model = this.cboLineStyle.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LabeledValueImpl object = (LabeledValueImpl)model.getElementAt(i);
            if (!((Integer)object.getValue()).equals(rotation)) continue;
            this.cboLineStyle.setSelectedIndex(i);
            break;
        }
        this.txtWidth.setText(String.valueOf(this.borderBuilder.getWidth()));
        this.pickerBorderColor.set((Object)this.borderBuilder.getColor());
    }

    public JComponent asJComponent() {
        return this;
    }

    private void translate() {
        Field[] fields;
        ToolsSwingManager toolsSwinManager = ToolsSwingLocator.getToolsSwingManager();
        Class<DefaultJReportBuilderView> theClass = DefaultJReportBuilderView.class;
        for (Field fieldView : fields = theClass.getDeclaredFields()) {
            String theName = fieldView.getName();
            try {
                if (!StringUtils.startsWithAny((CharSequence)theName, (CharSequence[])new CharSequence[]{"tab", "btn", "rdo", "chk", "lbl"}) || !JComponent.class.isAssignableFrom(fieldView.getType())) continue;
                try {
                    JComponent theComponent = (JComponent)fieldView.get(this);
                    toolsSwinManager.translate(theComponent);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

