/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportserver.viewcapture;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.lib.api.ReportViewCapture;
import org.gvsig.report.swing.api.JReportServer;
import org.gvsig.report.swing.impl.reportserver.viewcapture.ViewCaptureEditorController;
import org.gvsig.report.swing.impl.reportserver.viewcapture.ViewCaptureFilterController;
import org.gvsig.report.swing.impl.reportserver.viewcapture.ViewCaptureView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewCapture
extends ViewCaptureView
implements PropertiesPage {
    private static final Logger LOG = LoggerFactory.getLogger(ViewCapture.class);
    private ReportServer server;
    private ViewCaptureEditorController viewCaptureEditorController;
    private final PropertyChangeListener configChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ViewCapture.this.configChanged();
        }
    };
    private final JReportServer jreportServer;
    private boolean updateEnabled = true;

    public ViewCapture(JReportServer container) {
        this.jreportServer = container;
        this.initComponents();
    }

    private void configChanged() {
        this.put(this.server);
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnViewCapturesAdd);
        swingManager.translate((AbstractButton)this.btnViewCapturesApply);
        swingManager.translate((AbstractButton)this.btnViewCapturesCopyURL);
        swingManager.translate((AbstractButton)this.btnViewCapturesRemove);
        swingManager.translate(this.lblHeight);
        swingManager.translate(this.lblMargins);
        swingManager.translate(this.lblMeters);
        swingManager.translate(this.lblmm1);
        swingManager.translate(this.lblmm2);
        swingManager.translate(this.lblViewCapturesURL);
        swingManager.translate(this.lblViewCapturesName);
        swingManager.translate(this.lblView);
        swingManager.translate(this.lblWidth);
        swingManager.translate(this.tabViewCapture);
        swingManager.translate(this.lblReportDataSource);
        this.viewCaptureEditorController = new ViewCaptureEditorController(this.txtViewCapturesName, this.cboReportDataSource, this.cboViewCapturesViewName, this.txtViewCapturesURL, this.btnViewCapturesCopyURL, new ViewCaptureFilterController(this.cboZoomDataSet, this.txtZoomFilter, this.btnZoomFilter), new ViewCaptureFilterController(this.cboCenterDataSet, this.txtCenterFilter, this.btnCenterFilter), new ViewCaptureFilterController(this.cboSelectDataSet, this.txtSelectFilter, this.btnSelectFilter), this.txtMargins, this.txtWidth, this.txtHeight, this.cboResolution, this.btnViewCapturesApply);
        this.viewCaptureEditorController.setEnabled(false);
        this.viewCaptureEditorController.addItemChangedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCapture.this.fillViewCaptureList(ViewCapture.this.server.getConfig());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ViewCapture.this.fetch(ViewCapture.this.server);
            }
        });
        this.lstViewCaptures.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ViewCapture.this.doViewCaptureSeleccionChanged();
            }
        });
        this.btnViewCapturesAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCapture.this.doViewCaptureAdd();
            }
        });
        this.btnViewCapturesRemove.setEnabled(false);
        this.btnViewCapturesRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCapture.this.doViewCaptureRemove();
            }
        });
        this.setPreferredSize(new Dimension(300, 420));
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String iconName = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        if (theme.exists(iconName)) {
            return theme.get(iconName);
        }
        return super.loadImage(imageName);
    }

    private void doViewCaptureSeleccionChanged() {
        if (!this.updateEnabled) {
            return;
        }
        ReportViewCapture captureView = (ReportViewCapture)this.lstViewCaptures.getSelectedValue();
        if (captureView == null) {
            this.viewCaptureEditorController.clear();
            this.viewCaptureEditorController.setEnabled(false);
            this.btnViewCapturesRemove.setEnabled(false);
        } else {
            this.viewCaptureEditorController.set(captureView);
            this.viewCaptureEditorController.setEnabled(true);
            this.btnViewCapturesRemove.setEnabled(true);
        }
    }

    private void doViewCaptureRemove() {
        int index = this.lstViewCaptures.getSelectedIndex();
        ReportViewCapture viewCapture = (ReportViewCapture)this.lstViewCaptures.getSelectedValue();
        if (viewCapture == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.lstViewCaptures.getModel();
        model.removeElement(viewCapture);
        this.server.getConfig().getViewCaptures().remove(viewCapture);
        if (index >= model.size()) {
            index = model.size() - 1;
        }
        if (index >= 0) {
            this.lstViewCaptures.setSelectedIndex(index);
        }
    }

    private void doViewCaptureAdd() {
        List viewNames = this.server.getServices().getViewNames();
        if (CollectionUtils.isEmpty((Collection)viewNames)) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager manager = ToolsSwingLocator.getThreadSafeDialogsManager();
            manager.messageDialog(i18n.getTranslation("_At_least_one_view_in_the_project_is_required_to_perform_this_action"), i18n.getTranslation("_Warning"), 2);
            return;
        }
        ReportViewCapture viewCapture = ReportLocator.getReportManager().createViewCapture(this.server.getConfig());
        viewCapture.setView((String)viewNames.get(0));
        this.server.getConfig().getViewCaptures().add(viewCapture);
        this.lstViewCaptures.setSelectedValue(viewCapture, true);
        this.doViewCaptureSeleccionChanged();
    }

    public void setData(Object data) {
        this.setServer((ReportServer)data);
    }

    public void setServer(ReportServer server) {
        if (this.server != null) {
            this.server.getConfig().removePropertyChangeListener(this.configChangeListener);
        }
        this.server = server;
        if (server == null) {
            this.viewCaptureEditorController.setServer(null);
            this.clearComponents();
            this.setEnabledComponents(false);
        } else {
            this.fillViewCaptureList(server.getConfig());
            this.viewCaptureEditorController.setServer(server);
            this.setEnabledComponents(true);
            this.getConfig().addPropertyChangeListener(this.configChangeListener);
        }
    }

    public ReportServerConfig getConfig() {
        if (this.getServer() == null) {
            return null;
        }
        return this.getServer().getConfig();
    }

    private void clearComponents() {
        this.lstViewCaptures.setModel(new DefaultListModel());
        this.viewCaptureEditorController.clear();
    }

    private void setEnabledComponents(boolean enabled) {
        this.lstViewCaptures.setEnabled(enabled);
        this.btnViewCapturesAdd.setEnabled(enabled);
        ReportViewCapture captureView = (ReportViewCapture)this.lstViewCaptures.getSelectedValue();
        if (captureView == null) {
            this.viewCaptureEditorController.setEnabled(false);
            this.btnViewCapturesRemove.setEnabled(false);
        } else {
            this.viewCaptureEditorController.setEnabled(enabled);
            this.btnViewCapturesRemove.setEnabled(enabled);
        }
    }

    private synchronized void put(ReportServer server) {
        this.updateEnabled = false;
        try {
            if (this.server != null) {
                this.server.getConfig().removePropertyChangeListener(this.configChangeListener);
            }
            this.server = server;
            if (server == null) {
                this.clearComponents();
                this.setEnabledComponents(false);
            } else {
                this.fillViewCaptureList(server.getConfig());
                this.setEnabledComponents(true);
                this.getConfig().addPropertyChangeListener(this.configChangeListener);
            }
        }
        finally {
            this.updateEnabled = true;
        }
    }

    private void fetch(ReportServer server) {
        this.viewCaptureEditorController.fetch(null);
    }

    private void fillViewCaptureList(ReportServerConfig config) {
        int n = this.lstViewCaptures.getSelectedIndex();
        DefaultListModel<ReportViewCapture> model3 = new DefaultListModel<ReportViewCapture>();
        if (config.getViewCaptures() != null) {
            for (ReportViewCapture viewCapture : config.getViewCaptures()) {
                model3.addElement(viewCapture);
            }
        }
        this.lstViewCaptures.setModel(model3);
        if (model3.getSize() > n) {
            this.lstViewCaptures.setSelectedIndex(n);
        }
    }

    public ReportServer getServer() {
        return this.server;
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_View_capture");
    }

    public int getPriority() {
        return 700;
    }

    public boolean whenAccept() {
        return this.whenApply();
    }

    public boolean whenApply() {
        this.fetch(this.server);
        return true;
    }

    public boolean whenCancel() {
        return true;
    }
}

