/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportserver.viewcapture;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.lib.api.ReportViewCapture;
import org.gvsig.report.swing.impl.reportserver.viewcapture.ViewCaptureFilterController;
import org.gvsig.report.swing.impl.utils.Clipboard;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.documentfilters.IntegerDocumentFilter;

public class ViewCaptureEditorController {
    private ReportServer server;
    private ReportViewCapture current;
    private final ActionListenerSupport itemChangedSupport;
    private final JComboBox cboViewName;
    private final JTextField txtName;
    private final JTextField txtFullURL;
    private final JButton btnCopyFullURL;
    private final ViewCaptureFilterController zoomFilter;
    private final ViewCaptureFilterController centerFilter;
    private final ViewCaptureFilterController selectFilter;
    private final JTextField txtMargins;
    private final JTextField txtWidth;
    private final JTextField txtHeight;
    private final JComboBox cboResolution;
    private boolean changeEventsEnableds = true;
    private final JButton btnApply;
    private final JComboBox cboDatasetName;

    public ViewCaptureEditorController(JTextField txtName, JComboBox cboDatasetName, JComboBox cboViewName, JTextField txtFullURL, JButton btnCopyFullURL, ViewCaptureFilterController zoomFilter, ViewCaptureFilterController centerFilter, ViewCaptureFilterController selectFilter, JTextField txtMargins, JTextField txtWidth, JTextField txtHeight, JComboBox cboResolution, JButton btnApply) {
        this.txtName = txtName;
        this.cboDatasetName = cboDatasetName;
        this.cboViewName = cboViewName;
        this.txtFullURL = txtFullURL;
        this.btnCopyFullURL = btnCopyFullURL;
        this.zoomFilter = zoomFilter;
        this.centerFilter = centerFilter;
        this.selectFilter = selectFilter;
        this.txtMargins = txtMargins;
        this.txtWidth = txtWidth;
        this.txtHeight = txtHeight;
        this.cboResolution = cboResolution;
        this.btnApply = btnApply;
        this.itemChangedSupport = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
        this.initComponents();
    }

    public ReportServer getServer() {
        return this.server;
    }

    public ReportServerConfig getConfig() {
        if (this.server == null) {
            return null;
        }
        return this.server.getConfig();
    }

    public void setServer(ReportServer server) {
        this.clear();
        this.server = server;
        this.zoomFilter.setServer(server);
        this.centerFilter.setServer(server);
        this.selectFilter.setServer(server);
    }

    public void addItemChangedListener(ActionListener itemChangedListener) {
        this.itemChangedSupport.addActionListener(itemChangedListener);
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.addClearButton((JTextComponent)this.txtName);
        toolsSwingManager.addClearButton((JTextComponent)this.txtFullURL);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtName);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtFullURL);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtMargins);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtWidth);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtHeight);
        IntegerDocumentFilter.install((JTextField)this.txtMargins);
        IntegerDocumentFilter.install((JTextField)this.txtWidth);
        IntegerDocumentFilter.install((JTextField)this.txtHeight);
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCaptureEditorController.this.doApply();
            }
        });
        this.btnCopyFullURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCaptureEditorController.this.doCopyFullURL();
            }
        });
        this.zoomFilter.addItemChangedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCaptureEditorController.this.fetch(null);
                ViewCaptureEditorController.this.fireItemChanged();
            }
        });
        this.centerFilter.addItemChangedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCaptureEditorController.this.fetch(null);
                ViewCaptureEditorController.this.fireItemChanged();
            }
        });
        this.selectFilter.addItemChangedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCaptureEditorController.this.fetch(null);
                ViewCaptureEditorController.this.fireItemChanged();
            }
        });
        this.cboDatasetName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ViewCaptureEditorController.this.doUpdateCurrentFunctionStore((String)ViewCaptureEditorController.this.cboDatasetName.getSelectedItem());
                }
            }
        });
        this.txtFullURL.setEditable(false);
        this.clear();
    }

    private void fireItemChanged() {
        if (this.changeEventsEnableds) {
            this.itemChangedSupport.fireActionEvent(null);
        }
    }

    private void doUpdateCurrentFunctionStore(String datasetName) {
        ReportDataSet dataset;
        FeatureStore store = null;
        if (!StringUtils.isBlank((CharSequence)datasetName) && (dataset = this.getConfig().getDataset(datasetName)) != null) {
            store = dataset.getStore();
        }
        this.centerFilter.getExpressionBuilderConfig().setProperty("ReportValueFunction.store", store);
        this.zoomFilter.getExpressionBuilderConfig().setProperty("ReportValueFunction.store", (Object)store);
        this.selectFilter.getExpressionBuilderConfig().setProperty("ReportValueFunction.store", (Object)store);
    }

    private void doApply() {
        this.fetch(this.current);
    }

    public void clear() {
        if (this.current != null) {
            this.fetch(this.current);
        }
        this.cboDatasetName.setModel(new DefaultComboBoxModel());
        this.txtName.setText("");
        this.cboViewName.setModel(new DefaultComboBoxModel());
        this.txtFullURL.setText("");
        this.txtMargins.setText("");
        this.zoomFilter.clear();
        this.centerFilter.clear();
        this.current = null;
    }

    public void setEnabled(boolean enabled) {
        this.cboViewName.setEnabled(enabled);
        this.cboDatasetName.setEnabled(enabled);
        this.btnCopyFullURL.setEnabled(enabled);
        this.txtFullURL.setEnabled(enabled);
        this.centerFilter.setEnabled(enabled);
        this.zoomFilter.setEnabled(enabled);
        this.selectFilter.setEnabled(enabled);
        this.txtMargins.setEditable(false);
        this.txtWidth.setEditable(enabled);
        this.txtHeight.setEditable(enabled);
        this.cboResolution.setEnabled(enabled);
        this.btnApply.setEnabled(enabled);
    }

    public ReportViewCapture getCurrent() {
        return this.current;
    }

    public void fetch(ReportViewCapture viewCapture) {
        ReportViewCapture x = viewCapture;
        if (x == null) {
            if (this.current == null) {
                return;
            }
            x = this.current;
        }
        x.setName(this.txtName.getText());
        x.setReportDataSet((String)this.cboDatasetName.getSelectedItem());
        x.setView((String)this.cboViewName.getSelectedItem());
        x.setMargins(IntegerDocumentFilter.getValue((JTextField)this.txtMargins));
        x.getDimensions().width = IntegerDocumentFilter.getValue((JTextField)this.txtWidth);
        x.getDimensions().height = IntegerDocumentFilter.getValue((JTextField)this.txtHeight);
        try {
            x.setResolution(NumberUtils.toInt((String)Objects.toString(this.cboResolution.getSelectedItem(), "72").split("[^0-9]+")[0]));
        }
        catch (NumberFormatException ex) {
            x.setResolution(0);
        }
        this.zoomFilter.fetch(x.getZoomFilter());
        this.centerFilter.fetch(x.getCenterFilter());
        this.selectFilter.fetch(x.getSelectionFilter());
        if (viewCapture != this.current) {
            this.itemChangedSupport.fireActionEvent(null);
        }
        this.txtFullURL.setText(this.getServer().getURL(x.getFullURLPath()).toString());
        this.txtFullURL.setCaretPosition(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(ReportViewCapture viewCapture) {
        if (this.getConfig() == null) {
            throw new IllegalStateException("The config attribute can't be initialized.");
        }
        boolean saveChangeEventsEnableds = this.changeEventsEnableds;
        this.changeEventsEnableds = false;
        try {
            if (viewCapture == null) {
                this.setEnabled(false);
                this.clear();
                return;
            }
            if (this.current != null) {
                this.fetch(this.current);
            }
            this.txtName.setText(viewCapture.getName());
            this.txtMargins.setText(String.valueOf(viewCapture.getMargins()));
            this.txtWidth.setText(String.valueOf(viewCapture.getDimensions().width));
            this.txtHeight.setText(String.valueOf(viewCapture.getDimensions().height));
            this.cboResolution.setSelectedItem(String.valueOf(viewCapture.getResolution()));
            DefaultComboBoxModel<String> viewsModel = new DefaultComboBoxModel<String>();
            List viewNames = this.getServer().getServices().getViewNames();
            if (!CollectionUtils.isEmpty((Collection)viewNames)) {
                for (String viewName : viewNames) {
                    viewsModel.addElement(viewName);
                }
            }
            this.cboViewName.setModel(viewsModel);
            this.cboViewName.setSelectedItem(viewCapture.getView());
            DefaultComboBoxModel<String> datasetsModel = new DefaultComboBoxModel<String>();
            for (ReportDataSet dataset : this.getConfig().getDatasets()) {
                datasetsModel.addElement(dataset.getName());
            }
            this.cboDatasetName.setModel(datasetsModel);
            this.cboDatasetName.setSelectedItem(viewCapture.getReportDataSet());
            this.doUpdateCurrentFunctionStore(viewCapture.getReportDataSet());
            this.zoomFilter.set(viewCapture.getZoomFilter());
            this.centerFilter.set(viewCapture.getCenterFilter());
            this.selectFilter.set(viewCapture.getSelectionFilter());
            this.txtFullURL.setText(Objects.toString(this.getServer().getURL(viewCapture.getFullURLPath()), ""));
            this.txtFullURL.setCaretPosition(0);
            this.setEnabled(true);
            this.current = viewCapture;
        }
        finally {
            this.changeEventsEnableds = saveChangeEventsEnableds;
        }
    }

    private void doCopyFullURL() {
        String s = this.txtFullURL.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            return;
        }
        Clipboard.copy("\"" + s + "\"");
    }
}

