/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportserver.viewcapture.reportvalue;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.report.swing.impl.reportserver.viewcapture.reportvalue.ReportValueAditionalPanelView;
import org.gvsig.tools.swing.api.Component;

public class ReportValueAditionalPanel
extends ReportValueAditionalPanelView
implements Component {
    public static final String STORE_PROPERTY = "ReportValueFunction.store";
    private final JExpressionBuilder expressionBuilder;
    private AttributeDescriptorPickerController fieldPicker;

    public ReportValueAditionalPanel(JExpressionBuilder expressionBuilder) {
        this.expressionBuilder = expressionBuilder;
        this.initComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        FeatureStore store = this.getFeatureStore();
        this.txtPreview.setEditable(false);
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        this.fieldPicker = dataSwingManager.createAttributeDescriptorPickerController(this.lstFields);
        if (store == null) {
            this.btnInsertFunction.setEnabled(false);
            this.fieldPicker.setEnabled(false);
        } else {
            try {
                this.fieldPicker.setFeatureType(store.getDefaultFeatureType());
            }
            catch (DataException dataException) {
                // empty catch block
            }
            this.lstFields.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    ReportValueAditionalPanel.this.doUpdatePreview();
                }
            });
            this.btnInsertFunction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportValueAditionalPanel.this.doInsertFunction();
                }
            });
            this.btnInsertFunction.setEnabled(true);
            this.fieldPicker.setEnabled(true);
            this.doUpdatePreview();
        }
    }

    private void doUpdatePreview() {
        FeatureAttributeDescriptor descriptor = (FeatureAttributeDescriptor)this.fieldPicker.get();
        if (descriptor == null) {
            this.btnInsertFunction.setEnabled(false);
            this.txtPreview.setText("");
            return;
        }
        String template = "REPORT_VALUE('" + descriptor.getName() + "')";
        this.txtPreview.setText(template);
        this.txtPreview.setCaretPosition(0);
        this.btnInsertFunction.setEnabled(true);
    }

    private void doInsertFunction() {
        this.expressionBuilder.insertText(this.txtPreview.getText());
    }

    private FeatureStore getFeatureStore() {
        FeatureStore store = (FeatureStore)this.expressionBuilder.getConfig().getProperty(STORE_PROPERTY);
        return store;
    }
}

