/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.gui.beans.DefaultBean;
import org.gvsig.gui.beans.Pager;
import org.gvsig.gui.beans.listeners.BeanListener;
import org.gvsig.raster.wms.io.time.RemoteTimeDimension;

public class DimensionPanel
extends DefaultBean {
    private static final long serialVersionUID = 1L;
    private static final int SINGLE_VALUE = 0;
    private static final int MULTIPLE_VALUE = 1;
    private static final int INTERVAL = 2;
    private final String bgColor0 = "\"#FEEDD6\"";
    private final String bgColor2 = "\"#F2FEFF\"";
    private Pager pager = null;
    private JPanel valueEditionPanel = null;
    private JRadioButton rdBtnSingle = null;
    private JRadioButton rdBtnMultiple = null;
    private JRadioButton rdBtnInterval = null;
    private JButton btnAdd = null;
    private JTextField txt = null;
    private JScrollPane scrlDimension = null;
    private JList lstDimensions = null;
    private JPanel editionPanel = null;
    private JScrollPane scrDimInfo = null;
    private JEditorPane infoEditor = null;
    private JPanel valuePanel = null;
    private JButton btnSet = null;
    private JButton btnClear = null;
    private JLabel lblValue = null;
    private JLabel lblValueText = null;
    private int currentSelectedValue;
    private int mode;
    private boolean incomplete = true;
    private boolean userEdits = false;
    private RemoteTimeDimension[] dim;
    private RemoteTimeDimension currentDimension;
    private Hashtable<String, Value> settings = new Hashtable();
    private Vector<Integer> indices = new Vector();

    public DimensionPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)((Object)this), (String)"dimension"), 0, 0, null, null));
        this.add(this.getValuePanel(), "North");
        this.add(this.getEditionPanel(), "Center");
    }

    private Pager getJPanel() {
        if (this.pager == null) {
            this.pager = new Pager(Pager.HORIZONTAL);
            this.pager.setBounds(5, 20, 240, 50);
            this.pager.addListener(new BeanListener(){

                public void beanValueChanged(Object value) {
                    DimensionPanel.this.currentSelectedValue = (Integer)value;
                    DimensionPanel.this.lblValueText.setText(DimensionPanel.this.currentDimension.valueAt(DimensionPanel.this.currentSelectedValue));
                }
            });
        }
        return this.pager;
    }

    private JPanel getJPanel1() {
        if (this.valueEditionPanel == null) {
            ButtonGroup group = new ButtonGroup();
            this.lblValueText = new JLabel();
            this.lblValueText.setBounds(54, 4, 190, 20);
            this.lblValueText.setText("");
            this.lblValue = new JLabel();
            this.lblValue.setBounds(7, 4, 45, 20);
            this.lblValue.setText(PluginServices.getText((Object)((Object)this), (String)"value") + ":");
            this.lblValue.setFont(new Font("MS Sans Serif", 1, 11));
            this.valueEditionPanel = new JPanel();
            this.valueEditionPanel.setLayout(null);
            this.valueEditionPanel.setBounds(228, 12, 245, 214);
            this.valueEditionPanel.add((Component)this.getRdBtnSingleValue(), null);
            this.valueEditionPanel.add((Component)this.getRdBtnMultipleValue(), null);
            this.valueEditionPanel.add((Component)this.getRdBtnInterval(), null);
            this.valueEditionPanel.add((Component)this.getBtnAdd(), null);
            this.valueEditionPanel.add((Component)this.getTxt(), null);
            this.valueEditionPanel.add((Component)this.getBtnSet(), null);
            this.valueEditionPanel.add((Component)this.getBtnClear(), null);
            this.valueEditionPanel.add((Component)this.getJPanel(), null);
            this.valueEditionPanel.add((Component)this.lblValue, null);
            this.valueEditionPanel.add((Component)this.lblValueText, null);
            group.add(this.getRdBtnSingleValue());
            group.add(this.getRdBtnMultipleValue());
            group.add(this.getRdBtnInterval());
        }
        return this.valueEditionPanel;
    }

    private JRadioButton getRdBtnSingleValue() {
        if (this.rdBtnSingle == null) {
            this.rdBtnSingle = new JRadioButton();
            this.rdBtnSingle.setBounds(7, 70, 180, 20);
            this.rdBtnSingle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DimensionPanel.this.mode = 0;
                    DimensionPanel.this.txt.setText("");
                }
            });
            this.rdBtnSingle.setText(PluginServices.getText((Object)((Object)this), (String)"single_value"));
        }
        return this.rdBtnSingle;
    }

    private JRadioButton getRdBtnMultipleValue() {
        if (this.rdBtnMultiple == null) {
            this.rdBtnMultiple = new JRadioButton();
            this.rdBtnMultiple.setBounds(7, 89, 180, 20);
            this.rdBtnMultiple.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DimensionPanel.this.mode = 1;
                    DimensionPanel.this.txt.setText("");
                }
            });
            this.rdBtnMultiple.setText(PluginServices.getText((Object)((Object)this), (String)"multiple_value"));
        }
        return this.rdBtnMultiple;
    }

    private JRadioButton getRdBtnInterval() {
        if (this.rdBtnInterval == null) {
            this.rdBtnInterval = new JRadioButton();
            this.rdBtnInterval.setBounds(7, 108, 180, 20);
            this.rdBtnInterval.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DimensionPanel.this.mode = 2;
                    DimensionPanel.this.txt.setText("");
                }
            });
            this.rdBtnInterval.setText(PluginServices.getText((Object)((Object)this), (String)"interval"));
        }
        return this.rdBtnInterval;
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            this.btnAdd.setBounds(7, 130, 110, 20);
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DimensionPanel.this.execute("add");
                }
            });
            this.btnAdd.setText(PluginServices.getText((Object)((Object)this), (String)"add"));
        }
        return this.btnAdd;
    }

    private boolean execute(String actionCommand) {
        boolean b = true;
        if (actionCommand.equals("add")) {
            if (this.lblValueText.getText() != null && !this.lblValueText.equals("")) {
                Integer newIndex = new Integer(this.currentSelectedValue);
                switch (this.mode) {
                    case 0: {
                        this.txt.setText(this.lblValueText.getText());
                        this.indices.clear();
                        this.indices.add(newIndex);
                        break;
                    }
                    case 1: {
                        String oldText = this.txt.getText();
                        if (oldText == null || oldText.equals("")) {
                            this.txt.setText(this.lblValueText.getText());
                        } else {
                            this.txt.setText(oldText + "," + this.lblValueText.getText());
                        }
                        this.indices.add(newIndex);
                        break;
                    }
                    case 2: {
                        if (this.txt.getText().indexOf("/") == -1) {
                            this.txt.setText(this.lblValueText.getText() + "/");
                            this.indices.add(newIndex);
                            this.indices.add(newIndex);
                            this.incomplete = true;
                            break;
                        }
                        if (!this.incomplete) break;
                        this.txt.setText(this.txt.getText() + this.lblValueText.getText());
                        this.indices.set(1, newIndex);
                        this.incomplete = false;
                    }
                }
            }
        } else if (actionCommand.equals("clear")) {
            this.txt.setText("");
            this.incomplete = true;
            this.userEdits = false;
            this.indices.clear();
            if (this.currentDimension != null) {
                this.settings.remove(this.currentDimension.getName());
            }
            this.callValueChanged(this.getDimensions());
        } else if (actionCommand.equals("set")) {
            Integer[] val;
            int type;
            if (this.userEdits) {
                type = 1;
                val = this.txt.getText();
            } else {
                type = 0;
                val = this.indices.toArray(new Integer[0]);
            }
            if (type == 1 && !((String)val).equals("") || type == 0 && val.length > 0) {
                this.settings.put(this.currentDimension.getName(), new Value(type, this.mode, val, this.currentDimension));
            }
            this.callValueChanged(this.getDimensions());
        }
        this.refreshInfo();
        return b;
    }

    private void refreshInfo() {
        String font = "Arial";
        String tableRows = "";
        boolean switchColor = false;
        for (String name : this.settings.keySet()) {
            String dimValue;
            Value val = this.settings.get(name);
            if (val != null) {
                if (val.type == 0) {
                    Integer[] ints = val.getIndexes();
                    String separator = val.getMode() == 1 ? "," : "/";
                    String s = "";
                    for (int j = 0; j < ints.length; ++j) {
                        s = s + this.currentDimension.valueAt(ints[j].intValue());
                        if (j >= ints.length - 1) continue;
                        s = s + separator;
                    }
                    dimValue = s;
                } else {
                    dimValue = val.getExpr();
                }
            } else {
                dimValue = PluginServices.getText((Object)((Object)this), (String)"none_selected");
            }
            RemoteTimeDimension d = val.getOwner();
            String unitSymbol = d != null ? d.getUnitSymbol() : null;
            String unit = d != null ? d.getUnit() : null;
            unit = unit != null && !unit.equals("") ? PluginServices.getText((Object)((Object)this), (String)"in") + " " + unit : "";
            unitSymbol = unitSymbol != null && !unitSymbol.equals("") ? " (" + unitSymbol + ")" : "";
            String color = switchColor ? "\"#FEEDD6\"" : "\"#F2FEFF\"";
            tableRows = tableRows + "  <tr valign=\"top\" bgcolor=" + color + ">" + "    <td width=\"92\" height=\"18\" bgcolor=\"#D6D6D6\" align=\"right\"><font face=\"" + font + "\" size=\"3\">" + "\t\t<b>" + name + "</b>" + " " + unit + unitSymbol + "</font>" + "\t </td>" + "    <td width=\"268\"><font face=\"" + font + "\" size=\"3\">" + dimValue + "</font></td>" + "  </tr>";
            switchColor = !switchColor;
        }
        String html = "<html><body><table align=\"center\" width=\"437\" height=\"156\" border=\"0\" cellpadding=\"4\" cellspacing=\"4\">" + tableRows + "</table>" + "</body>" + "</html>";
        this.getInfoEditor().setContentType("text/html");
        this.getInfoEditor().setText(html);
    }

    private JTextField getTxt() {
        if (this.txt == null) {
            this.txt = new JTextField();
            this.txt.setBounds(7, 162, 234, 22);
            this.txt.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    DimensionPanel.this.userEdits = true;
                }
            });
        }
        return this.txt;
    }

    private JScrollPane getScrlDimension() {
        if (this.scrlDimension == null) {
            this.scrlDimension = new JScrollPane();
            this.scrlDimension.setBounds(5, 17, 220, 209);
            this.scrlDimension.setViewportView(this.getLstDimensions());
        }
        return this.scrlDimension;
    }

    private JList getLstDimensions() {
        if (this.lstDimensions == null) {
            this.lstDimensions = new JList();
            this.lstDimensions.setSelectionMode(0);
            this.lstDimensions.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    try {
                        if (DimensionPanel.this.currentDimension != DimensionPanel.this.dim[DimensionPanel.this.lstDimensions.getSelectedIndex()]) {
                            DimensionPanel.this.indices.clear();
                            DimensionPanel.this.currentDimension = DimensionPanel.this.dim[DimensionPanel.this.lstDimensions.getSelectedIndex()];
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    DimensionPanel.this.refreshEditionPanel();
                }
            });
        }
        return this.lstDimensions;
    }

    protected void refreshEditionPanel() {
        Value val = this.settings.get(this.currentDimension.getName());
        if (val == null) {
            this.lblValueText.setText(this.currentDimension.valueAt(0));
            this.getRdBtnSingleValue().setEnabled(true);
        } else {
            String separator;
            int m = val.getMode();
            if (m == 1) {
                this.getRdBtnMultipleValue().setSelected(true);
                separator = ",";
            } else {
                separator = "/";
                if (m == 0) {
                    this.getRdBtnSingleValue().setSelected(true);
                } else {
                    this.getRdBtnInterval().setSelected(true);
                }
            }
            if (val.type == 1) {
                this.txt.setText(val.getExpr());
            } else {
                Integer[] ints = val.getIndexes();
                String s = "";
                for (int i = 0; i < ints.length; ++i) {
                    s = s + this.currentDimension.valueAt(ints[i].intValue());
                    if (i >= ints.length - 1) continue;
                    s = s + separator;
                }
                this.txt.setText(s);
            }
        }
        this.pager.setItemCount(this.currentDimension.valueCount());
        this.pager.setValue(0, true);
    }

    private JPanel getEditionPanel() {
        if (this.editionPanel == null) {
            this.editionPanel = new JPanel();
            this.editionPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)((Object)this), (String)"settings_editor"), 0, 0, null, null));
            this.editionPanel.setLayout(new BorderLayout());
            this.editionPanel.setBounds(9, 150, 480, 232);
            this.editionPanel.add((Component)this.getJPanel1(), "North");
            this.editionPanel.add((Component)this.getScrlDimension(), "Center");
        }
        return this.editionPanel;
    }

    private JScrollPane getScrDimInfo() {
        if (this.scrDimInfo == null) {
            this.scrDimInfo = new JScrollPane();
            this.scrDimInfo.setBounds(6, 17, 466, 113);
            this.scrDimInfo.setViewportView(this.getInfoEditor());
        }
        return this.scrDimInfo;
    }

    private JEditorPane getInfoEditor() {
        if (this.infoEditor == null) {
            this.infoEditor = new JEditorPane();
            this.infoEditor.setEditable(false);
        }
        return this.infoEditor;
    }

    private JPanel getValuePanel() {
        if (this.valuePanel == null) {
            this.valuePanel = new JPanel();
            this.valuePanel.setLayout(new BorderLayout());
            this.valuePanel.setBounds(8, 17, 480, 137);
            this.valuePanel.add((Component)this.getScrDimInfo(), "Center");
            this.valuePanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)((Object)this), (String)"settings"), 0, 0, null, null));
        }
        return this.valuePanel;
    }

    private JButton getBtnSet() {
        if (this.btnSet == null) {
            this.btnSet = new JButton();
            this.btnSet.setBounds(7, 188, 110, 20);
            this.btnSet.setText(PluginServices.getText((Object)((Object)this), (String)"set"));
            this.btnSet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DimensionPanel.this.execute("set");
                }
            });
        }
        return this.btnSet;
    }

    private JButton getBtnClear() {
        if (this.btnClear == null) {
            this.btnClear = new JButton();
            this.btnClear.setBounds(107, 130, 110, 20);
            this.btnClear.setText(PluginServices.getText((Object)((Object)this), (String)"clear"));
            this.btnClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DimensionPanel.this.execute("clear");
                }
            });
        }
        return this.btnClear;
    }

    public void addDimension(RemoteTimeDimension d) throws IllegalArgumentException {
        int i;
        d.compile();
        if (this.dim == null) {
            this.dim = new RemoteTimeDimension[]{d};
        } else {
            Vector<RemoteTimeDimension> v = new Vector<RemoteTimeDimension>();
            for (i = 0; i < this.dim.length; ++i) {
                v.add(this.dim[i]);
            }
            if (v.contains(d)) {
                return;
            }
            v.add(d);
            this.dim = v.toArray(new RemoteTimeDimension[0]);
        }
        String[] texts = new String[this.dim.length];
        for (i = 0; i < texts.length; ++i) {
            texts[i] = this.dim[i].getName();
        }
        this.getLstDimensions().setListData(texts);
        this.refreshInfo();
    }

    public Vector<String> getDimensions() {
        if (this.settings.isEmpty()) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (String key : this.settings.keySet()) {
            Value val = this.settings.get(key);
            if (val.getType() == 1) {
                v.add(key + "=" + (String)val.getValue());
                continue;
            }
            String values = "";
            String separator = val.getMode() == 1 ? "," : "/";
            Integer[] indexes = val.getIndexes();
            for (int j = 0; j < indexes.length; ++j) {
                values = values + val.getOwner().valueAt(indexes[j].intValue());
                if (j >= indexes.length - 1) continue;
                values = values + separator;
            }
            v.add(key + "=" + values);
        }
        return v;
    }

    public void setDimensionValue(String name, String value) {
        for (int i = 0; this.dim != null && i < this.dim.length; ++i) {
            if (!this.dim[i].getName().equals(name)) continue;
            int myMode = value.indexOf(",") != -1 ? 1 : (value.indexOf("/") != -1 ? 2 : 0);
            Value val = new Value(1, myMode, value, null);
            this.settings.put(name, val);
        }
        this.refreshInfo();
    }

    private class Value {
        public static final int INDEXES = 0;
        public static final int EXPR = 1;
        private int type;
        private int valueMode;
        private Object value;
        private RemoteTimeDimension owner;

        public Value(int type, int mode, Object value, RemoteTimeDimension owner) {
            this.type = type;
            this.valueMode = mode;
            this.owner = owner;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public Integer[] getIndexes() {
            return (Integer[])this.value;
        }

        public String getExpr() {
            return (String)this.value;
        }

        public int getMode() {
            return this.valueMode;
        }

        public Object getValue() {
            return this.value;
        }

        public RemoteTimeDimension getOwner() {
            return this.owner;
        }
    }
}

