/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.gui.panel;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gvsig.raster.wms.io.RemoteWMSStyle;
import org.gvsig.raster.wms.io.WMSLayerNode;

class StyleTreeModel
implements TreeModel {
    private WMSLayerNode root;
    private ArrayList<WMSLayerNode> layers = new ArrayList();

    public StyleTreeModel(WMSLayerNode root) {
        this.root = root;
    }

    public boolean isSelected(RemoteWMSStyle style) {
        return style.getParent().getSelectedStyle().equals(style);
    }

    public Vector<String> getStyleSelectionTitles() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.layers.size(); ++i) {
            WMSLayerNode layer = this.layers.get(i);
            RemoteWMSStyle sty = layer.getSelectedStyle();
            if (sty == null) {
                v.add("");
                continue;
            }
            v.add(sty.getTitle());
        }
        return v;
    }

    public void setStylesSelection(Vector styleNames) {
        for (int i = 0; i < this.layers.size(); ++i) {
            WMSLayerNode layer = this.layers.get(i);
            for (int j = 0; j < layer.getStyles().size(); ++j) {
                RemoteWMSStyle sty = (RemoteWMSStyle)layer.getStyles().get(j);
                if (!sty.getName().equals((String)styleNames.get(i))) continue;
                layer.setSelectedStyleByIndex(j);
            }
        }
    }

    public boolean addLayerBranch(WMSLayerNode node) {
        this.layers.add(node);
        if (node.getStyles() == null || node.getStyles().size() == 0) {
            return false;
        }
        for (int i = 0; i < node.getStyles().size(); ++i) {
            ((RemoteWMSStyle)node.getStyles().get(i)).setParent(node);
        }
        ((WMSLayerNode)this.getRoot()).getChildren().add(node);
        return true;
    }

    protected void setSelectedLeaf(TreePath selectionPath) {
        Object[] objects;
        Object item;
        if (selectionPath != null && this.isLeaf(item = (objects = selectionPath.getPath())[objects.length - 1])) {
            RemoteWMSStyle style = (RemoteWMSStyle)item;
            WMSLayerNode layer = style.getParent();
            for (int i = 0; i < layer.getStyles().size(); ++i) {
                RemoteWMSStyle sty = (RemoteWMSStyle)layer.getStyles().get(i);
                if (!sty.getName().equals(style.getName())) continue;
                layer.setSelectedStyleByIndex(i);
                return;
            }
        }
    }

    @Override
    public Object getRoot() {
        if (this.root == null) {
            this.root = new WMSLayerNode();
            this.root.setParent(null);
        }
        return this.root;
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        count = parent == this.root ? ((WMSLayerNode)parent).getChildren().size() : ((WMSLayerNode)parent).getStyles().size();
        return count;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof RemoteWMSStyle;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof RemoteWMSStyle) {
            return null;
        }
        if (parent == this.root) {
            return ((WMSLayerNode)parent).getChildren().get(index);
        }
        return ((WMSLayerNode)parent).getStyles().get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof RemoteWMSStyle) {
            return -1;
        }
        WMSLayerNode l = (WMSLayerNode)parent;
        if (l.getParent() == null) {
            for (int i = 0; i < l.getChildren().size(); ++i) {
                if (!((WMSLayerNode)l.getChildren().get(i)).equals(child)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < l.getStyles().size(); ++i) {
                if (!((WMSLayerNode)l.getChildren().get(i)).equals(child)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

