/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.DefaultViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;

public class WebMapContextFileChooserAccessory
extends JPanel {
    public static int NEW_VIEW = -1;
    public static int CURRENT_VIEW = -1;
    public static int USERS_VIEW_SELECTION = -1;
    private JComboBox cmbMode = null;
    private JComboBox cmbViews = null;
    private JLabel lblExplain = null;
    private String currentView = null;

    public WebMapContextFileChooserAccessory(String currentViewName) {
        this.currentView = currentViewName;
        this.initialize();
    }

    private void initialize() {
        this.lblExplain = new JLabel();
        this.lblExplain.setBounds(25, 52, 268, 55);
        this.lblExplain.setText(PluginServices.getText((Object)this, (String)"html_in_a_new_view"));
        this.setLayout(null);
        this.setSize(315, 240);
        this.setPreferredSize(new Dimension(315, 72));
        this.add((Component)this.getCmbViews(), null);
        this.add((Component)this.lblExplain, null);
        this.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"open_layers_as"), 0, 0, null, null));
        this.add((Component)this.getCmbMode(), null);
    }

    private JComboBox getCmbMode() {
        if (this.cmbMode == null) {
            this.cmbMode = new JComboBox();
            this.cmbMode.setBounds(25, 26, 268, 20);
            this.cmbMode.removeAllItems();
            this.cmbMode.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WebMapContextFileChooserAccessory.this.cmbViews.setVisible(false);
                    if (WebMapContextFileChooserAccessory.this.cmbMode.getSelectedIndex() == NEW_VIEW) {
                        WebMapContextFileChooserAccessory.this.lblExplain.setText(PluginServices.getText((Object)this, (String)"html_in_a_new_view"));
                    } else if (WebMapContextFileChooserAccessory.this.cmbMode.getSelectedIndex() == CURRENT_VIEW) {
                        WebMapContextFileChooserAccessory.this.lblExplain.setText(PluginServices.getText((Object)this, (String)"html_in_the_current_view"));
                    } else if (WebMapContextFileChooserAccessory.this.cmbMode.getSelectedIndex() == USERS_VIEW_SELECTION) {
                        WebMapContextFileChooserAccessory.this.lblExplain.setText(PluginServices.getText((Object)this, (String)"html_in_other_view"));
                        WebMapContextFileChooserAccessory.this.cmbViews.setVisible(true);
                    }
                }
            });
            this.cmbMode.addItem(PluginServices.getText((Object)this, (String)"a_new_view"));
            if (this.currentView != null) {
                this.cmbMode.addItem(PluginServices.getText((Object)this, (String)"layers_in_the_current_view") + ": " + this.currentView);
                CURRENT_VIEW = this.cmbMode.getItemCount() - 1;
                this.cmbMode.setSelectedIndex(CURRENT_VIEW);
            }
            if (this.getCmbViews().getItemCount() > 0) {
                this.cmbMode.addItem(PluginServices.getText((Object)this, (String)"layers_in_other_view"));
                USERS_VIEW_SELECTION = this.cmbMode.getItemCount() - 1;
            }
        }
        return this.cmbMode;
    }

    public void setCurrentView(AbstractViewPanel v) {
        this.currentView = v.getName();
    }

    public DefaultViewDocument getSelectedView() {
        String viewName = null;
        if (this.getCmbMode().getSelectedIndex() == NEW_VIEW) {
            return null;
        }
        if (this.getCmbMode().getSelectedIndex() == CURRENT_VIEW) {
            viewName = this.currentView;
        } else if (this.getCmbMode().getSelectedIndex() == USERS_VIEW_SELECTION) {
            viewName = (String)this.getCmbViews().getSelectedItem();
        }
        return (DefaultViewDocument)ProjectManager.getInstance().getCurrentProject().getDocument(viewName, ViewManager.TYPENAME);
    }

    public int getOption() {
        return this.cmbMode.getSelectedIndex();
    }

    private JComboBox getCmbViews() {
        if (this.cmbViews == null) {
            this.cmbViews = new JComboBox();
            this.cmbViews.setBounds(25, 114, 266, 20);
            List views = ProjectManager.getInstance().getCurrentProject().getDocuments(ViewManager.TYPENAME);
            for (Document v : views) {
                this.cmbViews.addItem(v.getName());
            }
        }
        return this.cmbViews;
    }
}

