/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.infobypoint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.view.info.gui.XMLItem;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.CompoundBehavior;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.infobypoint.InfoByPointDataModel;
import org.gvsig.raster.swing.infobypoint.MainInfoByPointPanel;
import org.gvsig.raster.swing.pixelinspector.PixelInspector;
import org.gvsig.raster.wms.app.wmsclient.infobypoint.BrowserControl;
import org.gvsig.raster.wms.app.wmsclient.infobypoint.InfoByWMSPointExtension;
import org.gvsig.utils.xmlViewer.TextXMLContent;
import org.gvsig.utils.xmlViewer.XMLContent;
import org.gvsig.utils.xmlViewer.XMLViewer;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class MainInfoByPointDialog
extends JPanel
implements IWindow,
HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private MainInfoByPointPanel mainPanel = null;
    private JScrollPane scroll = null;
    private JPanel wmsInfo = null;
    private JEditorPane jeditor = null;
    private XMLViewer dlgXML = null;
    private XMLItem item = null;
    private XMLContent xmlContent = null;

    public MainInfoByPointDialog() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "West");
        this.add((Component)this.getWMSInfoPanel(), "Center");
    }

    public MainInfoByPointPanel getMainPanel() {
        if (this.mainPanel == null) {
            HashMap<String, String> translations = new HashMap<String, String>();
            translations.put("info", PluginServices.getText((Object)this, (String)"info"));
            translations.put("view", PluginServices.getText((Object)this, (String)"view"));
            translations.put("layer_list", PluginServices.getText((Object)this, (String)"layer_list"));
            translations.put("band_values", PluginServices.getText((Object)this, (String)"band_values"));
            translations.put("pixel_point", PluginServices.getText((Object)this, (String)"pixel_point"));
            translations.put("view_point", PluginServices.getText((Object)this, (String)"view_point"));
            translations.put("world_point", PluginServices.getText((Object)this, (String)"world_point"));
            translations.put("bands", PluginServices.getText((Object)this, (String)"bands"));
            translations.put("colors", PluginServices.getText((Object)this, (String)"colors"));
            translations.put("coords", PluginServices.getText((Object)this, (String)"coords"));
            translations.put("lat", PluginServices.getText((Object)this, (String)"lat"));
            translations.put("long", PluginServices.getText((Object)this, (String)"long"));
            translations.put("red", PluginServices.getText((Object)this, (String)"red"));
            translations.put("green", PluginServices.getText((Object)this, (String)"green"));
            translations.put("blue", PluginServices.getText((Object)this, (String)"blue"));
            HashMap<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
            icons.put("forward-icon", IconThemeHelper.getImageIcon((String)"forward-icon"));
            icons.put("backward-icon", IconThemeHelper.getImageIcon((String)"backward-icon"));
            this.mainPanel = RasterSwingLocator.getSwingManager().createInfoByPointPanel(translations, icons, null);
            ((JPanel)this.mainPanel).setPreferredSize(new Dimension(230, 0));
        }
        return this.mainPanel;
    }

    private JPanel getWMSInfoPanel() {
        if (this.wmsInfo == null) {
            this.wmsInfo = new JPanel();
            this.wmsInfo.setLayout(new BorderLayout());
            this.jeditor = new JEditorPane();
            this.scroll = new JScrollPane(this.jeditor);
            this.jeditor.addHyperlinkListener(this);
            this.jeditor.setEditable(false);
            this.wmsInfo.add((Component)this.scroll, "Center");
        }
        return this.wmsInfo;
    }

    private JPanel getWMSXMLInfoPanel(String text) throws SAXException {
        if (this.wmsInfo == null) {
            this.wmsInfo = new JPanel();
            this.wmsInfo.setLayout(new BorderLayout());
            this.dlgXML = new XMLViewer();
            this.scroll = new JScrollPane((Component)this.dlgXML);
            this.item = new StringXMLItem(text, null);
            this.xmlContent = new XMLContent(){
                private ContentHandler handler;

                public void setContentHandler(ContentHandler arg0) {
                    this.handler = arg0;
                }

                public void parse() throws SAXException {
                    this.handler.startDocument();
                    MainInfoByPointDialog.this.item.parse(this.handler);
                    this.handler.endDocument();
                }
            };
            this.dlgXML.setNamesColumn(new String[0]);
            this.dlgXML.setModel(this.xmlContent);
            this.dlgXML.getXmlTree().setRootVisible(false);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.dlgXML.getXmlTree().getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.dlgXML.getXmlTree().getModel().getRoot();
            DefaultMutableTreeNode n = root.getFirstLeaf();
            TreePath path = new TreePath(treeModel.getPathToRoot(n));
            this.dlgXML.getXmlTree().expandPath(path);
            this.wmsInfo.add((Component)this.scroll, "Center");
        }
        return this.wmsInfo;
    }

    public void setWMSInfoText(String text, String type) {
        block9: {
            if (type.equals("text/html")) {
                if (this.jeditor == null) {
                    this.wmsInfo = null;
                    this.dlgXML = null;
                    this.remove(1);
                    this.add((Component)this.getWMSInfoPanel(), "Center");
                }
                HTMLEditorKit kit = new HTMLEditorKit();
                this.jeditor.setEditorKit(kit);
                text = this.removeLabelBlock(text, "style");
                text = this.removeLabelBlock(text, "meta");
                StyleSheet s = kit.getStyleSheet();
                s.addRule("body {font-family:verdana; margin: 15px; }");
                s.addRule("caption {background-color:#FBFFE1;font-style:normal;color:black}");
                s.addRule("th {background-color:#D6D6D6;color:white;}");
                s.addRule("td {background-color:#FEEDD6;color:black;}");
                Document doc = kit.createDefaultDocument();
                this.jeditor.setDocument(doc);
                this.jeditor.setContentType(type);
                this.jeditor.setText(text);
            } else if (type.equals("text/xml")) {
                try {
                    if (this.dlgXML == null) {
                        this.wmsInfo = null;
                        this.jeditor = null;
                        this.remove(1);
                        this.add((Component)this.getWMSXMLInfoPanel(text), "Center");
                        break block9;
                    }
                    this.item = new StringXMLItem(text, null);
                    this.dlgXML.setModel(this.xmlContent);
                }
                catch (SAXException e) {
                    LoggerFactory.getLogger(MainInfoByPointDialog.class).debug("", (Throwable)e);
                }
            } else {
                if (this.jeditor == null) {
                    this.wmsInfo = null;
                    this.dlgXML = null;
                    this.remove(1);
                    this.add((Component)this.getWMSInfoPanel(), "Center");
                }
                this.jeditor.setText(text);
            }
        }
    }

    private String removeLabelBlock(String text, String label) {
        if (text.contains("<" + label) && text.contains("/" + label + ">")) {
            int initIndex = text.indexOf("<" + label);
            int endIndex = text.indexOf("/" + label + ">");
            return text.substring(0, initIndex) + text.substring(endIndex + 7, text.length());
        }
        return text;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(17);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"WMS InfoByPoint"));
        m_viewinfo.setHeight(380);
        m_viewinfo.setWidth(700);
        return m_viewinfo;
    }

    public void windowClosed() {
        CompoundBehavior.setAllControlsBehavior((Behavior)InfoByWMSPointExtension.oldBehavior);
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }

    public InfoByPointDataModel getInfoByPointDataModel() {
        return this.getMainPanel().getInfoByPointDataModel();
    }

    public PixelInspector getPixelInspector() {
        return this.getMainPanel().getPixelInspectorPanel();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            new BrowserControl().displayURL(e.getURL().toString());
        }
    }

    public class StringXMLItem
    extends TextXMLContent
    implements XMLItem {
        FLayer layer;

        public StringXMLItem(String text, FLayer lyr) {
            super(text);
            this.layer = lyr;
        }

        public FLayer getLayer() {
            return this.layer;
        }

        public void parse(ContentHandler handler) throws SAXException {
            this.setContentHandler(new FilterContentHandler(handler));
            this.parse();
        }

        private class FilterContentHandler
        implements ContentHandler {
            private ContentHandler handler;

            public FilterContentHandler(ContentHandler handler) {
                this.handler = handler;
            }

            @Override
            public void setDocumentLocator(Locator arg0) {
            }

            @Override
            public void startDocument() throws SAXException {
            }

            @Override
            public void endDocument() throws SAXException {
            }

            @Override
            public void startPrefixMapping(String arg0, String arg1) throws SAXException {
            }

            @Override
            public void endPrefixMapping(String arg0) throws SAXException {
            }

            @Override
            public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
                this.handler.startElement(arg0, arg1, arg2, arg3);
            }

            @Override
            public void endElement(String arg0, String arg1, String arg2) throws SAXException {
                this.handler.endElement(arg0, arg1, arg2);
            }

            @Override
            public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
                this.handler.characters(arg0, arg1, arg2);
            }

            @Override
            public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
            }

            @Override
            public void processingInstruction(String arg0, String arg1) throws SAXException {
            }

            @Override
            public void skippedEntity(String arg0) throws SAXException {
            }
        }
    }
}

