/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.fusespatially;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.base.util.JTSFacade;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuseSpatiallyOperationFast2
extends GeometryOperation {
    private static Logger logger = LoggerFactory.getLogger((String)FuseSpatiallyOperationFast2.class.getName());
    private ArrayList<Element> featureList = new ArrayList();
    private String nameIdField = null;
    private FeatureStore outFeatStoreTable = null;
    private NodeTree baseTree = null;

    public FuseSpatiallyOperationFast2(AbstractSextanteGeoProcess process) {
        super(process);
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature featureInput) {
        return null;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature featureInput) {
    }

    public void computesGeometryOperation(FeatureStore inFeatStore, FeatureStore outFeatStore, FeatureStore outFeatStoreTable, String[] attrNames, String[] attrNamesTable, boolean selectedGeomInput, boolean selectedGeomOutput, String idField) throws DataException {
        this.outFeatStoreTable = outFeatStoreTable;
        this.nameIdField = idField;
        this.inFeatureStore = inFeatStore;
        this.selectedGeomInput = selectedGeomInput;
        this.selectedGeomOverlay = selectedGeomOutput;
        FeatureSet featuresSet = null;
        featuresSet = inFeatStore.getFeatureSet();
        this.setFeatureStore(outFeatStore, attrNames);
        DisposableIterator it = null;
        if (selectedGeomInput) {
            FeatureSelection ds = inFeatStore.getFeatureSelection();
            it = ds.iterator();
            this.numberOfFeatures = (int)ds.getSelectedCount();
        } else {
            it = featuresSet.iterator();
            this.numberOfFeatures = (int)featuresSet.getSize();
        }
        if (this.status != null) {
            this.status.setRangeOfValues(0L, (long)this.numberOfFeatures);
        }
        if (this.process != null) {
            this.process.setProgress(0, this.numberOfFeatures);
        }
        int iCount = 0;
        while (it.hasNext() && !this.process.getTaskMonitor().isCanceled()) {
            Feature feat = ((Feature)it.next()).getCopy();
            Element el = new Element();
            el.feat = feat;
            el.id = iCount;
            this.featureList.add(el);
            if (this.status != null && this.process != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            ++iCount;
        }
        for (iCount = 0; iCount < this.featureList.size() && !this.process.getTaskMonitor().isCanceled(); ++iCount) {
            Element elem1 = this.featureList.get(iCount);
            org.gvsig.fmap.geom.Geometry geom1 = elem1.feat.getDefaultGeometry();
            if (this.status != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            for (int i = iCount + 1; i < this.featureList.size(); ++i) {
                Element elem2 = this.featureList.get(i);
                org.gvsig.fmap.geom.Geometry geom2 = elem2.feat.getDefaultGeometry();
                if (!this.areBBoxesOverlaping(geom1, geom2)) continue;
                if (elem1.jtsGeom == null) {
                    elem1.jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)geom1);
                }
                elem2.jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)geom2);
                if (!elem1.jtsGeom.intersects(elem2.jtsGeom)) continue;
                elem1.overlapList.add(elem2);
                elem2.overlapList.add(elem1);
            }
        }
        int iFeat = 0;
        for (iCount = 0; iCount < this.featureList.size() && !this.process.getTaskMonitor().isCanceled(); ++iCount) {
            Element elem1 = this.featureList.get(iCount);
            if (this.status != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            if (elem1.insertedToJoin) continue;
            this.buildListToJoin(elem1, iFeat);
            ++iFeat;
        }
        if (this.persister != null) {
            this.persister.end();
        }
    }

    private boolean areBBoxesOverlaping(org.gvsig.fmap.geom.Geometry g1, org.gvsig.fmap.geom.Geometry g2) {
        if (g1.getEnvelope().getMaximum(0) < g2.getEnvelope().getMinimum(0)) {
            return false;
        }
        if (g1.getEnvelope().getMinimum(0) > g2.getEnvelope().getMaximum(0)) {
            return false;
        }
        if (g1.getEnvelope().getMaximum(1) < g2.getEnvelope().getMinimum(1)) {
            return false;
        }
        return !(g1.getEnvelope().getMinimum(1) > g2.getEnvelope().getMaximum(1));
    }

    private Geometry computesUnion(List<Geometry> listResult, Element elem1) {
        int splitValue = 500;
        Geometry newGeom = null;
        if (listResult.size() > splitValue) {
            int i;
            List<List<Geometry>> list = this.splitList(listResult, splitValue);
            ArrayList<Geometry> result = new ArrayList<Geometry>();
            for (i = 0; i < list.size(); ++i) {
                Geometry aux = GeometryUtil.geometryUnion(list.get(i), (int)elem1.feat.getDefaultGeometry().getGeometryType().getType());
                result.add(aux);
            }
            for (i = 0; i < result.size(); ++i) {
                newGeom = GeometryUtil.geometryUnion(result, (int)elem1.feat.getDefaultGeometry().getGeometryType().getType());
            }
        } else {
            newGeom = GeometryUtil.geometryUnion(listResult, (int)elem1.feat.getDefaultGeometry().getGeometryType().getType());
        }
        return newGeom;
    }

    private Geometry computesUnion2(List<Geometry> listResult, Element elem1) {
        Geometry newGeom = null;
        for (int i = 1; i < listResult.size(); ++i) {
            newGeom = i == 1 ? JTSFacade.union((Geometry)listResult.get(0), (Geometry)listResult.get(1)) : JTSFacade.union(newGeom, (Geometry)listResult.get(i));
        }
        return newGeom;
    }

    private Geometry computesUnion3(List<Geometry> listResult) {
        Geometry newGeom = null;
        int iCount = 0;
        int max = listResult.size();
        if (this.process != null) {
            this.process.setName("Generating union");
        }
        while (listResult.size() > 1) {
            ArrayList<Geometry> list = new ArrayList<Geometry>();
            if (this.status != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, max);
            }
            for (int i = 0; i < listResult.size(); i += 2) {
                if (i == listResult.size() - 1) {
                    list.add(listResult.get(i));
                    continue;
                }
                newGeom = JTSFacade.union((Geometry)listResult.get(i), (Geometry)listResult.get(i + 1));
                list.add(newGeom);
            }
            listResult = list;
        }
        return newGeom;
    }

    private List<List<Geometry>> splitList(List<Geometry> list, int n) {
        int elements = list.size() / n;
        ArrayList<List<Geometry>> l = new ArrayList<List<Geometry>>();
        for (int i = 0; i < elements; ++i) {
            l.add(list.subList(i * n, i * n + n));
        }
        if (elements * n < list.size()) {
            l.add(list.subList(elements * n, list.size()));
        }
        return l;
    }

    private void buildListToJoin(Element elem, int iFeat) {
        Geometry newGeom = null;
        if (elem.overlapList.size() == 0) {
            if (!elem.insertedToJoin) {
                elem.insertedToJoin = true;
            }
            try {
                this.insertInTable(this.outFeatStoreTable, elem.feat, iFeat);
                this.addFeatureToOutput(elem.feat.getDefaultGeometry(), elem.feat, iFeat);
            }
            catch (DataException e) {
                logger.info("Imposible insertar en la tabla", (Throwable)e);
            }
            catch (CreateGeometryException e) {
                logger.info("Error a\u00f1adiendo geometr\u00eda", (Throwable)e);
            }
        } else {
            ArrayList<Geometry> listResult = new ArrayList<Geometry>();
            NodeTree subtree = new NodeTree(elem, null);
            while (subtree != null) {
                if (!subtree.element.insertedToJoin) {
                    listResult.add(subtree.element.jtsGeom);
                    try {
                        this.insertInTable(this.outFeatStoreTable, subtree.element.feat, iFeat);
                    }
                    catch (DataException e) {
                        logger.info("Imposible insertar en la tabla", (Throwable)e);
                    }
                    subtree.element.insertedToJoin = true;
                }
                boolean back = false;
                Element l = subtree.getNext();
                if (l == null) {
                    back = true;
                }
                while (!back && l.insertedToJoin) {
                    l = subtree.getNext();
                    if (l != null) continue;
                    back = true;
                }
                if (back) {
                    subtree = subtree.parent;
                    continue;
                }
                subtree = new NodeTree(l, subtree);
            }
            newGeom = this.computesUnion3(listResult);
            try {
                this.addFeatureToOutput(newGeom, elem.feat, iFeat);
            }
            catch (DataException e) {
                logger.info("Imposible insertar en la tabla", (Throwable)e);
            }
            catch (CreateGeometryException e) {
                logger.info("Error a\u00f1adiendo geometr\u00eda", (Throwable)e);
            }
        }
    }

    private void addFeatureToOutput(org.gvsig.fmap.geom.Geometry newGeom, Feature feat, int newFeatID) throws DataException, CreateGeometryException {
        if (this.outFeatStoreTable != null) {
            this.lastEditFeature = this.persister.addFeature(newGeom, this.nameIdField, (Object)newFeatID);
        } else {
            String[] fieldNames = this.persister.getFieldNamesWithoutGeom();
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            fields.add(this.nameIdField);
            values.add(newFeatID);
            for (int j = 0; j < fieldNames.length; ++j) {
                Object obj;
                if (fieldNames[j].compareTo(this.nameIdField) == 0 || (obj = feat.get(fieldNames[j])) == null || fieldNames[j].compareTo(this.nameIdField) == 0) continue;
                fields.add(fieldNames[j]);
                values.add(obj);
            }
            this.lastEditFeature = this.persister.addFeature(newGeom, fields, values);
        }
    }

    private void addFeatureToOutput(Geometry newGeom, Feature feat, int newFeatID) throws DataException, CreateGeometryException {
        if (this.outFeatStoreTable != null) {
            this.lastEditFeature = this.persister.addFeature(newGeom, this.nameIdField, (Object)newFeatID);
        } else {
            String[] fieldNames = this.persister.getFieldNamesWithoutGeom();
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            fields.add(this.nameIdField);
            values.add(newFeatID);
            for (int j = 0; j < fieldNames.length; ++j) {
                Object obj;
                if (fieldNames[j].compareTo(this.nameIdField) == 0 || (obj = feat.get(fieldNames[j])) == null) continue;
                fields.add(fieldNames[j]);
                values.add(obj);
            }
            this.lastEditFeature = this.persister.addFeature(newGeom, fields, values);
        }
    }

    private void insertInTable(FeatureStore outFeatureStoreTable, Feature f, int reference) throws DataException {
        if (outFeatureStoreTable == null) {
            return;
        }
        EditableFeature edFeat = outFeatureStoreTable.createNewFeature();
        edFeat.set(this.nameIdField, (Object)reference);
        FeatureAttributeDescriptor[] attrList = f.getType().getAttributeDescriptors();
        for (int j = 0; j < attrList.length; ++j) {
            if (attrList[j].getName().compareTo("GEOMETRY") == 0) continue;
            edFeat.set(attrList[j].getName(), f.get(attrList[j].getName()));
        }
        outFeatureStoreTable.insert(edFeat);
    }

    class NodeTree {
        public Element element = null;
        public int pos = 0;
        public NodeTree parent = null;

        public NodeTree(Element node, NodeTree parent) {
            this.element = node;
            this.parent = parent;
        }

        public Element getNext() {
            if (this.pos < this.element.overlapList.size()) {
                return this.element.overlapList.get(this.pos++);
            }
            return null;
        }
    }

    class Element {
        public int id = -1;
        public Feature feat = null;
        public List<Element> overlapList = new ArrayList<Element>();
        public boolean insertedToJoin = false;
        public Geometry jtsGeom = null;

        Element() {
        }
    }
}

