/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gvsig.scripting.ScriptingBaseScript;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingRunningException;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.JScriptingBrowser;
import org.gvsig.scripting.swing.api.JScriptingLauncher;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.impl.DefaultJScriptingBrowser;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.util.CancelledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJScriptingLauncher
extends JPanel
implements JScriptingLauncher,
ActionListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJScriptingLauncher.class);
    private static final long serialVersionUID = -2612734398104678920L;
    protected ActionListenerSupport defaultActionlisteners = null;
    JTabbedPane pestana;
    ScriptingUIManager uimanager;
    ScriptingManager manager;

    public DefaultJScriptingLauncher(ScriptingUIManager uimanager) {
        this.uimanager = uimanager;
        this.manager = uimanager.getManager();
        this.defaultActionlisteners = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
        ArrayList<ScriptingFolder> folders = new ArrayList<ScriptingFolder>();
        folders.add(this.manager.getUserFolder());
        folders.addAll(this.manager.getAlternativeUserFolders());
        folders.add(this.manager.getSystemFolder());
        this.pestana = new JTabbedPane();
        for (ScriptingFolder folder : folders) {
            DefaultJScriptingBrowser browser = new DefaultJScriptingBrowser(uimanager, folder);
            browser.addActionListener(this);
            this.pestana.addTab(uimanager.getTranslation(folder.getName()), browser);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.pestana, "Center");
        this.setPreferredSize(new Dimension(260, 300));
    }

    public JScriptingBrowser getSelectedBrowser() {
        return (JScriptingBrowser)this.pestana.getSelectedComponent();
    }

    public JComponent asJComponent() {
        return this;
    }

    public void refresh() {
        for (int i = 0; i < this.pestana.getTabCount(); ++i) {
            DefaultJScriptingBrowser browser = (DefaultJScriptingBrowser)this.pestana.getComponentAt(i);
            browser.refresh();
        }
        this.pestana.repaint();
    }

    public void addDefaultActionListener(ActionListener actionlistener) {
        this.defaultActionlisteners.addActionListener(actionlistener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            JScriptingBrowser.BrowserActionEvent e2 = (JScriptingBrowser.BrowserActionEvent)e;
            switch (e.getID()) {
                case 1: {
                    if (this.defaultActionlisteners.hasActionListeners()) {
                        this.defaultActionlisteners.fireActionEvent((ActionEvent)new DefaultJScriptingBrowser.DefaultBrowserActionEvent((Object)this, 1, "default", e2.getUnit()));
                        break;
                    }
                    ScriptingUnit unit = e2.getUnit();
                    if (unit instanceof ScriptingBaseScript) {
                        ScriptingBaseScript script = (ScriptingBaseScript)unit;
                        try {
                            script.compile();
                            script.runAsTask(null);
                        }
                        catch (ScriptingRunningException ex) {
                            LOG.warn("Problems launching script '" + script.getName() + "'", (Throwable)ex);
                        }
                    }
                    break;
                }
                case 2: 
                case 3: {
                    this.defaultActionlisteners.fireActionEvent((ActionEvent)new DefaultJScriptingBrowser.DefaultBrowserActionEvent((Object)this, e.getID(), "default", e2.getUnit()));
                }
            }
        }
        catch (CancelledException e2) {
        }
        catch (Throwable th) {
            LOG.warn("", th);
        }
    }
}

