/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.impl.DefaultJScriptingBrowser;
import org.gvsig.scripting.swing.impl.DialogPanel;
import org.gvsig.scripting.swing.impl.composer.JMoveScriptModel;
import org.gvsig.scripting.swing.impl.composer.JMoveScriptPanelView;

public class JMoveScriptPanel
extends JMoveScriptPanelView
implements DialogPanel {
    private static final long serialVersionUID = 1L;
    private final ScriptingUIManager uimanager;
    private final ScriptingManager manager;
    private final ScriptingUnit unit;
    private final JMoveScriptModel model;
    private DefaultJScriptingBrowser jbrowser;
    private File target;

    public JMoveScriptPanel(ScriptingUIManager uimanager, JMoveScriptModel model) {
        this.uimanager = uimanager;
        this.manager = this.uimanager.getManager();
        this.model = model;
        this.unit = model.getUnit();
        model.setAction(0);
        this.initComponents();
    }

    private void initComponents() {
        this.target = this.unit.getFile();
        this.txtSource.setText(this.unit.getUserPath());
        this.txtTarget.setText(this.unit.getUserPath());
        this.initBrowser();
        this.setPreferredSize(new Dimension(500, 500));
        this.chkOverwrite.setSelected(this.model.isOverwrite());
    }

    private void initBrowser() {
        this.jbrowser = new DefaultJScriptingBrowser(this.uimanager, this.manager.getUserFolder(), true);
        this.jbrowser.setPreferredSize(new Dimension(250, 100));
        this.pnlBrowserContainer.setLayout(new BorderLayout());
        this.pnlBrowserContainer.add((Component)this.jbrowser, "Center");
        this.jbrowser.addActionListener(arg0 -> {
            if (arg0.getID() == 2) {
                this.doFolderSelection();
            }
        });
        this.jbrowser.setSelectionPath(this.model.getSelectionPath().getParentPath());
    }

    private void doFolderSelection() {
        ScriptingUnit node = this.jbrowser.getSelectedNode();
        if (node instanceof ScriptingFolder) {
            ScriptingFolder selectedFolder = (ScriptingFolder)node;
            this.target = new File(selectedFolder.getFile(), this.unit.getFile().getName());
            this.txtTarget.setText(selectedFolder.getUserPath() + "/" + this.unit.getName());
        }
    }

    @Override
    public void actionAccept() {
        try {
            if (this.target.getCanonicalFile().equals(this.unit.getFile().getCanonicalFile())) {
                JOptionPane.showMessageDialog(this, "Source and target cannot be the same", "Info", 1);
                return;
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Info", 0);
            return;
        }
        this.model.setOverwrite(this.chkOverwrite.isSelected());
        this.model.setMoveTo(this.target);
        try {
            this.model.validate();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Info", 2);
            return;
        }
        this.model.setAction(1);
        this.setVisible(false);
    }

    @Override
    public void actionApply() {
    }

    @Override
    public void actionCancel() {
        this.setVisible(false);
    }

    @Override
    public boolean isVisibleAccept() {
        return true;
    }

    @Override
    public boolean isVisibleApply() {
        return false;
    }

    @Override
    public boolean isVisibleCancel() {
        return true;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }
}

