/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.impl.DialogPanel;
import org.gvsig.scripting.swing.impl.composer.JPropertiesScript;
import org.gvsig.scripting.swing.impl.composer.JRenameModel;

public class JRenamePanel
extends JPanel
implements DialogPanel {
    private static final long serialVersionUID = 1L;
    private ScriptingUIManager uimanager;
    private JRenameModel model;
    private ScriptingUnit unit;
    JTextField oldName = null;
    JTextField newName = null;
    JPropertiesScript jProperties = null;

    public JRenamePanel(ScriptingUIManager uimanager, JRenameModel model) {
        this.uimanager = uimanager;
        this.model = model;
        this.unit = model.getUnit();
        model.setAction(0);
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(25, 10, 0, 5);
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel(this.uimanager.getTranslation("current_name") + ": "), gbc);
        gbc.gridx = 1;
        this.oldName = new JTextField(20);
        this.oldName.setText(this.unit.getId());
        this.oldName.setEditable(false);
        panel.add((Component)this.oldName, gbc);
        gbc.insets = new Insets(10, 10, 25, 5);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel(this.uimanager.getTranslation("new_name") + ": "), gbc);
        gbc.gridx = 1;
        this.newName = new JTextField(20);
        this.newName.setText(this.unit.getId());
        panel.add((Component)this.newName, gbc);
        TitledBorder title = BorderFactory.createTitledBorder(this.uimanager.getTranslation("rename_name_title"));
        panel.setBorder(title);
        this.jProperties = new JPropertiesScript(this.unit);
        TitledBorder title2 = BorderFactory.createTitledBorder(this.uimanager.getTranslation("more_properties"));
        this.jProperties.setBorder(title2);
        this.add((Component)panel, "North");
        this.add((Component)this.jProperties, "Center");
    }

    @Override
    public void actionAccept() {
        this.model.setNewName(this.newName.getText().trim());
        this.jProperties.fectch(this.unit);
        this.model.setUnit(this.unit);
        try {
            this.model.validate();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Info", 1);
            return;
        }
        this.model.setAction(1);
        this.setVisible(false);
    }

    @Override
    public void actionApply() {
    }

    @Override
    public void actionCancel() {
        this.setVisible(false);
    }

    @Override
    public boolean isVisibleAccept() {
        return true;
    }

    @Override
    public boolean isVisibleApply() {
        return false;
    }

    @Override
    public boolean isVisibleCancel() {
        return true;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }
}

