/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.syntaxhighlight;

import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledEditorKit;
import org.gvsig.scripting.swing.api.SyntaxtHighlightTextComponent;
import org.gvsig.scripting.swing.impl.syntaxhighlight.styles.JavaStyledDocument;
import org.gvsig.scripting.swing.impl.syntaxhighlight.styles.PythonStyledDocument;

public class JEditorPaneSyntaxHighlighting
extends JEditorPane
implements SyntaxtHighlightTextComponent {
    private static final long serialVersionUID = -4451156833693922180L;
    protected ActionListener updateCaretPosition = null;

    public JEditorPaneSyntaxHighlighting() {
        this.setEditorKitForContentType("text/java", new StyledEditorKit(){
            private static final long serialVersionUID = 2002618010308466332L;

            @Override
            public Document createDefaultDocument() {
                return new JavaStyledDocument();
            }
        });
        this.setEditorKitForContentType("text/javascript", new StyledEditorKit(){
            private static final long serialVersionUID = 830100022798600914L;

            @Override
            public Document createDefaultDocument() {
                return new JavaStyledDocument();
            }
        });
        this.setEditorKitForContentType("text/python", new StyledEditorKit(){
            private static final long serialVersionUID = -2728112890159261335L;

            @Override
            public Document createDefaultDocument() {
                return new PythonStyledDocument();
            }
        });
        final JEditorPaneSyntaxHighlighting source = this;
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (JEditorPaneSyntaxHighlighting.this.updateCaretPosition == null) {
                    return;
                }
                int lineNumber = 1;
                int columnNumber = 0;
                int currentPosition = JEditorPaneSyntaxHighlighting.this.getCaretPosition();
                Document doc = JEditorPaneSyntaxHighlighting.this.getDocument();
                PythonStyledDocument pydoc = null;
                if (doc instanceof PythonStyledDocument) {
                    pydoc = (PythonStyledDocument)doc;
                }
                try {
                    String strText = doc.getText(0, currentPosition);
                    char[] arrText = strText.toCharArray();
                    for (int i = 0; i < strText.length(); ++i) {
                        if (arrText[i] != '\n') continue;
                        ++lineNumber;
                    }
                    columnNumber = currentPosition - strText.lastIndexOf(10);
                }
                catch (BadLocationException ble) {
                    System.err.println(ble);
                }
                if (pydoc != null) {
                    pydoc.setPosition(lineNumber, columnNumber);
                }
                JEditorPaneSyntaxHighlighting.this.updateCaretPosition.actionPerformed(new DefaultUpdateCaretPositionActionEvent(source, 1, "position", lineNumber, columnNumber));
            }
        });
    }

    public void addUpdateCaretPositionActionListener(ActionListener updateCaretPosition) {
        this.updateCaretPosition = updateCaretPosition;
    }

    public JScrollPane getJScrollPane() {
        return new JScrollPane(this);
    }

    public JTextComponent getJTextComponent() {
        return this;
    }

    public JComponent asJComponent() {
        return this.getJScrollPane();
    }

    public void removeTrackingIcons() {
    }

    public void addLineTrackingIcon(String tag, int line, Icon icon, String tip) {
    }

    public void addLineTrackingIcon(String tag, int line, Icon icon, String tip, Color color) {
    }

    public void removeTrackingIcons(String tag) {
    }

    public void discardAllEdits() {
    }

    public void gotoline(int line) {
        JTextComponent component = this.getJTextComponent();
        Element root = component.getDocument().getDefaultRootElement();
        int lineno = Math.max(line, 1);
        int maxlines = root.getElementCount();
        lineno = Math.min(lineno, maxlines);
        int startOfLineOffset = root.getElement(lineno - 1).getStartOffset();
        component.setCaretPosition(startOfLineOffset);
        Container container = SwingUtilities.getAncestorOfClass(JViewport.class, component);
        if (container == null) {
            return;
        }
        try {
            Rectangle r = component.modelToView(component.getCaretPosition());
            JViewport viewport = (JViewport)container;
            int extentHeight = viewport.getExtentSize().height;
            int viewHeight = viewport.getViewSize().height;
            int y = Math.max(0, r.y - (extentHeight - r.height) / 2);
            y = Math.min(y, viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        try {
            component.setCaretPosition(startOfLineOffset + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class DefaultUpdateCaretPositionActionEvent
    extends ActionEvent
    implements SyntaxtHighlightTextComponent.UpdateCaretPositionActionEvent {
        int line;
        int column;

        public DefaultUpdateCaretPositionActionEvent(Object source, int id, String command, int line, int column) {
            super(source, id, command);
            this.line = -1;
            this.column = -1;
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean hasLineAndColumn() {
            return this.line >= 0 && this.column >= 0;
        }
    }
}

