/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.syntaxhighlight;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.fife.rsta.ui.CollapsibleSectionPanel;
import org.fife.rsta.ui.search.FindToolBar;
import org.fife.rsta.ui.search.ReplaceToolBar;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.gvsig.scripting.swing.api.ScriptingSwingLocator;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.api.SyntaxtHighlightTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRSyntaxTextArea
implements SyntaxtHighlightTextComponent,
SearchListener {
    private static final Logger logger = LoggerFactory.getLogger(JRSyntaxTextArea.class);
    private final FindToolBar findToolBar;
    private final ReplaceToolBar replaceToolBar;
    private final CollapsibleSectionPanel csp;
    protected ActionListener updateCaretPosition = null;
    protected RSyntaxTextArea textArea = null;
    private final RTextScrollPane scrollPanel;
    private final JPanel panel;
    private final Map<String, String> contentTypeAlias;
    private final IconsTracker iconsTracker = new IconsTracker();
    private LineTrackerPanel lineTrackerPanel;
    private ScriptingUIManager scriptingUIManager;
    private String[] python_keywords = new String[]{"except", "class", "continue", "else", "finally", "if", "elif", "in", "return", "raise", "try", "while", "def", "print", "globals", "for", "pass", "from", "import", "True", "False", "None", "self", "break", "__init__", "__len__", "__str__", "__repr__", "__call__", "__iter__", "__class__", "__getattr__", "__setattr__", "__delattr__", "__getitem__", "__setitem__", "__delitem__", "__getslice__", "__setslice__", "__delslice__", "__getattribute__", "__setattribute__", "__contains__", "__reduce__", "__cmp__", "__eq__", "__ne__", "__lt__", "__le__", "__gt__", "__ge__", "__mul__", "__imul__", "__rmul__", "__add__", "__iadd__", "__radd__", "__mod__", "__rmod__", "int", "unicode", "str", "float", "long", "list", "tuple", "dict", "iter", "vars", "isinstance", "dir", "repr", "reduce", "zip", "chr", "hex", "id", "max", "min", "oct", "pow", "ord", "unichr", "range", "xrange", "abs", "len", "apply", "open", "getattr", "setattr", "hasattr"};

    public JRSyntaxTextArea() {
        this.contentTypeAlias = new HashMap<String, String>();
        this.contentTypeAlias.put("text/r", "text/c");
        this.contentTypeAlias.put("text/ecmascript", "text/javascript");
        this.contentTypeAlias.put("text/cosa", "text/sql");
        this.textArea = new RSyntaxTextArea(20, 60);
        UIDefaults uidefaults = UIManager.getLookAndFeel().getDefaults();
        this.textArea.setBackground((Color)uidefaults.get("EditorPane.background"));
        this.textArea.setForeground((Color)uidefaults.get("EditorPane.foreground"));
        this.textArea.setFont((Font)uidefaults.get("EditorPane.font"));
        this.init();
        this.lineTrackerPanel = new LineTrackerPanel();
        this.scrollPanel = new RTextScrollPane((RTextArea)this.textArea);
        this.scrollPanel.setBackground((Color)uidefaults.get("EditorPane.background"));
        this.scrollPanel.setForeground((Color)uidefaults.get("EditorPane.foreground"));
        this.scrollPanel.setFont((Font)uidefaults.get("EditorPane.font"));
        this.scrollPanel.setIconRowHeaderEnabled(true);
        this.scrollPanel.setLineNumbersEnabled(true);
        this.scrollPanel.setFoldIndicatorEnabled(true);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.scrollPanel, "Center");
        this.panel.add((Component)this.lineTrackerPanel, "East");
        this.findToolBar = new MyFindToolBar(this);
        this.replaceToolBar = new MyReplaceToolBar(this);
        this.replaceToolBar.setSearchContext(this.findToolBar.getSearchContext());
        this.csp = new CollapsibleSectionPanel();
        this.csp.add((Component)this.scrollPanel);
        this.panel.add((Component)this.csp, "Center");
        int ctrl = 10;
        KeyStroke ks = KeyStroke.getKeyStroke(70, ctrl);
        this.csp.addBottomComponent(ks, (JComponent)this.findToolBar);
        ks = KeyStroke.getKeyStroke(72, ctrl);
        this.csp.addBottomComponent(ks, (JComponent)this.replaceToolBar);
        this.textArea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent ke) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getModifiers() == 10) {
                    if (ke.getKeyCode() == 72) {
                        JRSyntaxTextArea.this.csp.showBottomComponent((JComponent)JRSyntaxTextArea.this.replaceToolBar);
                    } else if (ke.getKeyCode() == 70) {
                        JRSyntaxTextArea.this.csp.showBottomComponent((JComponent)JRSyntaxTextArea.this.findToolBar);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent ke) {
            }
        });
    }

    protected void init() {
        this.textArea.setSyntaxEditingStyle("text/python");
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setClearWhitespaceLinesEnabled(true);
        this.textArea.setAutoIndentEnabled(true);
        this.textArea.setCloseCurlyBraces(true);
        this.textArea.setWhitespaceVisible(true);
        this.textArea.setAnimateBracketMatching(true);
        this.textArea.setBracketMatchingEnabled(true);
        this.textArea.setAutoIndentEnabled(true);
        this.textArea.setTabsEmulated(true);
        this.textArea.setTabSize(2);
        this.textArea.setAntiAliasingEnabled(true);
        this.textArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (JRSyntaxTextArea.this.updateCaretPosition == null) {
                    return;
                }
                JRSyntaxTextArea.this.updateCaretPosition.actionPerformed(new DefaultUpdateCaretPositionActionEvent(JRSyntaxTextArea.this.textArea, 1, "position", JRSyntaxTextArea.this.textArea.getCaretLineNumber(), JRSyntaxTextArea.this.textArea.getCaretOffsetFromLineStart()));
            }
        });
        MyCompletionProvider provider = new MyCompletionProvider(this.python_keywords);
        AutoCompletion ac = new AutoCompletion((CompletionProvider)provider);
        ac.setListCellRenderer((ListCellRenderer)new MyListCellRenderer());
        ac.setTriggerKey(KeyStroke.getKeyStroke(32, 128));
        ac.install((JTextComponent)this.textArea);
    }

    private ScriptingUIManager getUIManager() {
        if (this.scriptingUIManager == null) {
            this.scriptingUIManager = ScriptingSwingLocator.getUIManager();
        }
        return this.scriptingUIManager;
    }

    private ImageIcon getIcon(String key) {
        ImageIcon icon = this.getUIManager().getIcon(key);
        return icon;
    }

    private String normalizeContentType(String s) {
        if (this.contentTypeAlias.containsKey(s = s.toLowerCase())) {
            s = this.contentTypeAlias.get(s);
        }
        return s;
    }

    public void setContentType(String contentType) {
        String mimetype;
        TokenMakerFactory factory = TokenMakerFactory.getDefaultInstance();
        Set mimetypes = factory.keySet();
        if (!(mimetypes.contains(mimetype = this.normalizeContentType(contentType)) || mimetypes.contains(mimetype = mimetype.replace("-source", "")) || mimetypes.contains(mimetype = mimetype.replace("/x-", "/")))) {
            mimetype = this.normalizeContentType(contentType);
        }
        this.textArea.setSyntaxEditingStyle(mimetype);
    }

    public JScrollPane getJScrollPane() {
        return this.scrollPanel;
    }

    public JTextComponent getJTextComponent() {
        return this.textArea;
    }

    public JComponent asJComponent() {
        return this.panel;
    }

    public String getContentType() {
        return this.textArea.getSyntaxEditingStyle();
    }

    public void addUpdateCaretPositionActionListener(ActionListener updateCaretPosition) {
        this.updateCaretPosition = updateCaretPosition;
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void addKeyListener(KeyListener keyListener) {
        this.textArea.addKeyListener(keyListener);
    }

    public void searchEvent(SearchEvent e) {
        SearchEvent.Type type = e.getType();
        SearchContext context = e.getSearchContext();
        SearchResult result = null;
        switch (type) {
            default: {
                result = SearchEngine.markAll((RTextArea)this.textArea, (SearchContext)context);
                break;
            }
            case FIND: {
                result = SearchEngine.find((JTextArea)this.textArea, (SearchContext)context);
                if (result.wasFound()) break;
                this.textArea.getCaret().setDot(0);
                result = SearchEngine.find((JTextArea)this.textArea, (SearchContext)context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this.textArea);
                break;
            }
            case REPLACE: {
                result = SearchEngine.replace((RTextArea)this.textArea, (SearchContext)context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this.textArea);
                break;
            }
            case REPLACE_ALL: {
                result = SearchEngine.replaceAll((RTextArea)this.textArea, (SearchContext)context);
                JOptionPane.showMessageDialog(null, result.getCount() + " occurrences replaced.");
            }
        }
        String text = null;
        text = result.wasFound() ? "Text found; occurrences marked: " + result.getMarkedCount() : (type == SearchEvent.Type.MARK_ALL ? (result.getMarkedCount() > 0 ? "Occurrences marked: " + result.getMarkedCount() : "") : "Text not found");
    }

    public String getSelectedText() {
        return this.textArea.getSelectedText();
    }

    public void discardAllEdits() {
        this.textArea.discardAllEdits();
    }

    public void removeTrackingIcons() {
        this.scrollPanel.getGutter().removeAllTrackingIcons();
        this.iconsTracker.removeAll();
        this.lineTrackerPanel.removeLineTrackers();
    }

    public void addLineTrackingIcon(String tag, int line, Icon icon, String tip) {
        this.addLineTrackingIcon(tag, line, icon, tip, Color.BLUE.darker());
    }

    public void addLineTrackingIcon(String tag, int line, Icon icon, String tip, Color color) {
        try {
            GutterIconInfo x = this.scrollPanel.getGutter().addLineTrackingIcon(line, icon, tip);
            this.iconsTracker.add(tag, x);
            this.lineTrackerPanel.addLineTracker(tag, line, tip, color);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException("Can't add tracking icon with tag '" + tag + "' in line '" + line + "', tip='" + tip + "'", ex);
        }
    }

    public void removeTrackingIcons(String tag) {
        Set<GutterIconInfo> icontags = this.iconsTracker.get(tag);
        if (icontags != null) {
            for (GutterIconInfo icontag : icontags) {
                this.scrollPanel.getGutter().removeTrackingIcon(icontag);
            }
            this.iconsTracker.remove(tag);
        }
        this.lineTrackerPanel.removeLineTrackers(tag);
    }

    public void gotoline(int line) {
        JTextComponent component = this.getJTextComponent();
        Element root = component.getDocument().getDefaultRootElement();
        int lineno = Math.max(line, 1);
        int maxlines = root.getElementCount();
        lineno = Math.min(lineno, maxlines);
        int startOfLineOffset = root.getElement(lineno - 1).getStartOffset();
        component.setCaretPosition(startOfLineOffset);
        Container container = SwingUtilities.getAncestorOfClass(JViewport.class, component);
        if (container == null) {
            return;
        }
        try {
            Rectangle r = component.modelToView(component.getCaretPosition());
            JViewport viewport = (JViewport)container;
            int extentHeight = viewport.getExtentSize().height;
            int viewHeight = viewport.getViewSize().height;
            int y = Math.max(0, r.y - (extentHeight - r.height) / 2);
            y = Math.min(y, viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        try {
            component.setCaretPosition(startOfLineOffset + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public void addFocusListener(FocusListener l) {
        this.textArea.addFocusListener(l);
    }

    public void setlineTrackerVisible(boolean visible) {
        this.lineTrackerPanel.setVisible(visible);
    }

    private class MyCompletionProvider
    extends DefaultCompletionProvider {
        private List<Completion> keywords;
        private Icon keywordIcon;
        private Icon wordIcon;

        public MyCompletionProvider(String[] keywords) {
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            URL url = loader.getResource("org/gvsig/scripting/swing/impl/syntaxhighlight/images/autocompletion_keywords.png");
            if (url != null) {
                this.keywordIcon = new ImageIcon(url);
            }
            if ((url = loader.getResource("org/gvsig/scripting/swing/impl/syntaxhighlight/images/autocompletion_words.png")) != null) {
                this.wordIcon = new ImageIcon(url);
            }
            this.keywords = new ArrayList<Completion>();
            for (String keyword : keywords) {
                BasicCompletion completion = new BasicCompletion((CompletionProvider)this, keyword);
                completion.setIcon(this.keywordIcon);
                this.keywords.add((Completion)completion);
            }
        }

        protected List<Completion> getCompletionsImpl(JTextComponent comp) {
            TreeSet<Object> all = new TreeSet<Object>();
            all.addAll(this.keywords);
            String s = comp.getText();
            String[] x = StringUtils.split((String)s, (String)"\\ \n\t\r!\"><'@#|$%&/()=?\u00bf,.;:{}[]*-+");
            TreeSet<String> words = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            words.addAll(Arrays.asList(x));
            for (String word : words) {
                BasicCompletion completion = new BasicCompletion((CompletionProvider)this, word);
                completion.setIcon(this.wordIcon);
                completion.setRelevance(10);
                all.add(completion);
            }
            this.completions = new ArrayList();
            this.completions.addAll(all);
            return super.getCompletionsImpl(comp);
        }
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            ((JLabel)comp).setIcon(((Completion)value).getIcon());
            return comp;
        }
    }

    public class DefaultUpdateCaretPositionActionEvent
    extends ActionEvent
    implements SyntaxtHighlightTextComponent.UpdateCaretPositionActionEvent {
        private static final long serialVersionUID = 8238486105726094074L;
        int line;
        int column;

        public DefaultUpdateCaretPositionActionEvent(Object source, int id, String command, int line, int column) {
            super(source, id, command);
            this.line = -1;
            this.column = -1;
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line + 1;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean hasLineAndColumn() {
            return this.line >= 0 && this.column >= 0;
        }
    }

    private static class IconsTracker {
        private Map<String, Set<GutterIconInfo>> iconInfos = new HashMap<String, Set<GutterIconInfo>>();

        public void add(String tag, GutterIconInfo x) {
            Set<GutterIconInfo> set = this.iconInfos.get(tag);
            if (set == null) {
                set = new HashSet<GutterIconInfo>();
                this.iconInfos.put(tag, set);
            }
            set.add(x);
        }

        public void removeAll() {
            this.iconInfos = new HashMap<String, Set<GutterIconInfo>>();
        }

        public void remove(String tag) {
            this.iconInfos.remove(tag);
        }

        public void remove(String tag, GutterIconInfo x) {
            Set<GutterIconInfo> set = this.iconInfos.get(tag);
            if (set == null) {
                return;
            }
            set.remove(x);
        }

        public boolean exists(String tag) {
            return this.iconInfos.containsKey(tag);
        }

        public Set<GutterIconInfo> get(String tag) {
            Set<GutterIconInfo> set = this.iconInfos.get(tag);
            return set;
        }
    }

    private class LineTrackerPanel
    extends JPanel {
        private static final long serialVersionUID = -1923556745197997373L;

        public LineTrackerPanel() {
            this.setLayout(null);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(15, d.height);
        }

        public void addLineTracker(String tag, int lineno, String tooltip, Color color) {
            int posy = (int)((float)lineno * (float)this.getSize().height / (float)JRSyntaxTextArea.this.textArea.getLineCount());
            Line line = new Line(tag, lineno, posy, color, tooltip);
            this.add(line);
            this.repaint();
        }

        public void removeLineTrackers() {
            this.removeAll();
            this.repaint();
        }

        public void removeLineTrackers(String tag) {
            if (StringUtils.isEmpty((CharSequence)tag)) {
                return;
            }
            ArrayList<Line> toremove = new ArrayList<Line>();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Line line = (Line)this.getComponent(i);
                if (!tag.equalsIgnoreCase(line.getTag())) continue;
                toremove.add(line);
            }
            for (Line line : toremove) {
                this.remove(line);
            }
            this.repaint();
        }

        private class Line
        extends JLabel {
            private static final long serialVersionUID = 8966359978957026490L;
            private final int lineno;
            private final String tag;

            public Line(String tag, final int lineno, int posy, Color color, String tooltip) {
                UIDefaults uidefaults = UIManager.getLookAndFeel().getDefaults();
                this.setBackground((Color)uidefaults.get("EditorPane.background"));
                this.setForeground((Color)uidefaults.get("EditorPane.foreground"));
                this.lineno = lineno;
                this.tag = tag;
                this.setBackground(color);
                this.setBounds(0, posy, 15, 2);
                this.setOpaque(true);
                this.setToolTipText(tooltip);
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        JRSyntaxTextArea.this.gotoline(lineno);
                    }
                });
            }

            public int getLineno() {
                return this.lineno;
            }

            public String getTag() {
                return this.tag;
            }
        }
    }

    private class MyReplaceToolBar
    extends ReplaceToolBar {
        public MyReplaceToolBar(SearchListener listener) {
            super(listener);
        }

        protected JCheckBox createCB(String key) {
            MyCheckBox cb = new MyCheckBox();
            cb.setToolTipText(searchMsg.getString(key));
            cb.addActionListener((ActionListener)this.listener);
            cb.addMouseListener((MouseListener)this.listener);
            cb.setIcon(JRSyntaxTextArea.this.getIcon("scripting-search-" + key.toLowerCase()));
            return cb;
        }
    }

    private class MyFindToolBar
    extends FindToolBar {
        public MyFindToolBar(SearchListener listener) {
            super(listener);
        }

        protected JCheckBox createCB(String key) {
            MyCheckBox cb = new MyCheckBox();
            cb.setToolTipText(searchMsg.getString(key));
            cb.addActionListener((ActionListener)this.listener);
            cb.addMouseListener((MouseListener)this.listener);
            cb.setIcon(JRSyntaxTextArea.this.getIcon("scripting-search-" + key.toLowerCase()));
            return cb;
        }
    }

    public static class MyCheckBox
    extends JCheckBox {
        private static final String uiClassID = "ToggleButtonUI";

        @Override
        public String getUIClassID() {
            return uiClassID;
        }
    }
}

