/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.sextante.gui;

import es.unex.sextante.core.IInputFactory;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.toolbox.ToolboxPanel;
import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.IWindowListener;
import org.gvsig.andami.ui.mdiManager.WindowInfo;

public abstract class GeoprocessWindow
extends JPanel
implements IWindow,
IWindowListener {
    private static final long serialVersionUID = -677659097155651764L;
    private WindowInfo windowInfo;
    private ToolboxPanel toolboxPanel;
    protected JComponent mainComponent;

    public GeoprocessWindow(ToolboxPanel toolbox) {
        this.toolboxPanel = toolbox;
        this.initializeDataObjects();
        this.initializeUI();
        this.windowInfo = this.createWindowInfo();
    }

    protected void initializeDataObjects() {
        IInputFactory inputFactory = SextanteGUI.getInputFactory();
        if (inputFactory.getDataObjects() == null) {
            inputFactory.createDataObjects();
        }
    }

    protected void initializeUI() {
        this.mainComponent = this.getMainComponent();
        this.setLayout(new BorderLayout(0, 0));
        this.add(this.mainComponent);
    }

    protected WindowInfo createWindowInfo() {
        WindowInfo windowInfo = new WindowInfo(7);
        windowInfo.setTitle(this.getTitle());
        windowInfo.setWidth(this.mainComponent.getWidth());
        windowInfo.setHeight(this.mainComponent.getHeight());
        return windowInfo;
    }

    public Object getWindowProfile() {
        return WindowInfo.EDITOR_PROFILE;
    }

    public WindowInfo getWindowInfo() {
        return this.windowInfo;
    }

    public void windowActivated() {
    }

    public void windowClosed() {
        if (this.toolboxPanel == null) {
            SextanteGUI.getInputFactory().clearDataObjects();
        }
    }

    protected abstract String getTitle();

    protected abstract JComponent getMainComponent();
}

