/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.base.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.Sextante;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.operation.tojts.ToJTS;
import org.gvsig.geoprocess.algorithm.base.util.JTSFacade;

public class GeometryUtil {
    private static GeometryFactory fact = new GeometryFactory();

    public static Geometry geomToJTS(org.gvsig.fmap.geom.Geometry g) {
        try {
            return (Geometry)g.invokeOperation(ToJTS.CODE, null);
        }
        catch (GeometryOperationNotSupportedException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        catch (GeometryOperationException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        return null;
    }

    public static org.gvsig.fmap.geom.Geometry jtsToGeom(Geometry g) {
        GeometryOperationContext ctx = new GeometryOperationContext();
        ctx.setAttribute("JTSGeometry", (Object)g);
        try {
            return (org.gvsig.fmap.geom.Geometry)GeometryLocator.getGeometryManager().invokeOperation("fromJTS", ctx);
        }
        catch (GeometryOperationNotSupportedException e) {
            Sextante.addErrorToLog((Throwable)e);
            return null;
        }
        catch (GeometryOperationException e) {
            Sextante.addErrorToLog((Throwable)e);
            return null;
        }
    }

    public static Geometry geometryUnion(List geometries, int geometryType) {
        Geometry[] geom = new Geometry[geometries.size()];
        geometries.toArray(geom);
        Geometry union = JTSFacade.union(geom, geometryType);
        return union;
    }

    public static Polygon removeDuplicates(Polygon polygon) {
        LineString shell = polygon.getExteriorRing();
        LineString newShell = GeometryUtil.removeDuplicates(shell);
        LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = (LinearRing)polygon.getInteriorRingN(i);
        }
        Polygon newPolygon = fact.createPolygon((LinearRing)newShell, holes);
        return newPolygon;
    }

    public static MultiPolygon removeDuplicates(MultiPolygon multiPolygon) {
        Polygon[] pols = new Polygon[multiPolygon.getNumGeometries()];
        for (int i = 0; i < pols.length; ++i) {
            Polygon newPol;
            Polygon pol = (Polygon)multiPolygon.getGeometryN(i);
            pols[i] = newPol = GeometryUtil.removeDuplicates(pol);
        }
        return fact.createMultiPolygon(pols);
    }

    public static Geometry removeDuplicatesFrom(Geometry geometry) {
        Object solution = null;
        solution = geometry instanceof LineString ? GeometryUtil.removeDuplicates((LineString)geometry) : (geometry instanceof Polygon ? GeometryUtil.removeDuplicates((Polygon)geometry) : (geometry instanceof MultiPolygon ? GeometryUtil.removeDuplicates((MultiPolygon)geometry) : geometry));
        return solution;
    }

    public static LineString removeDuplicates(LineString line) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate prevCoord = null;
        Coordinate actualCoord = null;
        int numPoints = line.getNumPoints();
        for (int i = 0; i < numPoints; ++i) {
            actualCoord = line.getCoordinateN(i);
            if (prevCoord != null) {
                if (!prevCoord.equals2D(actualCoord)) {
                    coordinates.add(actualCoord);
                }
            } else {
                coordinates.add(actualCoord);
            }
            prevCoord = actualCoord;
        }
        Coordinate[] newCoord = new Coordinate[coordinates.size()];
        coordinates.toArray(newCoord);
        if (line instanceof LineString) {
            return fact.createLineString(newCoord);
        }
        return fact.createLinearRing(newCoord);
    }
}

