/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParametersBase;
import org.gvsig.sqlite.dal.SQLiteConnectionParameters;
import org.gvsig.sqlite.dal.SQLiteConnectionParametersHelper;
import org.gvsig.sqlite.dal.SQLiteUtils;

public class SQLiteStoreParameters
extends JDBCStoreParametersBase
implements SQLiteConnectionParameters {
    private final SQLiteConnectionParametersHelper helper = new SQLiteConnectionParametersHelper(this);

    public SQLiteStoreParameters() {
        super("SQLiteStoreParameters", "SQLite");
    }

    public String getUrl() {
        return this.helper.getUrl();
    }

    public void validate() throws ValidateDataParametersException {
        this.helper.validate();
        super.validate();
    }

    @Override
    public boolean getEnableLoadExtension() {
        return this.helper.getEnableLoadExtension();
    }

    @Override
    public boolean getEnableSharedCache() {
        return this.helper.getEnableSharedCache();
    }

    @Override
    public void setEnableLoadExtension(boolean v) {
        this.helper.setEnableLoadExtension(v);
    }

    @Override
    public void setEnableSharedCache(boolean v) {
        this.helper.setEnableSharedCache(v);
    }

    @Override
    public Properties getProperties() {
        return this.helper.getProperties();
    }

    public File getFile() {
        return this.helper.getFile();
    }

    public void setFile(File database) {
        this.helper.setFile(database);
    }

    public boolean isTheSameExplorer(DataStoreParameters params) {
        block4: {
            if (!(params instanceof SQLiteStoreParameters)) {
                return false;
            }
            File f1 = SQLiteUtils.normalizeFile(this.getFile());
            File f2 = SQLiteUtils.normalizeFile(((SQLiteStoreParameters)params).getFile());
            try {
                if (!FilenameUtils.equalsOnSystem((String)f1.getCanonicalPath(), (String)f2.getCanonicalPath())) {
                    return false;
                }
            }
            catch (IOException ex) {
                if (FilenameUtils.equalsOnSystem((String)f1.getAbsolutePath(), (String)f2.getAbsolutePath())) break block4;
                return false;
            }
        }
        return true;
    }

    public String getSourceId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTable());
        builder.append("(");
        boolean needComma = false;
        File f = this.getFile();
        if (f != null) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("file=");
            builder.append(this.getFile().getAbsolutePath());
        }
        builder.append(")");
        return builder.toString();
    }
}

