/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.expressionbuilderformatter;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.gvsig.sqlite.dal.geopackage.index.GeopackageIndex;

public class ST_Intersects
implements Formatter<ExpressionBuilder.Value> {
    private final SQLBuilder sqlbuilder;
    private final Formatter<ExpressionBuilder.Value> formatter;

    public ST_Intersects(SQLBuilder sqlbuilder, Formatter<ExpressionBuilder.Value> formatter) {
        this.sqlbuilder = sqlbuilder;
        this.formatter = formatter;
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        if (value instanceof ExpressionBuilder.Function) {
            return StringUtils.equalsIgnoreCase((CharSequence)"ST_Intersects", (CharSequence)((ExpressionBuilder.Function)value).name());
        }
        return false;
    }

    public String format(ExpressionBuilder.Value function) {
        List parameters = ((ExpressionBuilder.Function)function).parameters();
        ExpressionBuilder.Value p1 = (ExpressionBuilder.Value)parameters.get(0);
        ExpressionBuilder.Value p2 = (ExpressionBuilder.Value)parameters.get(1);
        String p1s = p1.toString(this.formatter);
        String p2s = p2.toString(this.formatter);
        String filter = ST_Intersects.getBBoxIntersectsFilter(this.formatter, p1, p2);
        if (filter == null) {
            filter = ST_Intersects.getBBoxIntersectsFilter(this.formatter, p2, p1);
        }
        String r = filter == null ? MessageFormat.format("ST_Intersects(({0}),({1}))", p1s, p2s) : MessageFormat.format("( ({2}) AND ST_Intersects(({0}),({1}) ))", p1s, p2s, filter);
        return r;
    }

    static String getBBoxIntersectsFilter(Formatter<ExpressionBuilder.Value> formatter, ExpressionBuilder.Value column, ExpressionBuilder.Value expression) {
        Code geomcode;
        GeopackageIndex index;
        FeatureType featureType;
        if (!(column instanceof ExpressionBuilder.Variable)) {
            return null;
        }
        String tableName = (String)column.getProperty("TableName");
        if (StringUtils.isBlank((CharSequence)tableName)) {
            SQLBuilder.TableNameBuilder tableNameBuilder = (SQLBuilder.TableNameBuilder)column.getProperty("Table");
            if (tableNameBuilder == null) {
                return null;
            }
            tableName = tableNameBuilder.getName();
        }
        if ((featureType = (FeatureType)column.getProperty("FeatureType")) == null) {
            return null;
        }
        Object[] attrpk = featureType.getPrimaryKey();
        if (ArrayUtils.isEmpty((Object[])attrpk) || attrpk.length != 1) {
            return null;
        }
        Object attrid = attrpk[0];
        ExpressionBuilder.Variable variable = (ExpressionBuilder.Variable)column;
        FeatureAttributeDescriptor attrgeom = featureType.getAttributeDescriptor(variable.name());
        if (attrgeom == null) {
            FeatureQuery query = (FeatureQuery)column.getProperty("Query");
            if (query == null) {
                return null;
            }
            attrgeom = query.getExtraColumn().get(variable.name());
            if (attrgeom == null) {
                return null;
            }
        }
        if ((index = GeopackageUtils.getIndexManager().getGeometryIndex(attrgeom)) == null) {
            return null;
        }
        ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        try {
            geomcode = expressionManager.compile(expression.toString());
            MutableSymbolTable symbolTable = expressionManager.createSymbolTable();
            geomcode.link((SymbolTable)symbolTable);
            geomcode = expressionManager.optimize((SymbolTable)symbolTable, geomcode);
        }
        catch (Exception ex) {
            return null;
        }
        if (geomcode.code() == 0) {
            Object go = ((Code.Constant)geomcode).value();
            if (go instanceof Geometry) {
                String filter = index.getBBoxIntersectsFilter(tableName, attrid.getName(), attrgeom.getName(), (Geometry)go);
                return filter;
            }
            if (go instanceof byte[]) {
                try {
                    Geometry geom = GeometryUtils.createFrom((Object)go);
                    String filter = index.getBBoxIntersectsFilter(tableName, attrid.getName(), attrgeom.getName(), geom);
                    return filter;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        String filter = index.getBBoxIntersectsFilter(tableName, attrid.getName(), attrgeom.getName(), "ST_MinX(" + expression.toString(formatter) + ")", "ST_MinY(" + expression.toString(formatter) + ")", "ST_MaxX(" + expression.toString(formatter) + ")", "ST_MaxY(" + expression.toString(formatter) + ")");
        return filter;
    }
}

