/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.SQLException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_EndPoint
extends Functions.AbstractFunction {
    public ST_EndPoint(SQLiteConnection conn) {
        super("ST_EndPoint", conn);
    }

    protected void xFunc() throws SQLException {
        try {
            byte[] bytes = this.value_blob(0);
            if (bytes == null) {
                this.result();
                return;
            }
            SQLiteConnection conn = this.getConnection();
            GeopackageGeometryParser parser = GeopackageUtils.createGeometryParser();
            Geometry geom = parser.parseToGeometry(conn, bytes);
            if (geom == null) {
                this.result();
                return;
            }
            GeopackageGeometryBuilder builder = GeopackageUtils.createGeometryBuilder();
            if (geom instanceof OrientablePrimitive) {
                int n = ((OrientablePrimitive)geom).getNumVertices();
                Point p = ((OrientablePrimitive)geom).getVertex(n - 1);
                builder.setGeometry(conn, (Geometry)p);
            }
            if ((bytes = builder.build()) == null) {
                this.result();
            } else {
                this.result(bytes);
            }
        }
        catch (Throwable ex) {
            throw new SQLException("Can't get geometry's end point", ex);
        }
    }
}

