/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.SQLException;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_SRID
extends Functions.AbstractFunction {
    public ST_SRID(SQLiteConnection conn) {
        super("ST_SRID", conn);
    }

    protected void xFunc() throws SQLException {
        try {
            byte[] bytes1 = this.value_blob(0);
            if (bytes1 == null) {
                this.result();
                return;
            }
            SQLiteConnection conn = this.getConnection();
            GeopackageGeometryParser parser = GeopackageUtils.createGeometryParser();
            Geometry geom1 = parser.parseToGeometry(conn, bytes1);
            if (geom1 == null) {
                this.result();
                return;
            }
            IProjection projection = geom1.getProjection();
            if (projection == null) {
                this.result(0);
                return;
            }
            String[] x = projection.getAbrev().split(":");
            try {
                int code = Integer.parseInt(x[1]);
                this.result(code);
            }
            catch (Exception ex) {
                this.result(-1);
            }
        }
        catch (Throwable ex) {
            throw new SQLException("Can't get the geometry's projection", ex);
        }
    }
}

