/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.geopackage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

class ByteReader {
    private static final Logger logger = Logger.getLogger(ByteReader.class.getName());
    public static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private static final String CHAR_SET = "UTF-8";
    private final byte[] bytes;
    private final InputStream inputStream;
    private int nextByte = 0;
    private ByteOrder byteOrder = DEFAULT_BYTE_ORDER;

    public ByteReader(byte[] bytes) {
        this.bytes = bytes;
        this.inputStream = new ByteArrayInputStream(bytes);
    }

    public ByteReader(InputStream inputStream) {
        this.bytes = null;
        this.inputStream = inputStream;
    }

    public ByteReader(byte[] bytes, ByteOrder byteOrder) {
        this(bytes);
        this.byteOrder = byteOrder;
    }

    public ByteReader(InputStream inputStream, ByteOrder byteOrder) {
        this(inputStream);
        this.byteOrder = byteOrder;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to close byte reader intput stream", e);
        }
    }

    public int getNextByte() {
        return this.nextByte;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String readString(int num) throws IOException {
        return new String(this.readBytes(num), CHAR_SET);
    }

    public byte[] readBytes(int num) throws IOException {
        this.verifyRemainingBytes(num);
        byte[] bytes = new byte[num];
        this.inputStream.read(bytes);
        this.nextByte += num;
        return bytes;
    }

    public byte readByte() throws IOException {
        return this.readBytes(1)[0];
    }

    public int readInt() throws IOException {
        return ByteBuffer.wrap(this.readBytes(4)).order(this.byteOrder).getInt();
    }

    public long readUnsignedInt() throws IOException {
        int intValue = this.readInt();
        long value = (long)intValue & 0xFFFFFFFFL;
        return value;
    }

    public double readDouble() throws IOException {
        return ByteBuffer.wrap(this.readBytes(8)).order(this.byteOrder).getDouble();
    }

    private void verifyRemainingBytes(int bytesToRead) {
        if (this.bytes != null && this.nextByte + bytesToRead > this.bytes.length) {
            throw new RuntimeException("No more remaining bytes to read. Total Bytes: " + this.bytes.length + ", Bytes already read: " + this.nextByte + ", Attempted to read: " + bytesToRead);
        }
    }
}

